/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzay;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class zzav {
    private BlockingQueue<zzay> zzsf;
    private ExecutorService zzsg;
    private int zzrZ;
    private int zzsa;
    private int zzsb;
    private int zzsc;
    private LinkedHashMap<String, String> zzsh = new LinkedHashMap();
    private String zzsd;
    private final Context mContext;
    private final String zzoc;
    private AtomicBoolean zzsi;
    private File zzsj;

    public zzav(Context context, String string, String string2, int n, int n2, int n3, int n4, Map<String, String> map, int n5) {
        Object object;
        this.mContext = context;
        this.zzoc = string;
        this.zzsd = string2;
        this.zzsa = n;
        this.zzsb = n2;
        this.zzsc = n3;
        this.zzl(n4);
        this.zzsi = new AtomicBoolean(false);
        this.zzsi.set(zzat.zzrF.get());
        if (this.zzsi.get() && (object = Environment.getExternalStorageDirectory()) != null) {
            this.zzsj = new File((File)object, "sdk_csi_data.txt");
        }
        for (Map.Entry entry : map.entrySet()) {
            this.zze((String)entry.getKey(), (String)entry.getValue());
        }
        if (n5 == 1) {
            this.zzco();
        }
        if (n5 == 2) {
            this.zzcp();
        }
        this.init();
    }

    private void zzco() {
        this.zzc(zzat.zzcg());
    }

    private void zzcp() {
        this.zzc(zzat.zzp(this.mContext));
    }

    private void zzc(List<String> list) {
        if (list != null && !list.isEmpty()) {
            this.zze("eid", TextUtils.join((CharSequence)",", list));
        }
    }

    private void init() {
        this.zzsf = new ArrayBlockingQueue<zzay>(this.zzsa);
        this.zzsg = Executors.newSingleThreadExecutor();
        this.zzsg.execute(new Runnable(){

            @Override
            public void run() {
                zzav.this.zzcq();
            }
        });
    }

    public boolean zza(zzay zzay2) {
        return this.zzsf.offer(zzay2);
    }

    /*
     * Unable to fully structure code
     */
    private void zzcq() {
        block2: while (true) {
            var1_1 = null;
            try {
                var1_1 = this.zzk(this.zzrZ);
            }
            catch (InterruptedException var2_3) {
                zzb.zzd("CsiReporter:reporter interrupted", var2_3);
                break;
            }
            if (var1_1 == null) continue;
            var2_2 = this.zzd(var1_1);
            var3_4 = var2_2.values().iterator();
            while (true) {
                if (var3_4.hasNext()) ** break;
                continue block2;
                var4_5 = var3_4.next();
                this.zzb(var4_5);
            }
            break;
        }
    }

    private boolean zzb(Map<String, String> map) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.zzsb; ++i) {
            try {
                Thread.sleep(this.zzsc);
                String string = this.zza(this.zzsd, map);
                if (this.zzsi.get()) {
                    this.zza(this.zzsj, string);
                } else {
                    zzh.zzaQ().zzc(this.mContext, this.zzoc, string);
                }
                bl = true;
                continue;
            }
            catch (InterruptedException interruptedException) {
                zzb.zzd("CsiReporter: interrupted in sendReport()", interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        return bl;
    }

    private List<zzay> zzk(int n) throws InterruptedException {
        ArrayList<zzay> arrayList = new ArrayList<zzay>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.zzsf.take());
        }
        return arrayList;
    }

    Map<String, Map<String, String>> zzd(List<zzay> list) {
        List list2;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (zzay object : list) {
            String string = object.zzcw();
            if (linkedHashMap.containsKey(string)) {
                ((List)linkedHashMap.get(string)).add(object);
                continue;
            }
            list2 = new ArrayList<zzay>();
            list2.add(object);
            linkedHashMap.put(string, list2);
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            list2 = (List)entry.getValue();
            LinkedHashMap<String, String> linkedHashMap3 = new LinkedHashMap<String, String>(this.zzsh);
            Map<String, String> map = null;
            try {
                map = zzay.zza(list2.toArray(new zzay[list2.size()]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzb.zzd("CsiReporter:failed to merge tickers:" + list2, illegalArgumentException);
                continue;
            }
            linkedHashMap3.putAll(map);
            linkedHashMap2.put(entry.getKey(), linkedHashMap3);
        }
        return linkedHashMap2;
    }

    String zza(String string, Map<String, String> map) {
        Uri.Builder builder = Uri.parse((String)string).buildUpon();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.build().toString();
    }

    void zze(String string, String string2) {
        this.zzsh.put(string, string2);
    }

    private void zzl(int n) {
        int n2 = n;
        if (n2 < 1) {
            zzb.zzan("CsiReporter - too small batch size :" + n2 + ", changed to 1");
            n2 = 1;
        }
        if (n2 > this.zzsa) {
            zzb.zzan("CsiReporter - batch size :" + n2 + " bigger than buffer size, " + "change to buffer limit");
            n2 = this.zzsa;
        }
        this.zzrZ = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(File file, String string) {
        if (file != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(string.getBytes());
                fileOutputStream.write(10);
            }
            catch (IOException iOException) {
                zzb.zzd("CsiReporter: Cannot write to file: sdk_csi_data.txt.", iOException);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    zzb.zzd("CsiReporter: Cannot close file: sdk_csi_data.txt.", iOException);
                }
            }
        } else {
            zzb.zzan("CsiReporter: File doesn't exists. Cannot write CSI data to file.");
        }
    }
}

