/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzh;
import com.google.android.gms.internal.zzal;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzfg;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzeo
public final class zzer {
    private static final SimpleDateFormat zzAt = new SimpleDateFormat("yyyyMMdd");

    public static JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, zzev zzev2, Location location, zzal zzal2, String string2, String string3, List<String> list) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzyV != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzyV);
            }
            zzer.zza(hashMap, adRequestInfoParcel.zzyW);
            hashMap.put("format", adRequestInfoParcel.zzmP.zzpX);
            if (adRequestInfoParcel.zzmP.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzmP.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzmP.zzpZ != null) {
                charSequence = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzmP.zzpZ) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzev2.zzzi) : adSizeParcel.width);
                    charSequence.append("x");
                    charSequence.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzev2.zzzi) : adSizeParcel.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (adRequestInfoParcel.zzzc != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzzc);
                hashMap.put("native_templates", adRequestInfoParcel.zzmZ);
            }
            hashMap.put("slotname", adRequestInfoParcel.zzmG);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzyX != null) {
                hashMap.put("vc", adRequestInfoParcel.zzyX.versionCode);
            }
            hashMap.put("ms", string3);
            hashMap.put("seq_num", adRequestInfoParcel.zzyZ);
            hashMap.put("session_id", adRequestInfoParcel.zzza);
            hashMap.put("js", adRequestInfoParcel.zzmJ.zzCI);
            zzer.zza(hashMap, zzev2);
            hashMap.put("fdz", new Integer(zzal2.zzcc()));
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (adRequestInfoParcel.zzyW.versionCode >= 2 && adRequestInfoParcel.zzyW.zzpQ != null) {
                zzer.zza(hashMap, adRequestInfoParcel.zzyW.zzpQ);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzzb);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzze) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzze);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzzd != null) {
                hashMap.put("content_info", adRequestInfoParcel.zzzd);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzzi));
                hashMap.put("sh", adRequestInfoParcel.zzzh);
                hashMap.put("sw", adRequestInfoParcel.zzzg);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzev2.zzzi));
                hashMap.put("sh", zzev2.zzzh);
                hashMap.put("sw", zzev2.zzzg);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzzj)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzzj));
                    }
                    catch (JSONException jSONException) {
                        zzb.zzd("Problem serializing view hierarchy to JSON", jSONException);
                    }
                }
                if (zzat.zzrQ.get().booleanValue() && adRequestInfoParcel.zzzk) {
                    hashMap.put("ga_hid", adRequestInfoParcel.zzzl);
                    hashMap.put("ga_cid", adRequestInfoParcel.zzzm);
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzzn);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzzo);
            }
            zzer.zza(hashMap, string2);
            if (zzb.zzC(2)) {
                charSequence = zzh.zzaQ().zzx(hashMap).toString(2);
                zzb.zzam("Ad Request JSON: " + (String)charSequence);
            }
            return zzh.zzaQ().zzx(hashMap);
        }
        catch (JSONException jSONException) {
            zzb.zzan("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        if (string2 != null) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("token", string2);
            hashMap.put("pan", hashMap2);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzfg.zzeV();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzpI != -1L) {
            hashMap.put("cust_age", zzAt.format(new Date(adRequestParcel.zzpI)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzpJ != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzpJ);
        }
        if (adRequestParcel.zzpK != null) {
            hashMap.put("kw", adRequestParcel.zzpK);
        }
        if (adRequestParcel.zzpM != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzpM);
        }
        if (adRequestParcel.zzpL) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzpN) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzpO)) {
                hashMap.put("ppid", adRequestParcel.zzpO);
            }
            if (adRequestParcel.zzpP != null) {
                zzer.zza(hashMap, adRequestParcel.zzpP);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzpR != null) {
            hashMap.put("url", adRequestParcel.zzpR);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzpT != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzpT);
            }
            if (adRequestParcel.zzpU != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzpU);
            }
            if (adRequestParcel.zzpV != null) {
                hashMap.put("request_agent", adRequestParcel.zzpV);
            }
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzev zzev2) {
        hashMap.put("am", zzev2.zzAY);
        hashMap.put("cog", zzer.zzx(zzev2.zzAZ));
        hashMap.put("coh", zzer.zzx(zzev2.zzBa));
        if (!TextUtils.isEmpty((CharSequence)zzev2.zzBb)) {
            hashMap.put("carrier", zzev2.zzBb);
        }
        hashMap.put("gl", zzev2.zzBc);
        if (zzev2.zzBd) {
            hashMap.put("simulator", 1);
        }
        hashMap.put("ma", zzer.zzx(zzev2.zzBe));
        hashMap.put("sp", zzer.zzx(zzev2.zzBf));
        hashMap.put("hl", zzev2.zzBg);
        if (!TextUtils.isEmpty((CharSequence)zzev2.zzBh)) {
            hashMap.put("mv", zzev2.zzBh);
        }
        hashMap.put("muv", zzev2.zzBi);
        if (zzev2.zzBj != -2) {
            hashMap.put("cnt", zzev2.zzBj);
        }
        hashMap.put("gnt", zzev2.zzBk);
        hashMap.put("pt", zzev2.zzBl);
        hashMap.put("rm", zzev2.zzBm);
        hashMap.put("riv", zzev2.zzBn);
        Bundle bundle = new Bundle();
        bundle.putInt("active_network_state", zzev2.zzBr);
        bundle.putBoolean("active_network_metered", zzev2.zzBq);
        hashMap.put("connectivity", bundle);
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("is_charging", zzev2.zzBp);
        bundle2.putDouble("battery_level", zzev2.zzBo);
        hashMap.put("battery", bundle2);
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzqL) != 0) {
            hashMap.put("acolor", zzer.zzA(searchAdRequestParcel.zzqL));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzer.zzA(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzqM) != 0 && Color.alpha((int)searchAdRequestParcel.zzqN) != 0) {
            hashMap.put("gradientto", zzer.zzA(searchAdRequestParcel.zzqM));
            hashMap.put("gradientfrom", zzer.zzA(searchAdRequestParcel.zzqN));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzqO) != 0) {
            hashMap.put("bcolor", zzer.zzA(searchAdRequestParcel.zzqO));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzqP));
        switch (searchAdRequestParcel.zzqQ) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzqR) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzqS != null) {
            hashMap.put("channel", searchAdRequestParcel.zzqS);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzqT) != 0) {
            hashMap.put("dcolor", zzer.zzA(searchAdRequestParcel.zzqT));
        }
        if (searchAdRequestParcel.zzqU != null) {
            hashMap.put("font", searchAdRequestParcel.zzqU);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzqV) != 0) {
            hashMap.put("hcolor", zzer.zzA(searchAdRequestParcel.zzqV));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzqW));
        if (searchAdRequestParcel.zzqX != null) {
            hashMap.put("q", searchAdRequestParcel.zzqX);
        }
    }

    private static Integer zzx(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzA(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_html", null);
            long l = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzh.zzaS().zzff();
            } else if ("landscape".equals(string8)) {
                n = zzh.zzaS().zzfe();
            }
            AdResponseParcel adResponseParcel = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzb.zzan("Could not parse the mediation config: Missing required ad_base_url field");
                    return new AdResponseParcel(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzeq.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzmJ.zzCI, string4, null, null, null);
                string3 = adResponseParcel.zzwB;
                string6 = adResponseParcel.zzzr;
                l = adResponseParcel.zzzx;
            } else {
                zzb.zzan("Could not parse the mediation config: Missing required ad_html or ad_url field.");
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzuC;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    list3.add(jSONArray.getString(i));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzuD;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    list2.add(jSONArray2.getString(i));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzzv;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray3.length(); ++i) {
                    list.add(jSONArray3.getString(i));
                }
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzzs > 0L) {
                    l2 = adResponseParcel.zzzs;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl2 = jSONObject.optBoolean("mediation", false);
            boolean bl3 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl4 = jSONObject.optBoolean("native", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            int n2 = jSONObject.optInt("oauth2_token_status", 0);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            return new AdResponseParcel(adRequestInfoParcel, string3, string6, list3, list2, l2, bl2, l4, list, l3, n, string5, l, string7, bl, string10, string9, bl3, bl4, adRequestInfoParcel.zzze, bl5, bl6, n2);
        }
        catch (JSONException jSONException) {
            zzb.zzan("Could not parse the mediation config: " + jSONException.getMessage());
            return new AdResponseParcel(0);
        }
    }
}

