/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public class zzh {
    private final Object zzpc = new Object();
    private final zzn zzwb;
    private final Context mContext;
    private final JSONObject zzwe;
    private final zzbb zzwf;
    private final zza zzwg;
    private final zzan zzwh;
    private final VersionInfoParcel zzpa;
    private boolean zzwi;
    private zzip zzoL;
    private String zzwj;

    public zzh(Context context, zzn zzn2, zzbb zzbb2, zzan zzan2, JSONObject jSONObject, zza zza2, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzwb = zzn2;
        this.zzwf = zzbb2;
        this.zzwh = zzan2;
        this.zzwe = jSONObject;
        this.zzwg = zza2;
        this.zzpa = versionInfoParcel;
    }

    public zzb zza(View.OnClickListener onClickListener) {
        com.google.android.gms.ads.internal.formats.zza zza2 = this.zzwg.zzdv();
        if (zza2 == null) {
            return null;
        }
        zzb zzb2 = new zzb(this.mContext, zza2);
        zzb2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb2.zzdq().setOnClickListener(onClickListener);
        zzb2.zzdq().setContentDescription((CharSequence)"Ad attribution icon");
        return zzb2;
    }

    public void performClick(String assetId) {
        zzx.zzch((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("asset", (Object)assetId);
            jSONObject.put("template", (Object)this.zzwg.zzdu());
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("ad", (Object)this.zzwe);
            jSONObject2.put("click", (Object)jSONObject);
            jSONObject2.put("has_custom_click_handler", this.zzwb.zzr(this.zzwg.getCustomTemplateId()) != null);
            this.zzwf.zza("google.afma.nativeAds.handleClickGmsg", jSONObject2);
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to create click JSON.", jSONException);
        }
    }

    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzx.zzch((String)"performClick must be called on the main UI thread.");
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (!view.equals(view2)) continue;
            this.performClick(entry.getKey());
            break;
        }
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzwh.zza(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzi(View view) {
        Object object = this.zzpc;
        synchronized (object) {
            if (this.zzwi) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.recordImpression();
        }
    }

    public void recordImpression() {
        zzx.zzch((String)"recordImpression must be called on the main UI thread.");
        this.zzl(true);
        this.zzwb.zzaP();
    }

    public void zzh(View view) {
    }

    public zzip zzdy() {
        this.zzoL = this.zzdz();
        this.zzoL.getWebView().setVisibility(8);
        this.zzwf.zza("/loadHtml", new zzdg(){

            @Override
            public void zza(zzip zzip2, final Map<String, String> map) {
                zzh.this.zzoL.zzgS().zza(new zziq.zza(){

                    @Override
                    public void zza(zzip zzip2, boolean bl) {
                        zzh.this.zzwj = (String)map.get("id");
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("messageType", (Object)"htmlLoaded");
                            jSONObject.put("id", (Object)zzh.this.zzwj);
                            zzh.this.zzwf.zzb("sendMessageToNativeJs", jSONObject);
                        }
                        catch (JSONException jSONException) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to dispatch sendMessageToNativeJsevent", jSONException);
                        }
                    }
                });
                String string = map.get("overlayHtml");
                zzh.this.zzoL.loadData(string, "text/html", "UTF-8");
            }
        });
        this.zzwf.zza("/showOverlay", new zzdg(){

            @Override
            public void zza(zzip zzip2, Map<String, String> map) {
                zzh.this.zzoL.getWebView().setVisibility(0);
            }
        });
        this.zzwf.zza("/hideOverlay", new zzdg(){

            @Override
            public void zza(zzip zzip2, Map<String, String> map) {
                zzh.this.zzoL.getWebView().setVisibility(8);
            }
        });
        this.zzoL.zzgS().zza("/hideOverlay", new zzdg(){

            @Override
            public void zza(zzip zzip2, Map<String, String> map) {
                zzh.this.zzoL.getWebView().setVisibility(8);
            }
        });
        this.zzoL.zzgS().zza("/sendMessageToSdk", new zzdg(){

            @Override
            public void zza(zzip zzip2, Map<String, String> map) {
                JSONObject jSONObject = new JSONObject();
                try {
                    for (String string : map.keySet()) {
                        jSONObject.put(string, (Object)map.get(string));
                    }
                    jSONObject.put("id", (Object)zzh.this.zzwj);
                    zzh.this.zzwf.zzb("sendMessageToNativeJs", jSONObject);
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Unable to dispatch sendMessageToNativeJs event", jSONException);
                }
            }
        });
        return this.zzoL;
    }

    protected void zzl(boolean bl) {
        this.zzwi = bl;
    }

    zzip zzdz() {
        return zzp.zzby().zza(this.mContext, AdSizeParcel.zzs(this.mContext), false, false, this.zzwh, this.zzpa);
    }

    public static interface zza {
        public void zza(zzh var1);

        public String zzdu();

        public String getCustomTemplateId();

        public com.google.android.gms.ads.internal.formats.zza zzdv();
    }
}

