/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.Parcel;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzgr;

@zzgr
public class AdSizeParcel
implements SafeParcelable {
    public static final zzi CREATOR = new zzi();
    public final int versionCode;
    public final String zzte;
    public final int height;
    public final int heightPixels;
    public final boolean zztf;
    public final int width;
    public final int widthPixels;
    public final AdSizeParcel[] zztg;
    public final boolean zzth;
    public final boolean zzti;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)AdSizeParcel.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static AdSizeParcel zzs(Context context) {
        return new AdSizeParcel(4, "320x50_mb", 0, 0, false, 0, 0, null, true, false);
    }

    public static AdSizeParcel zzcC() {
        return new AdSizeParcel(4, "reward_mb", 0, 0, false, 0, 0, null, false, false);
    }

    public AdSizeParcel() {
        this(4, "interstitial_mb", 0, 0, true, 0, 0, null, false, false);
    }

    public AdSizeParcel(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public AdSizeParcel(Context context, AdSize[] adSizes) {
        int n;
        AdSize adSize = adSizes[0];
        this.versionCode = 4;
        this.zztf = false;
        this.zzti = adSize.isFluid();
        if (this.zzti) {
            this.width = AdSize.BANNER.getWidth();
            this.height = AdSize.BANNER.getHeight();
        } else {
            this.width = adSize.getWidth();
            this.height = adSize.getHeight();
        }
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzl.zzcF().zzS(context) && zzl.zzcF().zzT(context) ? AdSizeParcel.zza(displayMetrics) - zzl.zzcF().zzU(context) : AdSizeParcel.zza(displayMetrics);
            double d = (float)this.widthPixels / displayMetrics.density;
            n = (int)d;
            if (d - (double)((int)d) >= 0.01) {
                ++n;
            }
        } else {
            n = this.width;
            this.widthPixels = zzl.zzcF().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? AdSizeParcel.zzc(displayMetrics) : this.height;
        this.heightPixels = zzl.zzcF().zza(displayMetrics, n2);
        this.zzte = bl || bl2 ? n + "x" + n2 + "_as" : (this.zzti ? "320x50_mb" : adSize.toString());
        if (adSizes.length > 1) {
            this.zztg = new AdSizeParcel[adSizes.length];
            for (int i = 0; i < adSizes.length; ++i) {
                this.zztg[i] = new AdSizeParcel(context, adSizes[i]);
            }
        } else {
            this.zztg = null;
        }
        this.zzth = false;
    }

    public AdSizeParcel(AdSizeParcel adSize, AdSizeParcel[] supportedAdSizes) {
        this(4, adSize.zzte, adSize.height, adSize.heightPixels, adSize.zztf, adSize.width, adSize.widthPixels, supportedAdSizes, adSize.zzth, adSize.zzti);
    }

    AdSizeParcel(int versionCode, String formatString, int height, int heightPixels, boolean isInterstitial, int width, int widthPixels, AdSizeParcel[] supportedAdSizes, boolean isNative, boolean isFluid) {
        this.versionCode = versionCode;
        this.zzte = formatString;
        this.height = height;
        this.heightPixels = heightPixels;
        this.zztf = isInterstitial;
        this.width = width;
        this.widthPixels = widthPixels;
        this.zztg = supportedAdSizes;
        this.zzth = isNative;
        this.zzti = isFluid;
    }

    public int describeContents() {
        return 0;
    }

    public AdSize zzcD() {
        return zza.zza(this.width, this.height, this.zzte);
    }

    public void writeToParcel(Parcel out, int flags) {
        zzi.zza(this, out, flags);
    }
}

