/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzco;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziz;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class zzj
extends zzco.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzpd = new Object();
    private final FrameLayout zzwU;
    private final FrameLayout zznZ;
    private final Map<String, WeakReference<View>> zzwV = new HashMap<String, WeakReference<View>>();
    private zzb zzwW;
    private zzh zzwx;
    boolean zzwX = false;
    int zzwY;
    int zzwZ;

    public zzj(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzwU = frameLayout;
        this.zznZ = frameLayout2;
        zziu.zza((View)this.zzwU, this);
        zziu.zza((View)this.zzwU, this);
        this.zzwU.setOnTouchListener((View.OnTouchListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(String string, zzd zzd2) {
        View view = (View)zze.zzp((zzd)zzd2);
        Object object = this.zzpd;
        synchronized (object) {
            if (view == null) {
                this.zzwV.remove(string);
            } else {
                this.zzwV.put(string, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzd zzW(String string) {
        Object object = this.zzpd;
        synchronized (object) {
            WeakReference<View> weakReference = this.zzwV.get(string);
            return zze.zzy(weakReference == null ? null : (View)weakReference.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzd zzd2) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzwX = true;
            final zzh zzh2 = (zzh)zze.zzp((zzd)zzd2);
            if (this.zzwx instanceof zzg && ((zzg)this.zzwx).zzdB()) {
                ((zzg)this.zzwx).zzb(zzh2);
            } else {
                this.zzwx = zzh2;
                if (this.zzwx instanceof zzg) {
                    ((zzg)this.zzwx).zzb((zzh)null);
                }
            }
            this.zznZ.removeAllViews();
            this.zzwW = this.zzf(zzh2);
            if (this.zzwW != null) {
                this.zzwV.put("1007", new WeakReference<ViewGroup>(this.zzwW.zzdu()));
                this.zznZ.addView((View)this.zzwW);
            }
            zzid.zzIE.post(new Runnable(){

                @Override
                public void run() {
                    zziz zziz2 = zzh2.zzdC();
                    if (zziz2 != null) {
                        zzj.this.zznZ.addView(zziz2.getView());
                    }
                }
            });
            zzh2.zzh((View)this.zzwU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzwx == null) {
                return;
            }
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<String, WeakReference<View>> entry : this.zzwV.entrySet()) {
                View view2 = (View)entry.getValue().get();
                Point point = this.zzj(view2);
                JSONObject jSONObject2 = new JSONObject();
                try {
                    jSONObject2.put("width", this.zzp(view2.getWidth()));
                    jSONObject2.put("height", this.zzp(view2.getHeight()));
                    jSONObject2.put("x", this.zzp(point.x));
                    jSONObject2.put("y", this.zzp(point.y));
                    jSONObject.put(entry.getKey(), (Object)jSONObject2);
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaH("Unable to get view rectangle for view " + entry.getKey());
                }
            }
            JSONObject jSONObject3 = new JSONObject();
            try {
                jSONObject3.put("x", this.zzp(this.zzwY));
                jSONObject3.put("y", this.zzp(this.zzwZ));
            }
            catch (JSONException jSONException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Unable to get click location");
            }
            if (this.zzwW != null && this.zzwW.zzdu().equals(view)) {
                this.zzwx.zza("1007", jSONObject, jSONObject3);
            } else {
                this.zzwx.zza(view, this.zzwV, jSONObject, jSONObject3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzwX) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0) {
                    this.zznZ.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzwX = false;
                }
            }
            if (this.zzwx != null) {
                this.zzwx.zzi((View)this.zzwU);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzwx != null) {
                this.zzwx.zzi((View)this.zzwU);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzwx == null) {
                return false;
            }
            Point point = this.zzc(motionEvent);
            this.zzwY = point.x;
            this.zzwZ = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzwx.zzb(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    Point zzc(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzwU.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    zzb zzf(zzh zzh2) {
        return zzh2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzwU.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzwU.getMeasuredHeight();
    }

    int zzp(int n) {
        return zzl.zzcF().zzc(this.zzwx.getContext(), n);
    }

    Point zzj(View view) {
        if (this.zzwW != null && this.zzwW.zzdu().equals(view)) {
            Point point = new Point();
            this.zzwU.getGlobalVisibleRect(new Rect(), point);
            Point point2 = new Point();
            view.getGlobalVisibleRect(new Rect(), point2);
            return new Point(point2.x - point.x, point2.y - point.y);
        }
        Point point = new Point();
        view.getGlobalVisibleRect(new Rect(), point);
        return point;
    }
}

