/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzgr;

@zzgr
public class zza {
    public boolean zza(Context context, AdLauncherIntentInfoParcel adLauncherIntentInfoParcel, zzn zzn2) {
        String[] stringArray;
        if (adLauncherIntentInfoParcel == null) {
            zzb.zzaH("No intent data for launcher overlay.");
            return false;
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.url)) {
            zzb.zzaH("Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.mimeType)) {
            intent.setDataAndType(Uri.parse((String)adLauncherIntentInfoParcel.url), adLauncherIntentInfoParcel.mimeType);
        } else {
            intent.setData(Uri.parse((String)adLauncherIntentInfoParcel.url));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.packageName)) {
            intent.setPackage(adLauncherIntentInfoParcel.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.zzAL)) {
            stringArray = adLauncherIntentInfoParcel.zzAL.split("/", 2);
            if (stringArray.length < 2) {
                zzb.zzaH("Could not parse component name from open GMSG: " + adLauncherIntentInfoParcel.zzAL);
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = adLauncherIntentInfoParcel.zzAM))) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaH("Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        try {
            zzb.v("Launching an intent: " + intent.toURI());
            zzp.zzbv().zzb(context, intent);
            if (zzn2 != null) {
                zzn2.zzaO();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzb.zzaH(activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

