/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzid;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzgr
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzAO = new HashMap<Integer, String>();
    private final zzp zzAP;
    private int zzAQ = 0;
    private int zzAR = 0;
    private MediaPlayer zzAS;
    private Uri zzAT;
    private int zzAU;
    private int zzAV;
    private int zzAW;
    private int zzAX;
    private int zzAY;
    private float zzAZ = 1.0f;
    private boolean zzBa;
    private boolean zzBb;
    private int zzBc;
    private zzh zzBd;

    public zzc(Context context, zzp zzp2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzAP = zzp2;
        this.zzAP.zza(this);
    }

    @Override
    public String zzer() {
        return "MediaPlayer";
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzBd = zzh2;
    }

    @Override
    public void setMimeType(String mimeType) {
    }

    @Override
    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.zzAT = uri;
        this.zzBc = 0;
        this.zzes();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzb.v("AdMediaPlayerView stop");
        if (this.zzAS != null) {
            this.zzAS.stop();
            this.zzAS.release();
            this.zzAS = null;
            this.zzt(0);
            this.zzu(0);
            this.zzev();
        }
        this.zzAP.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        zzb.v("AdMediaPlayerView size changed: " + width + " x " + height);
        this.zzAU = mp.getVideoWidth();
        this.zzAV = mp.getVideoHeight();
        if (this.zzAU != 0 && this.zzAV != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzb.v("AdMediaPlayerView prepared");
        this.zzt(2);
        this.zzAP.zzeR();
        zzid.zzIE.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzBd != null) {
                    zzc.this.zzBd.zzeR();
                }
            }
        });
        this.zzAU = mediaPlayer.getVideoWidth();
        this.zzAV = mediaPlayer.getVideoHeight();
        if (this.zzBc != 0) {
            this.seekTo(this.zzBc);
        }
        this.zzet();
        zzb.zzaG("AdMediaPlayerView stream dimensions: " + this.zzAU + " x " + this.zzAV);
        if (this.zzAR == 3) {
            this.play();
        }
        this.zzeu();
        this.zzeB();
    }

    public void onCompletion(MediaPlayer mp) {
        zzb.v("AdMediaPlayerView completion");
        this.zzt(5);
        this.zzu(5);
        zzid.zzIE.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzBd != null) {
                    zzc.this.zzBd.zzeT();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        String string = zzAO.get(what);
        String string2 = zzAO.get(extra);
        zzb.v("AdMediaPlayerView MediaPlayer info: " + string + ":" + string2);
        return true;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        final String string = zzAO.get(what);
        final String string2 = zzAO.get(extra);
        zzb.zzaH("AdMediaPlayerView MediaPlayer error: " + string + ":" + string2);
        this.zzt(-1);
        this.zzu(-1);
        zzid.zzIE.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzBd != null) {
                    zzc.this.zzBd.zzh(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.zzAW = percent;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        zzb.v("AdMediaPlayerView surface created");
        this.zzes();
        zzid.zzIE.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzBd != null) {
                    zzc.this.zzBd.zzeQ();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int w, int h) {
        boolean bl;
        zzb.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzAR == 3;
        boolean bl3 = bl = this.zzAU == w && this.zzAV == h;
        if (this.zzAS != null && bl2 && bl) {
            if (this.zzBc != 0) {
                this.seekTo(this.zzBc);
            }
            this.play();
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        zzb.v("AdMediaPlayerView surface destroyed");
        if (this.zzAS != null && this.zzBc == 0) {
            this.zzBc = this.zzAS.getCurrentPosition();
        }
        zzid.zzIE.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzBd != null) {
                    zzc.this.zzBd.onPaused();
                    zzc.this.zzBd.zzeU();
                }
            }
        });
        this.zzt(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.zzAP.zzb(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = zzc.getDefaultSize((int)this.zzAU, (int)widthMeasureSpec);
        int n2 = zzc.getDefaultSize((int)this.zzAV, (int)heightMeasureSpec);
        if (this.zzAU > 0 && this.zzAV > 0) {
            int n3 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n6 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (n3 == 0x40000000 && n5 == 0x40000000) {
                n2 = n6;
                n = n4;
                if (this.zzAU * n2 < n * this.zzAV) {
                    n = n2 * this.zzAU / this.zzAV;
                } else if (this.zzAU * n2 > n * this.zzAV) {
                    n2 = n * this.zzAV / this.zzAU;
                }
            } else if (n3 == 0x40000000) {
                n = n4;
                n2 = n * this.zzAV / this.zzAU;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                }
            } else if (n5 == 0x40000000) {
                n2 = n6;
                n = n2 * this.zzAU / this.zzAV;
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                }
            } else {
                n = this.zzAU;
                n2 = this.zzAV;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                    n = n2 * this.zzAU / this.zzAV;
                }
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                    n2 = n * this.zzAV / this.zzAU;
                }
            }
        }
        this.setMeasuredDimension(n, n2);
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzAX > 0 && this.zzAX != n || this.zzAY > 0 && this.zzAY != n2) {
                this.zzet();
            }
            this.zzAX = n;
            this.zzAY = n2;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private void zzes() {
        zzb.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzAT == null || surfaceTexture == null) {
            return;
        }
        this.zzt(false);
        try {
            this.zzAS = new MediaPlayer();
            this.zzAS.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzAS.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzAS.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzAS.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzAS.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzAS.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzAW = 0;
            this.zzAS.setDataSource(this.getContext(), this.zzAT);
            this.zzAS.setSurface(new Surface(surfaceTexture));
            this.zzAS.setAudioStreamType(3);
            this.zzAS.setScreenOnWhilePlaying(true);
            this.zzAS.prepareAsync();
            this.zzt(1);
        }
        catch (IOException | IllegalArgumentException exception) {
            zzb.zzd("Failed to initialize MediaPlayer at " + this.zzAT, exception);
            this.onError(this.zzAS, 1, 0);
        }
    }

    private void zzet() {
        if (this.zzew() && this.zzAS.getCurrentPosition() > 0 && this.zzAR != 3) {
            long l;
            zzb.v("AdMediaPlayerView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzAS.start();
            int n = this.zzAS.getCurrentPosition();
            long l2 = com.google.android.gms.ads.internal.zzp.zzbz().currentTimeMillis();
            while (this.zzew() && this.zzAS.getCurrentPosition() == n && (l = com.google.android.gms.ads.internal.zzp.zzbz().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzAS.pause();
            this.zzeB();
        }
    }

    private void zzeu() {
        AudioManager audioManager = this.zzeC();
        if (audioManager != null && !this.zzBb) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zzez();
            } else {
                zzb.zzaH("AdMediaPlayerView audio focus request failed");
            }
        }
    }

    private void zzev() {
        zzb.v("AdMediaPlayerView abandon audio focus");
        AudioManager audioManager = this.zzeC();
        if (audioManager != null && this.zzBb) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzBb = false;
            } else {
                zzb.zzaH("AdMediaPlayerView abandon audio focus failed");
            }
        }
    }

    private void zzt(boolean bl) {
        zzb.v("AdMediaPlayerView release");
        if (this.zzAS != null) {
            this.zzAS.reset();
            this.zzAS.release();
            this.zzAS = null;
            this.zzt(0);
            if (bl) {
                this.zzAR = 0;
                this.zzu(0);
            }
            this.zzev();
        }
    }

    @Override
    public void play() {
        zzb.v("AdMediaPlayerView play");
        if (this.zzew()) {
            this.zzAS.start();
            this.zzt(3);
            zzid.zzIE.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzBd != null) {
                        zzc.this.zzBd.zzeS();
                    }
                }
            });
        }
        this.zzu(3);
    }

    @Override
    public void pause() {
        zzb.v("AdMediaPlayerView pause");
        if (this.zzew() && this.zzAS.isPlaying()) {
            this.zzAS.pause();
            this.zzt(4);
            zzid.zzIE.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzBd != null) {
                        zzc.this.zzBd.onPaused();
                    }
                }
            });
        }
        this.zzu(4);
    }

    @Override
    public int getDuration() {
        if (this.zzew()) {
            return this.zzAS.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzew()) {
            return this.zzAS.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int millis) {
        zzb.v("AdMediaPlayerView seek " + millis);
        if (this.zzew()) {
            this.zzAS.seekTo(millis);
            this.zzBc = 0;
        } else {
            this.zzBc = millis;
        }
    }

    private boolean zzew() {
        return this.zzAS != null && this.zzAQ != -1 && this.zzAQ != 0 && this.zzAQ != 1;
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange > 0) {
            this.zzez();
        } else if (focusChange < 0) {
            this.zzeA();
        }
    }

    @Override
    public void zzex() {
        this.zzBa = true;
        this.zzeB();
    }

    @Override
    public void zzey() {
        this.zzBa = false;
        this.zzeB();
    }

    @Override
    public void zza(float f) {
        this.zzAZ = f;
        this.zzeB();
    }

    @Override
    public int getVideoWidth() {
        if (this.zzAS != null) {
            return this.zzAS.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzAS != null) {
            return this.zzAS.getVideoHeight();
        }
        return 0;
    }

    private void zzez() {
        zzb.v("AdMediaPlayerView audio focus gained");
        this.zzBb = true;
        this.zzeB();
    }

    private void zzeA() {
        zzb.v("AdMediaPlayerView audio focus lost");
        this.zzBb = false;
        this.zzeB();
    }

    private void zzeB() {
        if (!this.zzBa && this.zzBb) {
            this.zzb(this.zzAZ);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzAS != null) {
            try {
                this.zzAS.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzb.zzaH("AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zzeC() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzt(int n) {
        if (n == 3) {
            this.zzAP.zzfe();
        } else if (this.zzAQ == 3 && n != 3) {
            this.zzAP.zzff();
        }
        this.zzAQ = n;
    }

    private void zzu(int n) {
        this.zzAR = n;
    }

    static {
        zzAO.put(-1004, "MEDIA_ERROR_IO");
        zzAO.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzAO.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzAO.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzAO.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzAO.put(1, "MEDIA_ERROR_UNKNOWN");
        zzAO.put(1, "MEDIA_INFO_UNKNOWN");
        zzAO.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzAO.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzAO.put(701, "MEDIA_INFO_BUFFERING_START");
        zzAO.put(702, "MEDIA_INFO_BUFFERING_END");
        zzAO.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzAO.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzAO.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzAO.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzAO.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

