/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zziz;
import java.util.HashMap;

@zzgr
public class zzk
extends FrameLayout
implements zzh {
    private final zziz zzoM;
    private final FrameLayout zzBN;
    private final zzq zzBO;
    private zzi zzBP;
    private boolean zzBQ;
    private boolean zzBR;
    private TextView zzBS;
    private long zzBT;
    private long zzBU;
    private String zzBV;
    private String zzxZ;

    public static void zzd(zziz zziz2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zziz2.zzb("onVideoEvent", hashMap);
    }

    public zzk(Context context, zziz zziz2, int n, zzcg zzcg2, zzce zzce2) {
        super(context);
        this.zzoM = zziz2;
        this.zzBN = new FrameLayout(context);
        this.addView((View)this.zzBN, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb.zzs((Object)zziz2.zzhb());
        this.zzBP = zziz2.zzhb().zzoH.zza(context, zziz2, n, zzcg2, zzce2);
        if (this.zzBP != null) {
            this.zzBN.addView((View)this.zzBP, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.zzBS = new TextView(context);
        this.zzBS.setBackgroundColor(-16777216);
        this.zzeY();
        this.zzBO = new zzq(this);
        this.zzBO.zzfg();
        if (this.zzBP != null) {
            this.zzBP.zza(this);
        }
        if (this.zzBP == null) {
            this.zzh("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3 + 2, n4 + 2);
        layoutParams.setMargins(n - 1, n2 - 1, 0, 0);
        this.zzBN.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void setMimeType(String mimeType) {
        this.zzBV = mimeType;
    }

    public void zzan(String string) {
        this.zzxZ = string;
    }

    public void zzeV() {
        if (this.zzBP == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzxZ)) {
            this.zzBP.setMimeType(this.zzBV);
            this.zzBP.setVideoPath(this.zzxZ);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzBP == null) {
            return;
        }
        this.zzBP.pause();
    }

    public void play() {
        if (this.zzBP == null) {
            return;
        }
        this.zzBP.play();
    }

    public void seekTo(int millis) {
        if (this.zzBP == null) {
            return;
        }
        this.zzBP.seekTo(millis);
    }

    public void zzex() {
        if (this.zzBP == null) {
            return;
        }
        this.zzBP.zzex();
    }

    public void zzey() {
        if (this.zzBP == null) {
            return;
        }
        this.zzBP.zzey();
    }

    public void zza(float f) {
        if (this.zzBP == null) {
            return;
        }
        this.zzBP.zza(f);
    }

    public void zzd(MotionEvent motionEvent) {
        if (this.zzBP == null) {
            return;
        }
        this.zzBP.dispatchTouchEvent(motionEvent);
    }

    public void zzeW() {
        if (this.zzBP == null) {
            return;
        }
        Context context = this.zzBP.getContext();
        TextView textView = new TextView(context);
        textView.setText((CharSequence)("AdMob - " + this.zzBP.zzer()));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzBN.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzBN.bringChildToFront((View)textView);
    }

    @Override
    public void zzeQ() {
    }

    @Override
    public void zzeR() {
        if (this.zzBP == null) {
            return;
        }
        if (this.zzBU == 0L) {
            float f = (float)this.zzBP.getDuration() / 1000.0f;
            int n = this.zzBP.getVideoWidth();
            int n2 = this.zzBP.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzeS() {
        this.zzfb();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzfc();
    }

    @Override
    public void zzeT() {
        this.zza("ended", new String[0]);
        this.zzfc();
    }

    @Override
    public void zzh(String string, String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public void zzeU() {
        this.zzeY();
        this.zzBU = this.zzBT;
    }

    public void destroy() {
        this.zzBO.cancel();
        if (this.zzBP != null) {
            this.zzBP.stop();
        }
        this.zzfc();
    }

    void zzeX() {
        if (this.zzBP == null) {
            return;
        }
        long l = this.zzBP.getCurrentPosition();
        if (this.zzBT != l && l > 0L) {
            this.zzeZ();
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzBT = l;
        }
    }

    private void zzeY() {
        if (!this.zzfa()) {
            this.zzBN.addView((View)this.zzBS, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzBN.bringChildToFront((View)this.zzBS);
        }
    }

    private void zzeZ() {
        if (this.zzfa()) {
            this.zzBN.removeView((View)this.zzBS);
        }
    }

    private boolean zzfa() {
        return this.zzBS.getParent() != null;
    }

    private void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzoM.zzb("onVideoEvent", hashMap);
    }

    private void zzfb() {
        if (this.zzoM.zzgZ() == null) {
            return;
        }
        if (this.zzBQ) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzoM.zzgZ().getWindow().getAttributes();
        boolean bl = this.zzBR = (layoutParams.flags & 0x80) != 0;
        if (!this.zzBR) {
            this.zzoM.zzgZ().getWindow().addFlags(128);
            this.zzBQ = true;
        }
    }

    private void zzfc() {
        if (this.zzoM.zzgZ() == null) {
            return;
        }
        if (this.zzBQ && !this.zzBR) {
            this.zzoM.zzgZ().getWindow().clearFlags(128);
            this.zzBQ = false;
        }
    }
}

