/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.TextureView;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcc;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzig;
import java.util.concurrent.TimeUnit;

public class zzp {
    private final Context mContext;
    private final String zzBY;
    private final VersionInfoParcel zzBZ;
    private final zzce zzCa;
    private final zzcg zzCb;
    private final zzig zzCc = new zzig.zzb().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzgK();
    private final long[] zzCd;
    private final String[] zzCe;
    private zzce zzCf;
    private zzce zzCg;
    private zzce zzCh;
    private zzce zzCi;
    private boolean zzCj;
    private zzi zzCk;
    private boolean zzCl;
    private boolean zzCm;
    private long zzCn = -1L;

    public zzp(Context context, VersionInfoParcel versionInfoParcel, String string, zzcg zzcg2, zzce zzce2) {
        this.mContext = context;
        this.zzBZ = versionInfoParcel;
        this.zzBY = string;
        this.zzCb = zzcg2;
        this.zzCa = zzce2;
        String string2 = zzby.zzuF.get();
        if (string2 == null) {
            this.zzCe = new String[0];
            this.zzCd = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string2, (String)",");
        this.zzCe = new String[stringArray.length];
        this.zzCd = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzCd[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzd("Unable to parse frame hash target time number.", numberFormatException);
                this.zzCd[i] = -1L;
            }
        }
    }

    public void zza(zzi zzi2) {
        zzcc.zza(this.zzCb, this.zzCa, "vpc");
        this.zzCf = zzcc.zzb(this.zzCb);
        this.zzCk = zzi2;
    }

    public void zzeR() {
        if (this.zzCf == null || this.zzCg != null) {
            return;
        }
        zzcc.zza(this.zzCb, this.zzCf, "vfr");
        this.zzCg = zzcc.zzb(this.zzCb);
    }

    public void onStop() {
        if (zzby.zzuE.get().booleanValue() && !this.zzCl) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzBY);
            bundle.putString("player", this.zzCk.zzer());
            for (zzig.zza object : this.zzCc.getBuckets()) {
                bundle.putString("fps_c_" + object.name, Integer.toString(object.count));
                bundle.putString("fps_p_" + object.name, Double.toString(object.zzIV));
            }
            for (int i = 0; i < this.zzCd.length; ++i) {
                String string = this.zzCe[i];
                if (string == null) continue;
                bundle.putString("fh_" + Long.valueOf(this.zzCd[i]), string);
            }
            com.google.android.gms.ads.internal.zzp.zzbv().zza(this.mContext, this.zzBZ.zzJu, "gmob-apps", bundle, true);
            this.zzCl = true;
        }
    }

    public void zzb(zzi zzi2) {
        this.zzfd();
        this.zzc(zzi2);
    }

    private void zzfd() {
        if (this.zzCh != null && this.zzCi == null) {
            zzcc.zza(this.zzCb, this.zzCh, "vff");
            zzcc.zza(this.zzCb, this.zzCa, "vtt");
            this.zzCi = zzcc.zzb(this.zzCb);
        }
        long l = com.google.android.gms.ads.internal.zzp.zzbz().nanoTime();
        if (this.zzCj && this.zzCm && this.zzCn != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - this.zzCn);
            this.zzCc.zza(d);
        }
        this.zzCm = this.zzCj;
        this.zzCn = l;
    }

    private void zzc(zzi zzi2) {
        long l = zzby.zzuG.get();
        long l2 = zzi2.getCurrentPosition();
        for (int i = 0; i < this.zzCe.length; ++i) {
            long l3;
            if (this.zzCe[i] != null || l <= Math.abs(l2 - (l3 = this.zzCd[i]))) continue;
            this.zzCe[i] = this.zza((TextureView)zzi2);
            break;
        }
    }

    String zza(TextureView textureView) {
        Bitmap bitmap = textureView.getBitmap(8, 8);
        long l = 0L;
        long l2 = 63L;
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                int n2 = bitmap.getPixel(n, i);
                int n3 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2);
                long l3 = n3 > 128 ? 1L : 0L;
                l |= l3 << (int)l2;
                ++n;
                --l2;
            }
        }
        return String.format("%016X", l);
    }

    public void zzfe() {
        this.zzCj = true;
        if (this.zzCg != null && this.zzCh == null) {
            zzcc.zza(this.zzCb, this.zzCg, "vfp");
            this.zzCh = zzcc.zzb(this.zzCb);
        }
    }

    public void zzff() {
        this.zzCj = false;
    }
}

