/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzgr;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public class zzi {
    public int zzd(Intent intent) {
        if (intent == null) {
            return 5;
        }
        Object object = intent.getExtras().get("RESPONSE_CODE");
        if (object == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Intent with no response code, assuming OK (known issue)");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaH("Unexpected type for intent response code. " + object.getClass().getName());
        return 5;
    }

    public int zzc(Bundle bundle) {
        Object object = bundle.get("RESPONSE_CODE");
        if (object == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Bundle with null response code, assuming OK (known issue)");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaH("Unexpected type for intent response code. " + object.getClass().getName());
        return 5;
    }

    public String zze(Intent intent) {
        if (intent == null) {
            return null;
        }
        return intent.getStringExtra("INAPP_PURCHASE_DATA");
    }

    public String zzf(Intent intent) {
        if (intent == null) {
            return null;
        }
        return intent.getStringExtra("INAPP_DATA_SIGNATURE");
    }

    public String zzao(String string) {
        if (string == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            return jSONObject.getString("developerPayload");
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Fail to parse purchase data");
            return null;
        }
    }

    public String zzap(String string) {
        if (string == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            return jSONObject.getString("purchaseToken");
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Fail to parse purchase data");
            return null;
        }
    }

    public void zza(Context context, boolean bl, GInAppPurchaseManagerInfoParcel gInAppPurchaseManagerInfoParcel) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.purchase.InAppPurchaseActivity");
        intent.putExtra("com.google.android.gms.ads.internal.purchase.useClientJar", bl);
        GInAppPurchaseManagerInfoParcel.zza(intent, gInAppPurchaseManagerInfoParcel);
        zzp.zzbv().zzb(context, intent);
    }

    public void zzx(final Context context) {
        ServiceConnection serviceConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                zzb zzb2 = new zzb(context.getApplicationContext(), false);
                zzb2.zzN(service);
                int n = zzb2.zza(3, context.getPackageName(), "inapp");
                zzp.zzby().zzB(n == 0);
                context.unbindService((ServiceConnection)this);
                zzb2.destroy();
            }
        };
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        intent.setPackage("com.android.vending");
        context.bindService(intent, serviceConnection, 1);
    }
}

