/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.request.zzl;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzmt;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class LargeParcelTeleporter
implements SafeParcelable {
    public static final Parcelable.Creator<LargeParcelTeleporter> CREATOR = new zzl();
    final int mVersionCode;
    ParcelFileDescriptor zzFc;
    private Parcelable zzFd;
    private boolean zzFe;

    LargeParcelTeleporter(int versionCode, ParcelFileDescriptor parcelFileDescriptor) {
        this.mVersionCode = versionCode;
        this.zzFc = parcelFileDescriptor;
        this.zzFd = null;
        this.zzFe = true;
    }

    public LargeParcelTeleporter(SafeParcelable teleportee) {
        this.mVersionCode = 1;
        this.zzFc = null;
        this.zzFd = teleportee;
        this.zzFe = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzFe) {
            byte[] byArray;
            if (this.zzFc == null) {
                zzb.e("File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzFc));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzmt.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzFd = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzFe = false;
        }
        return (T)((SafeParcelable)this.zzFd);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel dest, int flags) {
        if (this.zzFc == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzFd.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzFc = this.zzf(byArray);
        }
        zzl.zza(this, dest, flags);
    }

    protected <T> ParcelFileDescriptor zzf(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable((OutputStream)autoCloseOutputStream2, byArray){
                final /* synthetic */ OutputStream zzFf;
                final /* synthetic */ byte[] zzFg;
                {
                    this.zzFf = outputStream;
                    this.zzFg = byArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataOutputStream dataOutputStream = null;
                    try {
                        dataOutputStream = new DataOutputStream(this.zzFf);
                        dataOutputStream.writeInt(this.zzFg.length);
                        dataOutputStream.write(this.zzFg);
                    }
                    catch (IOException iOException) {
                        zzb.zzb("Error transporting the ad response", iOException);
                        zzp.zzby().zzc(iOException, true);
                    }
                    finally {
                        if (dataOutputStream == null) {
                            zzmt.zzb((Closeable)this.zzFf);
                        } else {
                            zzmt.zzb((Closeable)dataOutputStream);
                        }
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzb.zzb("Error transporting the ad response", iOException);
            zzp.zzby().zzc(iOException, true);
            zzmt.zzb(autoCloseOutputStream);
            return null;
        }
    }
}

