/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzj;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzhz;

@zzgr
public abstract class zzd
extends zzhz
implements zzc.zza {
    private final AdRequestInfoParcel zzzz;
    private final zzc.zza zzEi;
    private final Object zzpd = new Object();
    private AdResponseParcel zzDf;

    public zzd(AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
        this.zzzz = adRequestInfoParcel;
        this.zzEi = zza2;
    }

    public abstract void zzfH();

    public abstract zzj zzfI();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzDf = adResponseParcel;
            this.zzpd.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbn() {
        try {
            zzj zzj2 = this.zzfI();
            if (zzj2 == null) {
                AdResponseParcel adResponseParcel = new AdResponseParcel(0);
                this.zzEi.zzb(adResponseParcel);
            } else if (this.zza(zzj2, this.zzzz)) {
                this.zzi(zzp.zzbz().elapsedRealtime());
            }
        }
        finally {
            this.zzfH();
        }
    }

    @Override
    public final void onStop() {
        this.zzfH();
    }

    boolean zza(zzj zzj2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzj2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service.", remoteException);
            zzp.zzby().zzc(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", nullPointerException);
            zzp.zzby().zzc(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", securityException);
            zzp.zzby().zzc(securityException, true);
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", throwable);
            zzp.zzby().zzc(throwable, true);
        }
        this.zzEi.zzb(new AdResponseParcel(0));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzi(long l) {
        Object object = this.zzpd;
        synchronized (object) {
            do {
                if (this.zzDf == null) continue;
                this.zzEi.zzb(this.zzDf);
                return;
            } while (this.zzf(l));
            if (this.zzDf != null) {
                this.zzEi.zzb(this.zzDf);
            } else {
                this.zzEi.zzb(new AdResponseParcel(0));
            }
            return;
        }
    }

    protected boolean zzf(long l) {
        long l2 = 60000L - (zzp.zzbz().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzpd.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    @zzgr
    public static class zzb
    extends zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private Context mContext;
        private AdRequestInfoParcel zzzz;
        private final zzc.zza zzEi;
        private final Object zzpd = new Object();
        protected zze zzEj;
        private boolean zzEk;

        public zzb(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            Looper looper;
            this.mContext = context;
            this.zzzz = adRequestInfoParcel;
            this.zzEi = zza2;
            if (zzby.zzuK.get().booleanValue()) {
                this.zzEk = true;
                looper = zzp.zzbG().zzgM();
            } else {
                looper = context.getMainLooper();
            }
            this.zzEj = new zze(context, looper, this, this, adRequestInfoParcel.zzqj.zzJw);
            this.connect();
        }

        protected void connect() {
            this.zzEj.zzoZ();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzj zzfI() {
            Object object = this.zzpd;
            synchronized (object) {
                try {
                    return this.zzEj.zzfM();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzfH() {
            Object object = this.zzpd;
            synchronized (object) {
                if (this.zzEj.isConnected() || this.zzEj.isConnecting()) {
                    this.zzEj.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzEk) {
                    zzp.zzbG().zzgN();
                    this.zzEk = false;
                }
            }
        }

        zzhz zzfJ() {
            return new zza(this.mContext, this.zzzz, this.zzEi);
        }

        public void onConnectionFailed(ConnectionResult result) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Cannot connect to remote service, fallback to local instance.");
            zzhz zzhz2 = this.zzfJ();
            zzhz2.zzgz();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzp.zzbv().zzb(this.mContext, this.zzzz.zzqj.zzJu, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle connectionHint) {
            this.zzgz();
        }

        public void onConnectionSuspended(int cause) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Disconnected from remote ad request service.");
        }
    }

    @zzgr
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            this.mContext = context;
        }

        @Override
        public zzj zzfI() {
            zzbr zzbr2 = new zzbr(zzby.zzul.get());
            return zzgt.zza(this.mContext, zzbr2, zzgs.zzfQ());
        }

        @Override
        public void zzfH() {
        }
    }
}

