/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzv;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzck;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzht;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzhx;
import java.util.HashSet;

@zzgr
public abstract class zza
extends zzs.zza
implements com.google.android.gms.ads.internal.client.zza,
zzn,
zza.zza,
zzdg,
zzgg.zza,
zzhw {
    protected zzcg zzoo;
    protected zzce zzop;
    protected zzce zzoq;
    boolean zzor = false;
    protected final zzo zzos;
    protected final zzq zzot;
    protected transient AdRequestParcel zzou;
    protected final zzay zzov;
    protected final zzd zzow;

    zza(zzq zzq2, zzo zzo2, zzd zzd2) {
        this.zzot = zzq2;
        this.zzos = zzo2 != null ? zzo2 : new zzo(this);
        this.zzow = zzd2;
        zzp.zzbv().zzI(this.zzot.context);
        zzp.zzby().zzb(this.zzot.context, this.zzot.zzqj);
        this.zzov = zzp.zzby().zzgt();
    }

    void zzaL() {
        this.zzoo = new zzcg(zzby.zzuQ.get(), "load_ad", this.zzot.zzqn.zzte);
        this.zzop = new zzce(-1L, null, null);
        this.zzoq = new zzce(-1L, null, null);
    }

    @Override
    public void destroy() {
        zzx.zzci((String)"destroy must be called on the main UI thread.");
        this.zzos.cancel();
        this.zzov.zzf(this.zzot.zzqo);
        this.zzot.destroy();
    }

    @Override
    public com.google.android.gms.dynamic.zzd zzaM() {
        zzx.zzci((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzy((Object)((Object)this.zzot.zzqk));
    }

    @Override
    public AdSizeParcel zzaN() {
        zzx.zzci((String)"getAdSize must be called on the main UI thread.");
        return this.zzot.zzqn == null ? null : new ThinAdSizeParcel(this.zzot.zzqn);
    }

    @Override
    public boolean isReady() {
        zzx.zzci((String)"isLoaded must be called on the main UI thread.");
        return this.zzot.zzql == null && this.zzot.zzqm == null && this.zzot.zzqo != null;
    }

    @Override
    public void setManualImpressionsEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (GooglePlayServicesUtil.zzag((Context)this.zzot.context) && adRequestParcel.zzsJ != null) {
            return new zzf(adRequestParcel).zza(null).zzcA();
        }
        return adRequestParcel;
    }

    @Override
    public boolean zzb(AdRequestParcel adRequestParcel) {
        zzx.zzci((String)"loadAd must be called on the main UI thread.");
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzor) {
            if (this.zzou != null) {
                zzb.zzaH("Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            }
            this.zzou = adRequestParcel;
            return false;
        }
        zzb.zzaG("Starting ad request.");
        this.zzor = true;
        this.zzaL();
        this.zzop = this.zzoo.zzdn();
        if (!adRequestParcel.zzsE) {
            zzb.zzaG("Use AdRequest.Builder.addTestDevice(\"" + zzl.zzcF().zzQ(this.zzot.context) + "\") to get test ads on this device.");
        }
        return this.zza(adRequestParcel, this.zzoo);
    }

    protected abstract boolean zza(AdRequestParcel var1, zzcg var2);

    @Override
    public void zza(zzhs.zza zza2) {
        long l;
        if (zza2.zzHD.zzEO != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzHD.zzEY) && (l = this.zzo(zza2.zzHD.zzEY)) != -1L) {
            zzce zzce2 = this.zzoo.zzb(zza2.zzHD.zzEO + l);
            this.zzoo.zza(zzce2, "stc");
        }
        this.zzoo.zzT(zza2.zzHD.zzEY);
        this.zzoo.zza(this.zzop, "arf");
        this.zzoq = this.zzoo.zzdn();
        this.zzoo.zze("gqi", zza2.zzHD.zzEZ);
        this.zzot.zzql = null;
        this.zzot.zzqp = zza2;
        this.zza(zza2, this.zzoo);
    }

    protected abstract void zza(zzhs.zza var1, zzcg var2);

    boolean zza(zzhs zzhs2) {
        return false;
    }

    @Override
    public void zzb(zzhs zzhs2) {
        this.zzoo.zza(this.zzoq, "awr");
        this.zzot.zzqm = null;
        if (zzhs2.errorCode != -2 && zzhs2.errorCode != 3) {
            zzp.zzby().zzb(this.zzot.zzbJ());
        }
        if (zzhs2.errorCode == -1) {
            this.zzor = false;
            return;
        }
        if (this.zza(zzhs2)) {
            zzb.zzaF("Ad refresh scheduled.");
        }
        if (zzhs2.errorCode != -2) {
            this.zze(zzhs2.errorCode);
            return;
        }
        if (this.zzot.zzqF == null) {
            this.zzot.zzqF = new zzhx(this.zzot.zzqh);
        }
        this.zzov.zze(this.zzot.zzqo);
        if (this.zza(this.zzot.zzqo, zzhs2)) {
            this.zzot.zzqo = zzhs2;
            this.zzot.zzbS();
            this.zzoo.zze("is_mraid", this.zzot.zzqo.zzbY() ? "1" : "0");
            this.zzoo.zze("is_mediation", this.zzot.zzqo.zzEK ? "1" : "0");
            if (this.zzot.zzqo.zzBD != null && this.zzot.zzqo.zzBD.zzhe() != null) {
                this.zzoo.zze("is_video", this.zzot.zzqo.zzBD.zzhe().zzhr() ? "1" : "0");
            }
            this.zzoo.zza(this.zzop, "ttc");
            if (zzp.zzby().zzgo() != null) {
                zzp.zzby().zzgo().zza(this.zzoo);
            }
            if (this.zzot.zzbN()) {
                this.zzaT();
            }
        }
    }

    protected abstract boolean zza(zzhs var1, zzhs var2);

    @Override
    public void onAdClicked() {
        if (this.zzot.zzqo == null) {
            zzb.zzaH("Ad state was null when trying to ping click URLs.");
            return;
        }
        zzb.zzaF("Pinging click URLs.");
        this.zzot.zzqq.zzgg();
        if (this.zzot.zzqo.zzyY != null) {
            zzp.zzbv().zza(this.zzot.context, this.zzot.zzqj.zzJu, this.zzot.zzqo.zzyY);
        }
        if (this.zzot.zzqr != null) {
            try {
                this.zzot.zzqr.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not notify onAdClicked event.", remoteException);
            }
        }
    }

    @Override
    public void zzaO() {
        this.zzaR();
    }

    @Override
    public void onAppEvent(String name, String info) {
        if (this.zzot.zzqt != null) {
            try {
                this.zzot.zzqt.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    @Override
    public void zzaP() {
        zzx.zzci((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzot.zzqo == null) {
            zzb.zzaH("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzb.zzaF("Pinging manual tracking URLs.");
        if (this.zzot.zzqo.zzEM != null) {
            zzp.zzbv().zza(this.zzot.context, this.zzot.zzqj.zzJu, this.zzot.zzqo.zzEM);
        }
    }

    @Override
    public void pause() {
        zzx.zzci((String)"pause must be called on the main UI thread.");
    }

    @Override
    public void resume() {
        zzx.zzci((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        ViewParent viewParent = this.zzot.zzqk.getParent();
        return viewParent instanceof View && ((View)viewParent).isShown() && zzp.zzbv().zzgB();
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzb.zzaG("Ad is not visible. Not refreshing ad.");
            this.zzos.zzg(adRequestParcel);
        }
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzo zzo2) {
        zzx.zzci((String)"setAdListener must be called on the main UI thread.");
        this.zzot.zzqs = zzo2;
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzn zzn2) {
        zzx.zzci((String)"setAdListener must be called on the main UI thread.");
        this.zzot.zzqr = zzn2;
    }

    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        zzx.zzci((String)"setAdSize must be called on the main UI thread.");
        this.zzot.zzqn = adSizeParcel;
        if (this.zzot.zzqo != null && this.zzot.zzqo.zzBD != null && this.zzot.zzqH == 0) {
            this.zzot.zzqo.zzBD.zza(adSizeParcel);
        }
        if (this.zzot.zzqk == null) {
            return;
        }
        if (this.zzot.zzqk.getChildCount() > 1) {
            this.zzot.zzqk.removeView(this.zzot.zzqk.getNextView());
        }
        this.zzot.zzqk.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzot.zzqk.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzot.zzqk.requestLayout();
    }

    @Override
    public void zza(zzu zzu2) {
        zzx.zzci((String)"setAppEventListener must be called on the main UI thread.");
        this.zzot.zzqt = zzu2;
    }

    @Override
    public void zza(zzfs zzfs2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    @Override
    public void zza(zzck zzck2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    @Override
    public void zza(zzfw zzfw2, String string) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    @Override
    public void zza(zzv zzv2) {
        zzx.zzci((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzot.zzqu = zzv2;
    }

    @Override
    public void stopLoading() {
        zzx.zzci((String)"stopLoading must be called on the main UI thread.");
        this.zzor = false;
        this.zzot.zzf(true);
    }

    @Override
    public boolean isLoading() {
        return this.zzor;
    }

    Bundle zza(zzbk zzbk2) {
        if (zzbk2 == null) {
            return null;
        }
        if (zzbk2.zzcx()) {
            zzbk2.wakeup();
        }
        zzbh zzbh2 = zzbk2.zzcv();
        String string = null;
        if (zzbh2 != null) {
            string = zzbh2.zzcm();
            zzb.zzaF("In AdManger: loadAd, " + zzbh2.toString());
        }
        if (string != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string);
            bundle.putInt("v", 1);
            return bundle;
        }
        return null;
    }

    long zzo(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzb.zzaH("Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzb.zzaH("Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        this.zzot.zzqk.addView(view, zzp.zzbx().zzgJ());
    }

    protected boolean zzaQ() {
        zzb.v("Ad closing.");
        if (this.zzot.zzqs == null) {
            return false;
        }
        try {
            this.zzot.zzqs.onAdClosed();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdClosed().", remoteException);
            return false;
        }
    }

    private boolean zzaR() {
        zzb.zzaG("Ad leaving application.");
        if (this.zzot.zzqs == null) {
            return false;
        }
        try {
            this.zzot.zzqs.onAdLeftApplication();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLeftApplication().", remoteException);
            return false;
        }
    }

    protected boolean zzaS() {
        zzb.zzaG("Ad opening.");
        if (this.zzot.zzqs == null) {
            return false;
        }
        try {
            this.zzot.zzqs.onAdOpened();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdOpened().", remoteException);
            return false;
        }
    }

    protected boolean zzaT() {
        zzb.zzaG("Ad finished loading.");
        this.zzor = false;
        if (this.zzot.zzqs == null) {
            return false;
        }
        try {
            this.zzot.zzqs.onAdLoaded();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLoaded().", remoteException);
            return false;
        }
    }

    protected boolean zze(int n) {
        zzb.zzaH("Failed to load ad: " + n);
        this.zzor = false;
        if (this.zzot.zzqs == null) {
            return false;
        }
        try {
            this.zzot.zzqs.onAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    protected void recordImpression() {
        this.zzc(this.zzot.zzqo);
    }

    protected void zzc(zzhs zzhs2) {
        if (zzhs2 == null) {
            zzb.zzaH("Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzb.zzaF("Pinging Impression URLs.");
        this.zzot.zzqq.zzgf();
        if (zzhs2.zzyZ != null) {
            zzp.zzbv().zza(this.zzot.context, this.zzot.zzqj.zzJu, zzhs2.zzyZ);
        }
    }

    @Override
    public void zza(HashSet<zzht> hashSet) {
        this.zzot.zza(hashSet);
    }
}

