/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzdm;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzht;
import com.google.android.gms.internal.zzid;
import java.util.ArrayList;
import java.util.UUID;

@zzgr
public abstract class zzb
extends zza
implements zzg,
zzj,
zzdm,
zzef {
    protected final zzem zzox;
    private final Messenger mMessenger;
    protected transient boolean zzoy;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string, zzem zzem2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzq(context, adSizeParcel, string, versionInfoParcel), zzem2, null, zzd2);
    }

    zzb(zzq zzq2, zzem zzem2, zzo zzo2, zzd zzd2) {
        super(zzq2, zzo2, zzd2);
        this.zzox = zzem2;
        this.mMessenger = new Messenger((Handler)new zzfp(this.zzot.context));
        this.zzoy = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzcg zzcg2) {
        if (!this.zzaU()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzp.zzby().zzE(this.zzot.context));
        this.zzos.cancel();
        this.zzot.zzqH = 0;
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle);
        zzcg2.zze("seq_num", zza2.zzEq);
        zzcg2.zze("request_id", zza2.zzEC);
        zzcg2.zze("session_id", zza2.zzEr);
        if (zza2.zzEo != null) {
            zzcg2.zze("app_version", String.valueOf(zza2.zzEo.versionCode));
        }
        this.zzot.zzql = zzp.zzbr().zza(this.zzot.context, zza2, this.zzot.zzqi, this);
        return true;
    }

    @Override
    public void zzb(zzhs zzhs2) {
        super.zzb(zzhs2);
        if (zzhs2.errorCode == 3 && zzhs2.zzHx != null && zzhs2.zzHx.zzza != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Pinging no fill URLs.");
            zzp.zzbH().zza(this.zzot.context, this.zzot.zzqj.zzJu, zzhs2, this.zzot.zzqh, false, zzhs2.zzHx.zzza);
        }
    }

    @Override
    protected boolean zza(zzhs zzhs2, zzhs zzhs3) {
        if (zzhs2 != null && zzhs2.zzzx != null) {
            zzhs2.zzzx.zza((zzef)null);
        }
        if (zzhs3.zzzx != null) {
            zzhs3.zzzx.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzhs3.zzHx != null) {
            n = zzhs3.zzHx.zzzf;
            n2 = zzhs3.zzHx.zzzg;
        }
        this.zzot.zzqF.zzf(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzot.zzqo == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzot.zzqo.zzHx != null && this.zzot.zzqo.zzHx.zzyY != null) {
            zzp.zzbH().zza(this.zzot.context, this.zzot.zzqj.zzJu, this.zzot.zzqo, this.zzot.zzqh, false, this.zzot.zzqo.zzHx.zzyY);
        }
        if (this.zzot.zzqo.zzzu != null && this.zzot.zzqo.zzzu.zzyR != null) {
            zzp.zzbH().zza(this.zzot.context, this.zzot.zzqj.zzJu, this.zzot.zzqo, this.zzot.zzqh, false, this.zzot.zzqo.zzzu.zzyR);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzhs zzhs2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzou != null) {
            adRequestParcel = this.zzou;
            this.zzou = null;
        } else {
            adRequestParcel = zzhs2.zzEn;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzhs2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzhs zzhs2, boolean bl) {
        if (!bl && this.zzot.zzbN()) {
            if (zzhs2.zzzc > 0L) {
                this.zzos.zza(adRequestParcel, zzhs2.zzzc);
            } else if (zzhs2.zzHx != null && zzhs2.zzHx.zzzc > 0L) {
                this.zzos.zza(adRequestParcel, zzhs2.zzHx.zzzc);
            } else if (!zzhs2.zzEK && zzhs2.errorCode == 2) {
                this.zzos.zzg(adRequestParcel);
            }
        }
        return this.zzos.zzbp();
    }

    @Override
    public void pause() {
        zzx.zzci((String)"pause must be called on the main UI thread.");
        if (this.zzot.zzqo != null && this.zzot.zzqo.zzBD != null && this.zzot.zzbN()) {
            zzp.zzbx().zza(this.zzot.zzqo.zzBD.getWebView());
        }
        if (this.zzot.zzqo != null && this.zzot.zzqo.zzzv != null) {
            try {
                this.zzot.zzqo.zzzv.pause();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not pause mediation adapter.");
            }
        }
        this.zzov.zzg(this.zzot.zzqo);
        this.zzos.pause();
    }

    @Override
    public void resume() {
        zzx.zzci((String)"resume must be called on the main UI thread.");
        if (this.zzot.zzqo != null && this.zzot.zzqo.zzBD != null && this.zzot.zzbN()) {
            zzp.zzbx().zzb(this.zzot.zzqo.zzBD.getWebView());
        }
        if (this.zzot.zzqo != null && this.zzot.zzqo.zzzv != null) {
            try {
                this.zzot.zzqo.zzzv.resume();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not resume mediation adapter.");
            }
        }
        this.zzos.resume();
        this.zzov.zzh(this.zzot.zzqo);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzoy;
    }

    protected boolean zzaU() {
        boolean bl = true;
        if (!zzp.zzbv().zza(this.zzot.context.getPackageManager(), this.zzot.context.getPackageName(), "android.permission.INTERNET") || !zzp.zzbv().zzH(this.zzot.context)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzaV() {
        this.zzov.zze(this.zzot.zzqo);
        this.zzoy = false;
        this.zzaQ();
        this.zzot.zzqq.zzgh();
    }

    @Override
    public void zzaW() {
        this.zzoy = true;
        this.zzaS();
    }

    @Override
    public void zzaX() {
        this.onAdClicked();
    }

    @Override
    public void zzaY() {
        this.zzaV();
    }

    @Override
    public void zzaZ() {
        this.zzaO();
    }

    @Override
    public void zzba() {
        this.zzaW();
    }

    @Override
    public void zzbb() {
        if (this.zzot.zzqo != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Mediation adapter " + this.zzot.zzqo.zzzw + " refreshed, but mediation adapters should never refresh.");
        }
        this.zza(this.zzot.zzqo, true);
        this.zzaT();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle) {
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzot.context.getApplicationInfo();
        try {
            packageManager = this.zzot.context.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzot.context.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzot.zzqk != null && this.zzot.zzqk.getParent() != null) {
            object = new int[2];
            this.zzot.zzqk.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzot.zzqk.getWidth();
            int n3 = this.zzot.zzqk.getHeight();
            int n4 = 0;
            if (this.zzot.zzqk.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzp.zzby().zzgm();
        this.zzot.zzqq = new zzht((String)object, this.zzot.zzqh);
        this.zzot.zzqq.zzi(adRequestParcel);
        String string = zzp.zzbv().zza(this.zzot.context, (View)this.zzot.zzqk, this.zzot.zzqn);
        long l = 0L;
        if (this.zzot.zzqu != null) {
            try {
                l = this.zzot.zzqu.getValue();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Cannot get correlation id, default to 0.");
            }
        }
        String string2 = UUID.randomUUID().toString();
        Bundle bundle3 = zzp.zzby().zza(this.zzot.context, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzot.zzqA.size(); n += 1) {
            arrayList.add((String)this.zzot.zzqA.keyAt(n));
        }
        n = this.zzot.zzqv != null ? 1 : 0;
        boolean bl = this.zzot.zzqw != null && zzp.zzby().zzgv();
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzot.zzqn, this.zzot.zzqh, applicationInfo, packageInfo, (String)object, zzp.zzby().getSessionId(), this.zzot.zzqj, bundle3, this.zzot.zzqD, arrayList, bundle, zzp.zzby().zzgq(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string, l, string2, zzby.zzdf(), this.zzot.zzqg, this.zzot.zzqB, new CapabilityParcel(n != 0, bl), this.zzot.zzbR());
    }

    @Override
    public void zza(zzfs zzfs2) {
        zzx.zzci((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzot.zzqv = zzfs2;
    }

    @Override
    public void zza(zzfw zzfw2, String string) {
        zzx.zzci((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzot.zzqE = new zzk(string);
        this.zzot.zzqw = zzfw2;
        if (!zzp.zzby().zzgp() && zzfw2 != null) {
            new zzc(this.zzot.context, this.zzot.zzqw, this.zzot.zzqE).zzgz();
        }
    }

    @Override
    public void zza(String string, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string, arrayList, this.zzot.context, this.zzot.zzqj.zzJu);
        if (this.zzot.zzqv == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzl.zzcF().zzR(this.zzot.context)) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzot.zzqw == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzot.zzqE == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzot.zzqI) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzot.zzqI = true;
            try {
                if (!this.zzot.zzqw.isValidPurchase(string)) {
                    this.zzot.zzqI = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not start In-App purchase.");
                this.zzot.zzqI = false;
                return;
            }
            zzp.zzbF().zza(this.zzot.context, this.zzot.zzqj.zzJx, new GInAppPurchaseManagerInfoParcel(this.zzot.context, this.zzot.zzqE, zzd2, this));
        } else {
            try {
                this.zzot.zzqv.zza(zzd2);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzot.zzqw != null) {
                this.zzot.zzqw.zza(new com.google.android.gms.ads.internal.purchase.zzg(this.zzot.context, string, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Fail to invoke PlayStorePurchaseListener.");
        }
        zzid.zzIE.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzp.zzbF().zzd(intent);
                zzp.zzbF();
                if (n == 0 && zzb.this.zzot.zzqo != null && zzb.this.zzot.zzqo.zzBD != null && zzb.this.zzot.zzqo.zzBD.zzhc() != null) {
                    zzb.this.zzot.zzqo.zzBD.zzhc().close();
                }
                zzb.this.zzot.zzqI = false;
            }
        }, 500L);
    }

    protected void zza(zzhs zzhs2, boolean bl) {
        if (zzhs2 == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzhs2);
        if (zzhs2.zzHx != null && zzhs2.zzHx.zzyZ != null) {
            zzp.zzbH().zza(this.zzot.context, this.zzot.zzqj.zzJu, zzhs2, this.zzot.zzqh, bl, zzhs2.zzHx.zzyZ);
        }
        if (zzhs2.zzzu != null && zzhs2.zzzu.zzyS != null) {
            zzp.zzbH().zza(this.zzot.context, this.zzot.zzqj.zzJu, zzhs2, this.zzot.zzqh, bl, zzhs2.zzzu.zzyS);
        }
    }

    @Override
    public String getMediationAdapterClassName() {
        if (this.zzot.zzqo == null) {
            return null;
        }
        return this.zzot.zzqo.zzzw;
    }

    @Override
    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }
}

