/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zziz;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public class zzaz
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzpd = new Object();
    private final WeakReference<zzhs> zzrb;
    private WeakReference<ViewTreeObserver> zzrc;
    private final WeakReference<View> zzrd;
    private final zzax zzre;
    private final Context zzqZ;
    private final zzdz zzrf;
    private final zzdz.zzd zzrg;
    private boolean zzrh;
    private final WindowManager zzri;
    private final PowerManager zzrj;
    private final KeyguardManager zzrk;
    private zzba zzrl;
    private boolean zzrm;
    private boolean zzpJ = false;
    private boolean zzrn = false;
    private boolean zzro;
    private boolean zzrp;
    private BroadcastReceiver zzrq;
    private final HashSet<zzaw> zzrr = new HashSet();
    private zzik zzqM;
    private final zzdk zzrs = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            zzaz.this.zza(zziz2.getView(), map);
        }
    };
    private final zzdk zzrt = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            zzb.zzaF("Received request to untrack: " + zzaz.this.zzre.zzbX());
            zzaz.this.destroy();
        }
    };
    private final zzdk zzru = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzaz.this.zzg(bl);
        }
    };

    public zzaz(AdSizeParcel adSizeParcel, zzhs zzhs2, VersionInfoParcel versionInfoParcel, View view, zzdz zzdz2) {
        this.zzrf = zzdz2;
        this.zzrb = new WeakReference<zzhs>(zzhs2);
        this.zzrd = new WeakReference<View>(view);
        this.zzrc = new WeakReference<Object>(null);
        this.zzro = true;
        this.zzqM = new zzik(200L);
        this.zzre = new zzax(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzte, zzhs2.zzHw, zzhs2.zzbY());
        this.zzrg = this.zzrf.zzdO();
        this.zzri = (WindowManager)view.getContext().getSystemService("window");
        this.zzrj = (PowerManager)view.getContext().getApplicationContext().getSystemService("power");
        this.zzrk = (KeyguardManager)view.getContext().getSystemService("keyguard");
        this.zzqZ = view.getContext().getApplicationContext();
        try {
            final JSONObject jSONObject = this.zzd(view);
            this.zzrg.zza(new zzis.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzaz.this.zza(jSONObject);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzis.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (JSONException jSONException) {
        }
        catch (RuntimeException runtimeException) {
            zzb.zzb("Failure while processing active view data.", runtimeException);
        }
        this.zzrg.zza(new zzis.zzc<zzbe>(){

            public void zzb(zzbe zzbe2) {
                zzaz.this.zzrh = true;
                zzaz.this.zza(zzbe2);
                zzaz.this.zzbZ();
                zzaz.this.zzh(false);
            }

            @Override
            public /* synthetic */ void zzc(Object object) {
                this.zzb((zzbe)object);
            }
        }, new zzis.zza(){

            @Override
            public void run() {
                zzaz.this.destroy();
            }
        });
        zzb.zzaF("Tracking ad unit: " + this.zzre.zzbX());
    }

    public void zza(zzaw zzaw2) {
        this.zzrr.add(zzaw2);
    }

    protected void zzg(boolean bl) {
        for (zzaw zzaw2 : this.zzrr) {
            zzaw2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbZ() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzrq != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzrq = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzaz.this.zzh(false);
                }
            };
            this.zzqZ.registerReceiver(this.zzrq, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzca() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzrq != null) {
                this.zzqZ.unregisterReceiver(this.zzrq);
                this.zzrq = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzcf();
            this.zzca();
            this.zzro = false;
            this.zzcc();
            this.zzrg.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcb() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzro) {
                this.zzrp = true;
                try {
                    JSONObject jSONObject = this.zzch();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("JSON failure while processing active view data.", jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzb.zzb("Failure while processing active view data.", runtimeException);
                }
                zzb.zzaF("Untracking ad unit: " + this.zzre.zzbX());
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(boolean bl) {
        Object object = this.zzpd;
        synchronized (object) {
            boolean bl2;
            if (!this.zzrh || !this.zzro) {
                return;
            }
            if (bl && !this.zzqM.tryAcquire()) {
                return;
            }
            zzhs zzhs2 = (zzhs)this.zzrb.get();
            View view = (View)this.zzrd.get();
            boolean bl3 = bl2 = view == null || zzhs2 == null;
            if (bl2) {
                this.zzcb();
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzb.zza("Active view update failed.", throwable);
            }
            this.zzce();
            this.zzcc();
        }
    }

    protected void zzcc() {
        if (this.zzrl != null) {
            this.zzrl.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzcd() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzro;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzce() {
        View view = (View)this.zzrd.get();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzrc.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzcf();
        if (!this.zzrm || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzrm = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzrc = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzre.zzbX());
    }

    protected void zza(zzbe zzbe2) {
        zzbe2.zza("/updateActiveView", this.zzrs);
        zzbe2.zza("/untrackActiveViewUnit", this.zzrt);
        zzbe2.zza("/visibilityChanged", this.zzru);
    }

    protected void zzcf() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzrc.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzcg() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzre.zzbV()).put("activeViewJSON", (Object)this.zzre.zzbW()).put("timestamp", zzp.zzbz().elapsedRealtime()).put("adFormat", (Object)this.zzre.zzbU()).put("hashCode", (Object)this.zzre.zzbX()).put("isMraid", this.zzre.zzbY());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            final JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzrg.zza(new zzis.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzbe2.zza("AFMA_updateActiveView", jSONObject2);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzis.zzb());
        }
        catch (Throwable throwable) {
            zzb.zzb("Skipping active view message.", throwable);
        }
    }

    protected JSONObject zzd(View view) throws JSONException {
        boolean bl = zzp.zzbx().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzb.zzb("Failure getting view location.", exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzri.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzri.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzcg();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isStopped", this.zzrn).put("isPaused", this.zzpJ).put("isScreenOn", this.isScreenOn()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", this.zze(view));
        return jSONObject;
    }

    protected boolean zze(View view) {
        return view.getVisibility() == 0 && view.isShown() && this.isScreenOn() && (!this.zzrk.inKeyguardRestrictedInputMode() || zzp.zzbv().zzgB());
    }

    boolean isScreenOn() {
        return this.zzrj.isScreenOn();
    }

    protected JSONObject zzch() throws JSONException {
        JSONObject jSONObject = this.zzcg();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzh(true);
    }

    public void onGlobalLayout() {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzba zzba2) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzrl = zzba2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzrn = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzpJ = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzpJ = false;
            this.zzh(false);
        }
    }
}

