/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbj;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzmx;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public class zzbk
extends Thread {
    private boolean mStarted = false;
    private boolean zzrZ = false;
    private boolean zzam = false;
    private final Object zzpd;
    private final zzbj zzsa;
    private final zzbi zzsb;
    private final zzgq zzsc;
    private final int zzsd;
    private final int zzrN;
    private final int zzse;
    private final int zzrP;
    private final int zzsf;

    public zzbk(zzbj zzbj2, zzbi zzbi2, zzgq zzgq2) {
        this.zzsa = zzbj2;
        this.zzsb = zzbi2;
        this.zzsc = zzgq2;
        this.zzpd = new Object();
        this.zzrN = zzby.zzuU.get();
        this.zzse = zzby.zzuV.get();
        this.zzrP = zzby.zzuW.get();
        this.zzsf = zzby.zzuX.get();
        this.zzsd = zzby.zzuY.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzct() {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.mStarted) {
                zzb.zzaF("Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.zzam) {
            Object object;
            try {
                if (this.zzcu()) {
                    object = this.zzsa.getActivity();
                    if (object == null) {
                        zzb.zzaF("ContentFetchThread: no activity");
                        continue;
                    }
                    this.zza((Activity)object);
                } else {
                    zzb.zzaF("ContentFetchTask: sleeping");
                    this.zzcw();
                }
                Thread.sleep(this.zzsd * 1000);
            }
            catch (Throwable throwable) {
                zzb.zzb("Error in ContentFetchTask", throwable);
                this.zzsc.zza(throwable, true);
            }
            object = this.zzpd;
            synchronized (object) {
                while (this.zzrZ) {
                    try {
                        zzb.zzaF("ContentFetchTask: waiting");
                        this.zzpd.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzf(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzbk.this.zzg(view);
            }
        });
        return true;
    }

    void zzg(View view) {
        try {
            zzbh zzbh2 = new zzbh(this.zzrN, this.zzse, this.zzrP, this.zzsf);
            zza zza2 = this.zza(view, zzbh2);
            zzbh2.zzcq();
            if (zza2.zzsm == 0 && zza2.zzsn == 0) {
                return;
            }
            if (zza2.zzsn == 0 && zzbh2.zzcr() == 0) {
                return;
            }
            if (zza2.zzsn == 0 && this.zzsb.zza(zzbh2)) {
                return;
            }
            this.zzsb.zzc(zzbh2);
        }
        catch (Exception exception) {
            zzb.zzb("Exception in fetchContentOnUIThread", exception);
            this.zzsc.zza(exception, true);
        }
    }

    boolean zzr(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzcu() {
        try {
            Context context = this.zzsa.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzr(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zzf(view);
    }

    zza zza(View view, zzbh zzbh2) {
        if (view == null) {
            return new zza(0, 0);
        }
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string = charSequence.toString();
                zzbh2.zzw(string);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zziz)) {
            zzbh2.zzcp();
            if (this.zza((WebView)view, zzbh2)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzbh2);
                n += zza2.zzsm;
                n2 += zza2.zzsn;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    boolean zza(final WebView webView, final zzbh zzbh2) {
        if (!zzmx.zzqB()) {
            return false;
        }
        zzbh2.zzcp();
        webView.post(new Runnable(){
            ValueCallback<String> zzsi = new ValueCallback<String>(){

                public void zzy(String string) {
                    zzbk.this.zza(zzbh2, webView, string);
                }

                public /* synthetic */ void onReceiveValue(Object x0) {
                    this.zzy((String)x0);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzsi);
                    }
                    catch (Throwable throwable) {
                        this.zzsi.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzbh zzbh2, WebView webView, String string) {
        zzbh2.zzco();
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONObject jSONObject = new JSONObject(string);
                String string2 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    zzbh2.zzv(webView.getTitle() + "\n" + string2);
                } else {
                    zzbh2.zzv(string2);
                }
            }
            if (zzbh2.zzcl()) {
                this.zzsb.zzb(zzbh2);
            }
        }
        catch (JSONException jSONException) {
            zzb.zzaF("Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzb.zza("Failed to get webview content.", throwable);
            this.zzsc.zza(throwable, true);
        }
    }

    public zzbh zzcv() {
        return this.zzsb.zzcs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzrZ = false;
            this.zzpd.notifyAll();
            zzb.zzaF("ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcw() {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzrZ = true;
            zzb.zzaF("ContentFetchThread: paused, mPause = " + this.zzrZ);
        }
    }

    public boolean zzcx() {
        return this.zzrZ;
    }

    @zzgr
    class zza {
        final int zzsm;
        final int zzsn;

        zza(int n, int n2) {
            this.zzsm = n;
            this.zzsn = n2;
        }
    }
}

