/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzgr;
import java.util.Map;

@zzgr
public class zzif {
    private final Context mContext;
    private String zzII;
    private final float zzAC;
    private float zzIJ;
    private float zzIK;
    private float zzIL;
    private int mState = 0;

    public zzif(Context context) {
        this.mContext = context;
        this.zzAC = context.getResources().getDisplayMetrics().density;
    }

    public zzif(Context context, String string2) {
        this(context);
        this.zzII = string2;
    }

    public void zze(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzIJ = f;
            this.zzIK = f2;
            this.zzIL = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzIK) {
                    this.zzIK = f2;
                } else if (f2 < this.zzIL) {
                    this.zzIL = f2;
                }
                if (this.zzIK - this.zzIL > 30.0f * this.zzAC) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzIJ >= 50.0f * this.zzAC) {
                        this.zzIJ = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzIJ <= -50.0f * this.zzAC) {
                    this.zzIJ = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzIJ) {
                        this.zzIJ = f;
                    }
                } else if (this.mState == 2 && f < this.zzIJ) {
                    this.zzIJ = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void zzaC(String string2) {
        this.zzII = string2;
    }

    private void showDialog() {
        if (!(this.mContext instanceof Activity)) {
            zzb.zzaG("Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzif.zzaD(this.zzII);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzp.zzbv().zzb(zzif.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    static String zzaD(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzp.zzbv().zze(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

