/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.Parcel;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzha;

@zzha
public class AdSizeParcel
implements SafeParcelable {
    public static final zzi CREATOR = new zzi();
    public final int versionCode;
    public final String zztV;
    public final int height;
    public final int heightPixels;
    public final boolean zztW;
    public final int width;
    public final int widthPixels;
    public final AdSizeParcel[] zztX;
    public final boolean zztY;
    public final boolean zztZ;
    public boolean zzua;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)AdSizeParcel.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static AdSizeParcel zzt(Context context) {
        return new AdSizeParcel(5, "320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static AdSizeParcel zzcK() {
        return new AdSizeParcel(5, "reward_mb", 0, 0, false, 0, 0, null, false, false, false);
    }

    public AdSizeParcel() {
        this(5, "interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public AdSizeParcel(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public AdSizeParcel(Context context, AdSize[] adSizes) {
        int n;
        AdSize adSize = adSizes[0];
        this.versionCode = 5;
        this.zztW = false;
        this.zztZ = adSize.isFluid();
        if (this.zztZ) {
            this.width = AdSize.BANNER.getWidth();
            this.height = AdSize.BANNER.getHeight();
        } else {
            this.width = adSize.getWidth();
            this.height = adSize.getHeight();
        }
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzl.zzcN().zzU(context) && zzl.zzcN().zzV(context) ? AdSizeParcel.zza(displayMetrics) - zzl.zzcN().zzW(context) : AdSizeParcel.zza(displayMetrics);
            double d = (float)this.widthPixels / displayMetrics.density;
            n = (int)d;
            if (d - (double)((int)d) >= 0.01) {
                ++n;
            }
        } else {
            n = this.width;
            this.widthPixels = zzl.zzcN().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? AdSizeParcel.zzc(displayMetrics) : this.height;
        this.heightPixels = zzl.zzcN().zza(displayMetrics, n2);
        this.zztV = bl || bl2 ? n + "x" + n2 + "_as" : (this.zztZ ? "320x50_mb" : adSize.toString());
        if (adSizes.length > 1) {
            this.zztX = new AdSizeParcel[adSizes.length];
            for (int i = 0; i < adSizes.length; ++i) {
                this.zztX[i] = new AdSizeParcel(context, adSizes[i]);
            }
        } else {
            this.zztX = null;
        }
        this.zztY = false;
        this.zzua = false;
    }

    public AdSizeParcel(AdSizeParcel adSize, AdSizeParcel[] supportedAdSizes) {
        this(5, adSize.zztV, adSize.height, adSize.heightPixels, adSize.zztW, adSize.width, adSize.widthPixels, supportedAdSizes, adSize.zztY, adSize.zztZ, adSize.zzua);
    }

    AdSizeParcel(int versionCode, String formatString, int height, int heightPixels, boolean isInterstitial, int width, int widthPixels, AdSizeParcel[] supportedAdSizes, boolean isNative, boolean isFluid, boolean isNativeExpress) {
        this.versionCode = versionCode;
        this.zztV = formatString;
        this.height = height;
        this.heightPixels = heightPixels;
        this.zztW = isInterstitial;
        this.width = width;
        this.widthPixels = widthPixels;
        this.zztX = supportedAdSizes;
        this.zztY = isNative;
        this.zztZ = isFluid;
        this.zzua = isNativeExpress;
    }

    public int describeContents() {
        return 0;
    }

    public AdSize zzcL() {
        return zza.zza(this.width, this.height, this.zztV);
    }

    public void writeToParcel(Parcel out, int flags) {
        zzi.zza(this, out, flags);
    }

    public void zzi(boolean bl) {
        this.zzua = bl;
    }
}

