/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.internal.zzha;

@zzha
public final class zzk {
    private final AdSize[] zzuc;
    private final String zzpH;

    private static AdSize[] zzE(String string2) {
        String[] stringArray = string2.split("\\s*,\\s*");
        AdSize[] adSizeArray = new AdSize[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (string3.matches("^(\\d+|FULL_WIDTH)\\s*[xX]\\s*(\\d+|AUTO_HEIGHT)$")) {
                String[] stringArray2 = string3.split("[xX]");
                stringArray2[0] = stringArray2[0].trim();
                stringArray2[1] = stringArray2[1].trim();
                int n = 0;
                int n2 = 0;
                try {
                    n = "FULL_WIDTH".equals(stringArray2[0]) ? -1 : Integer.parseInt(stringArray2[0]);
                    n2 = "AUTO_HEIGHT".equals(stringArray2[1]) ? -2 : Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Could not parse XML attribute \"adSize\": " + string3);
                }
                adSizeArray[i] = new AdSize(n, n2);
                continue;
            }
            if ("BANNER".equals(string3)) {
                adSizeArray[i] = AdSize.BANNER;
                continue;
            }
            if ("LARGE_BANNER".equals(string3)) {
                adSizeArray[i] = AdSize.LARGE_BANNER;
                continue;
            }
            if ("FULL_BANNER".equals(string3)) {
                adSizeArray[i] = AdSize.FULL_BANNER;
                continue;
            }
            if ("LEADERBOARD".equals(string3)) {
                adSizeArray[i] = AdSize.LEADERBOARD;
                continue;
            }
            if ("MEDIUM_RECTANGLE".equals(string3)) {
                adSizeArray[i] = AdSize.MEDIUM_RECTANGLE;
                continue;
            }
            if ("SMART_BANNER".equals(string3)) {
                adSizeArray[i] = AdSize.SMART_BANNER;
                continue;
            }
            if ("WIDE_SKYSCRAPER".equals(string3)) {
                adSizeArray[i] = AdSize.WIDE_SKYSCRAPER;
                continue;
            }
            if ("FLUID".equals(string3)) {
                adSizeArray[i] = AdSize.FLUID;
                continue;
            }
            throw new IllegalArgumentException("Could not parse XML attribute \"adSize\": " + string3);
        }
        if (adSizeArray.length == 0) {
            throw new IllegalArgumentException("Could not parse XML attribute \"adSize\": " + string2);
        }
        return adSizeArray;
    }

    public zzk(Context context, AttributeSet attributeSet) {
        boolean bl;
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.AdsAttrs);
        String string2 = typedArray.getString(R.styleable.AdsAttrs_adSize);
        String string3 = typedArray.getString(R.styleable.AdsAttrs_adSizes);
        boolean bl2 = !TextUtils.isEmpty((CharSequence)string2);
        boolean bl3 = bl = !TextUtils.isEmpty((CharSequence)string3);
        if (bl2 && !bl) {
            this.zzuc = zzk.zzE(string2);
        } else if (!bl2 && bl) {
            this.zzuc = zzk.zzE(string3);
        } else {
            if (bl2 && bl) {
                throw new IllegalArgumentException("Either XML attribute \"adSize\" or XML attribute \"supportedAdSizes\" should be specified, but not both.");
            }
            throw new IllegalArgumentException("Required XML attribute \"adSize\" was missing.");
        }
        this.zzpH = typedArray.getString(R.styleable.AdsAttrs_adUnitId);
        if (TextUtils.isEmpty((CharSequence)this.zzpH)) {
            throw new IllegalArgumentException("Required XML attribute \"adUnitId\" was missing.");
        }
    }

    public AdSize[] zzj(boolean bl) {
        if (!bl && this.zzuc.length != 1) {
            throw new IllegalArgumentException("The adSizes XML attribute is only allowed on PublisherAdViews.");
        }
        return this.zzuc;
    }

    public String getAdUnitId() {
        return this.zzpH;
    }
}

