/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzha;
import java.util.concurrent.atomic.AtomicBoolean;

@zzha
public class zzz {
    private final zzev zzuu = new zzev();
    private final zzh zzoq;
    private final AtomicBoolean zzuv;
    private AdListener zzto;
    private zza zztn;
    private zzs zzuw;
    private AdSize[] zzuc;
    private String zzpH;
    private String zzux;
    private ViewGroup zzuy;
    private AppEventListener zzub;
    private InAppPurchaseListener zzuz;
    private PlayStorePurchaseListener zzuA;
    private OnCustomRenderedAdLoadedListener zzuB;
    private boolean zzpt;
    private Correlator zzuC;
    private boolean zzuD;

    public zzz(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzh.zzcJ(), false);
    }

    public zzz(ViewGroup viewGroup, boolean bl) {
        this(viewGroup, null, false, zzh.zzcJ(), bl);
    }

    public zzz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzh.zzcJ(), false);
    }

    public zzz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh.zzcJ(), bl2);
    }

    zzz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, zzs zzs2, boolean bl2) {
        this.zzuy = viewGroup;
        this.zzoq = zzh2;
        this.zzuw = zzs2;
        this.zzuv = new AtomicBoolean(false);
        this.zzuD = bl2;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzk zzk2 = new zzk(context, attributeSet);
                this.zzuc = zzk2.zzj(bl);
                this.zzpH = zzk2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzl.zzcN().zza(viewGroup, new AdSizeParcel(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzl.zzcN().zza(viewGroup, zzz.zza(context, this.zzuc[0], this.zzuD), "Ads by Google");
            }
        }
    }

    zzz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh2, null, bl2);
    }

    public void destroy() {
        try {
            if (this.zzuw != null) {
                this.zzuw.destroy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzto;
    }

    public AdSize getAdSize() {
        try {
            AdSizeParcel adSizeParcel;
            if (this.zzuw != null && (adSizeParcel = this.zzuw.zzaP()) != null) {
                return adSizeParcel.zzcL();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzuc != null ? this.zzuc[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzuc;
    }

    public String getAdUnitId() {
        return this.zzpH;
    }

    public AppEventListener getAppEventListener() {
        return this.zzub;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzuz;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzuB;
    }

    public void zza(zzy zzy2) {
        try {
            if (this.zzuw == null) {
                this.zzda();
            }
            if (this.zzuw.zzb(this.zzoq.zza(this.zzuy.getContext(), zzy2))) {
                this.zzuu.zze(zzy2.zzcV());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzuw != null) {
                this.zzuw.pause();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzuv.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzuw != null) {
                this.zzuw.zzaR();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzuw != null) {
                this.zzuw.resume();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzto = adListener;
            if (this.zzuw != null) {
                this.zzuw.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zztn = zza2;
            if (this.zzuw != null) {
                this.zzuw.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (this.zzuc != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizes);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzuc = adSizeArray;
        try {
            if (this.zzuw != null) {
                this.zzuw.zza(zzz.zza(this.zzuy.getContext(), this.zzuc, this.zzuD));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzuy.requestLayout();
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzpH != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzpH = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzub = appEventListener;
            if (this.zzuw != null) {
                this.zzuw.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzuA != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzuz = inAppPurchaseListener;
            if (this.zzuw != null) {
                this.zzuw.zza(inAppPurchaseListener != null ? new zzgh(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzuB = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzuw != null) {
                this.zzuw.zza(onCustomRenderedAdLoadedListener != null ? new zzcm(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzuz != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzuA = playStorePurchaseListener;
            this.zzux = publicKey;
            if (this.zzuw != null) {
                this.zzuw.zza(playStorePurchaseListener != null ? new zzgl(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
        this.zzpt = manualImpressionsEnabled;
        try {
            if (this.zzuw != null) {
                this.zzuw.setManualImpressionsEnabled(this.zzpt);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set manual impressions.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzuC = correlator;
        try {
            if (this.zzuw != null) {
                this.zzuw.zza(this.zzuC == null ? null : this.zzuC.zzaH());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set correlator.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzuw != null) {
                return this.zzuw.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public boolean isLoading() {
        try {
            if (this.zzuw != null) {
                return this.zzuw.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    private void zzcZ() {
        try {
            zzd zzd2 = this.zzuw.zzaO();
            if (zzd2 == null) {
                return;
            }
            this.zzuy.addView((View)zze.zzp((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    void zzda() throws RemoteException {
        if ((this.zzuc == null || this.zzpH == null) && this.zzuw == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        this.zzuw = this.zzdb();
        if (this.zzto != null) {
            this.zzuw.zza(new zzc(this.zzto));
        }
        if (this.zztn != null) {
            this.zzuw.zza(new zzb(this.zztn));
        }
        if (this.zzub != null) {
            this.zzuw.zza(new zzj(this.zzub));
        }
        if (this.zzuz != null) {
            this.zzuw.zza(new zzgh(this.zzuz));
        }
        if (this.zzuA != null) {
            this.zzuw.zza(new zzgl(this.zzuA), this.zzux);
        }
        if (this.zzuB != null) {
            this.zzuw.zza(new zzcm(this.zzuB));
        }
        if (this.zzuC != null) {
            this.zzuw.zza(this.zzuC.zzaH());
        }
        this.zzuw.setManualImpressionsEnabled(this.zzpt);
        this.zzcZ();
    }

    protected zzs zzdb() throws RemoteException {
        Context context = this.zzuy.getContext();
        return zzl.zzcO().zza(context, zzz.zza(context, this.zzuc, this.zzuD), this.zzpH, this.zzuu);
    }

    private static AdSizeParcel zza(Context context, AdSize[] adSizeArray, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSizeArray);
        adSizeParcel.zzi(bl);
        return adSizeParcel;
    }

    private static AdSizeParcel zza(Context context, AdSize adSize, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSize);
        adSizeParcel.zzi(bl);
        return adSizeParcel;
    }
}

