/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzip;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzha
public class zzc
extends zzi
implements AudioManager.OnAudioFocusChangeListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzCN = new HashMap<Integer, String>();
    private final zzp zzCO;
    private int zzCP = 0;
    private int zzCQ = 0;
    private MediaPlayer zzCR;
    private Uri zzCS;
    private int zzCT;
    private int zzCU;
    private int zzCV;
    private int zzCW;
    private int zzCX;
    private float zzCY = 1.0f;
    private boolean zzCZ;
    private boolean zzDa;
    private int zzDb;
    private zzh zzDc;

    public zzc(Context context, zzp zzp2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzCO = zzp2;
        this.zzCO.zza(this);
    }

    @Override
    public String zzeO() {
        return "MediaPlayer";
    }

    @Override
    public void zza(zzh zzh2) {
        this.zzDc = zzh2;
    }

    @Override
    public void setMimeType(String mimeType) {
    }

    @Override
    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.zzCS = uri;
        this.zzDb = 0;
        this.zzeP();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzb.v("AdMediaPlayerView stop");
        if (this.zzCR != null) {
            this.zzCR.stop();
            this.zzCR.release();
            this.zzCR = null;
            this.zzw(0);
            this.zzx(0);
            this.zzeS();
        }
        this.zzCO.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        zzb.v("AdMediaPlayerView size changed: " + width + " x " + height);
        this.zzCT = mp.getVideoWidth();
        this.zzCU = mp.getVideoHeight();
        if (this.zzCT != 0 && this.zzCU != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzb.v("AdMediaPlayerView prepared");
        this.zzw(2);
        this.zzCO.zzfo();
        zzip.zzKO.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzDc != null) {
                    zzc.this.zzDc.zzfo();
                }
            }
        });
        this.zzCT = mediaPlayer.getVideoWidth();
        this.zzCU = mediaPlayer.getVideoHeight();
        if (this.zzDb != 0) {
            this.seekTo(this.zzDb);
        }
        this.zzeQ();
        zzb.zzaG("AdMediaPlayerView stream dimensions: " + this.zzCT + " x " + this.zzCU);
        if (this.zzCQ == 3) {
            this.play();
        }
        this.zzeR();
        this.zzeY();
    }

    public void onCompletion(MediaPlayer mp) {
        zzb.v("AdMediaPlayerView completion");
        this.zzw(5);
        this.zzx(5);
        zzip.zzKO.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzDc != null) {
                    zzc.this.zzDc.zzfq();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        String string2 = zzCN.get(what);
        String string3 = zzCN.get(extra);
        zzb.v("AdMediaPlayerView MediaPlayer info: " + string2 + ":" + string3);
        return true;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        final String string2 = zzCN.get(what);
        final String string3 = zzCN.get(extra);
        zzb.zzaH("AdMediaPlayerView MediaPlayer error: " + string2 + ":" + string3);
        this.zzw(-1);
        this.zzx(-1);
        zzip.zzKO.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzDc != null) {
                    zzc.this.zzDc.zzg(string2, string3);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.zzCV = percent;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        zzb.v("AdMediaPlayerView surface created");
        this.zzeP();
        zzip.zzKO.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzDc != null) {
                    zzc.this.zzDc.zzfn();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int w, int h) {
        boolean bl;
        zzb.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzCQ == 3;
        boolean bl3 = bl = this.zzCT == w && this.zzCU == h;
        if (this.zzCR != null && bl2 && bl) {
            if (this.zzDb != 0) {
                this.seekTo(this.zzDb);
            }
            this.play();
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        zzb.v("AdMediaPlayerView surface destroyed");
        if (this.zzCR != null && this.zzDb == 0) {
            this.zzDb = this.zzCR.getCurrentPosition();
        }
        zzip.zzKO.post(new Runnable(){

            @Override
            public void run() {
                if (zzc.this.zzDc != null) {
                    zzc.this.zzDc.onPaused();
                    zzc.this.zzDc.zzfr();
                }
            }
        });
        this.zzv(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.zzCO.zzb(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = zzc.getDefaultSize((int)this.zzCT, (int)widthMeasureSpec);
        int n2 = zzc.getDefaultSize((int)this.zzCU, (int)heightMeasureSpec);
        if (this.zzCT > 0 && this.zzCU > 0) {
            int n3 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n5 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n6 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (n3 == 0x40000000 && n5 == 0x40000000) {
                n2 = n6;
                n = n4;
                if (this.zzCT * n2 < n * this.zzCU) {
                    n = n2 * this.zzCT / this.zzCU;
                } else if (this.zzCT * n2 > n * this.zzCU) {
                    n2 = n * this.zzCU / this.zzCT;
                }
            } else if (n3 == 0x40000000) {
                n = n4;
                n2 = n * this.zzCU / this.zzCT;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                }
            } else if (n5 == 0x40000000) {
                n2 = n6;
                n = n2 * this.zzCT / this.zzCU;
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                }
            } else {
                n = this.zzCT;
                n2 = this.zzCU;
                if (n5 == Integer.MIN_VALUE && n2 > n6) {
                    n2 = n6;
                    n = n2 * this.zzCT / this.zzCU;
                }
                if (n3 == Integer.MIN_VALUE && n > n4) {
                    n = n4;
                    n2 = n * this.zzCU / this.zzCT;
                }
            }
        }
        this.setMeasuredDimension(n, n2);
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzCW > 0 && this.zzCW != n || this.zzCX > 0 && this.zzCX != n2) {
                this.zzeQ();
            }
            this.zzCW = n;
            this.zzCX = n2;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private void zzeP() {
        zzb.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzCS == null || surfaceTexture == null) {
            return;
        }
        this.zzv(false);
        try {
            this.zzCR = new MediaPlayer();
            this.zzCR.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzCR.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzCR.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzCR.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzCR.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzCR.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzCV = 0;
            this.zzCR.setDataSource(this.getContext(), this.zzCS);
            this.zzCR.setSurface(new Surface(surfaceTexture));
            this.zzCR.setAudioStreamType(3);
            this.zzCR.setScreenOnWhilePlaying(true);
            this.zzCR.prepareAsync();
            this.zzw(1);
        }
        catch (IOException | IllegalArgumentException exception) {
            zzb.zzd("Failed to initialize MediaPlayer at " + this.zzCS, exception);
            this.onError(this.zzCR, 1, 0);
        }
    }

    private void zzeQ() {
        if (this.zzeT() && this.zzCR.getCurrentPosition() > 0 && this.zzCQ != 3) {
            long l;
            zzb.v("AdMediaPlayerView nudging MediaPlayer");
            this.zzb(0.0f);
            this.zzCR.start();
            int n = this.zzCR.getCurrentPosition();
            long l2 = com.google.android.gms.ads.internal.zzp.zzbB().currentTimeMillis();
            while (this.zzeT() && this.zzCR.getCurrentPosition() == n && (l = com.google.android.gms.ads.internal.zzp.zzbB().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzCR.pause();
            this.zzeY();
        }
    }

    private void zzeR() {
        AudioManager audioManager = this.zzeZ();
        if (audioManager != null && !this.zzDa) {
            int n = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
            if (n == 1) {
                this.zzeW();
            } else {
                zzb.zzaH("AdMediaPlayerView audio focus request failed");
            }
        }
    }

    private void zzeS() {
        zzb.v("AdMediaPlayerView abandon audio focus");
        AudioManager audioManager = this.zzeZ();
        if (audioManager != null && this.zzDa) {
            int n = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            if (n == 1) {
                this.zzDa = false;
            } else {
                zzb.zzaH("AdMediaPlayerView abandon audio focus failed");
            }
        }
    }

    private void zzv(boolean bl) {
        zzb.v("AdMediaPlayerView release");
        if (this.zzCR != null) {
            this.zzCR.reset();
            this.zzCR.release();
            this.zzCR = null;
            this.zzw(0);
            if (bl) {
                this.zzCQ = 0;
                this.zzx(0);
            }
            this.zzeS();
        }
    }

    @Override
    public void play() {
        zzb.v("AdMediaPlayerView play");
        if (this.zzeT()) {
            this.zzCR.start();
            this.zzw(3);
            zzip.zzKO.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzDc != null) {
                        zzc.this.zzDc.zzfp();
                    }
                }
            });
        }
        this.zzx(3);
    }

    @Override
    public void pause() {
        zzb.v("AdMediaPlayerView pause");
        if (this.zzeT() && this.zzCR.isPlaying()) {
            this.zzCR.pause();
            this.zzw(4);
            zzip.zzKO.post(new Runnable(){

                @Override
                public void run() {
                    if (zzc.this.zzDc != null) {
                        zzc.this.zzDc.onPaused();
                    }
                }
            });
        }
        this.zzx(4);
    }

    @Override
    public int getDuration() {
        if (this.zzeT()) {
            return this.zzCR.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzeT()) {
            return this.zzCR.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int millis) {
        zzb.v("AdMediaPlayerView seek " + millis);
        if (this.zzeT()) {
            this.zzCR.seekTo(millis);
            this.zzDb = 0;
        } else {
            this.zzDb = millis;
        }
    }

    private boolean zzeT() {
        return this.zzCR != null && this.zzCP != -1 && this.zzCP != 0 && this.zzCP != 1;
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange > 0) {
            this.zzeW();
        } else if (focusChange < 0) {
            this.zzeX();
        }
    }

    @Override
    public void zzeU() {
        this.zzCZ = true;
        this.zzeY();
    }

    @Override
    public void zzeV() {
        this.zzCZ = false;
        this.zzeY();
    }

    @Override
    public void zza(float f) {
        this.zzCY = f;
        this.zzeY();
    }

    @Override
    public int getVideoWidth() {
        if (this.zzCR != null) {
            return this.zzCR.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzCR != null) {
            return this.zzCR.getVideoHeight();
        }
        return 0;
    }

    private void zzeW() {
        zzb.v("AdMediaPlayerView audio focus gained");
        this.zzDa = true;
        this.zzeY();
    }

    private void zzeX() {
        zzb.v("AdMediaPlayerView audio focus lost");
        this.zzDa = false;
        this.zzeY();
    }

    private void zzeY() {
        if (!this.zzCZ && this.zzDa) {
            this.zzb(this.zzCY);
        } else {
            this.zzb(0.0f);
        }
    }

    private void zzb(float f) {
        if (this.zzCR != null) {
            try {
                this.zzCR.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzb.zzaH("AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private AudioManager zzeZ() {
        Context context = this.getContext();
        return (AudioManager)context.getSystemService("audio");
    }

    private void zzw(int n) {
        if (n == 3) {
            this.zzCO.zzfB();
        } else if (this.zzCP == 3 && n != 3) {
            this.zzCO.zzfC();
        }
        this.zzCP = n;
    }

    private void zzx(int n) {
        this.zzCQ = n;
    }

    static {
        zzCN.put(-1004, "MEDIA_ERROR_IO");
        zzCN.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzCN.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzCN.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzCN.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzCN.put(1, "MEDIA_ERROR_UNKNOWN");
        zzCN.put(1, "MEDIA_INFO_UNKNOWN");
        zzCN.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzCN.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzCN.put(701, "MEDIA_INFO_BUFFERING_START");
        zzCN.put(702, "MEDIA_INFO_BUFFERING_END");
        zzCN.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzCN.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzCN.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzCN.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzCN.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }
}

