/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzip;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzha
public class zzc
extends zzil
implements ServiceConnection {
    private final Object zzpK = new Object();
    private boolean zzEA = false;
    private Context mContext;
    private zzgg zzAe;
    private zzb zzEB;
    private zzh zzEC;
    private List<zzf> zzED = null;
    private zzk zzEE;

    public zzc(Context context, zzgg zzgg2, zzk zzk2) {
        this(context, zzgg2, zzk2, new zzb(context), zzh.zzy(context.getApplicationContext()));
    }

    zzc(Context context, zzgg zzgg2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzAe = zzgg2;
        this.zzEE = zzk2;
        this.zzEB = zzb2;
        this.zzEC = zzh2;
        this.zzED = this.zzEC.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbp() {
        Object object = this.zzpK;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzrz().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzrz().zza(this.mContext, (ServiceConnection)this);
            this.zzEB.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzpK;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzrz().zza(this.mContext, (ServiceConnection)this);
            this.zzEB.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        com.google.android.gms.ads.internal.util.client.zzb.zzaG("In-app billing service disconnected.");
        this.zzEB.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzEB.zzN(service);
            this.zzfJ();
            this.zzEA = true;
            this.zzpK.notify();
        }
    }

    protected void zzfJ() {
        int n;
        Bundle bundle;
        if (this.zzED.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzED) {
            hashMap.put(object2.zzEQ, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzEB.zzi(this.mContext.getPackageName(), (String)object3)) != null && (n = zzp.zzbH().zzd(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string2 = (String)arrayList.get(i);
                String string3 = (String)arrayList2.get(i);
                String string4 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string2);
                String string5 = zzp.zzbH().zzap(string3);
                if (!zzf2.zzEP.equals(string5)) continue;
                this.zza(zzf2, string3, string4);
                hashMap.remove(string2);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string6 : hashMap.keySet()) {
            this.zzEC.zza((zzf)hashMap.get(string6));
        }
    }

    protected void zza(final zzf zzf2, String string2, String string3) {
        final Intent intent = new Intent();
        zzp.zzbH();
        intent.putExtra("RESPONSE_CODE", 0);
        zzp.zzbH();
        intent.putExtra("INAPP_PURCHASE_DATA", string2);
        zzp.zzbH();
        intent.putExtra("INAPP_DATA_SIGNATURE", string3);
        zzip.zzKO.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzEE.zza(zzf2.zzEP, -1, intent)) {
                        zzc.this.zzAe.zza(new zzg(zzc.this.mContext, zzf2.zzEQ, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzAe.zza(new zzg(zzc.this.mContext, zzf2.zzEQ, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaH("Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l) {
        do {
            if (this.zzf(l)) continue;
            com.google.android.gms.ads.internal.util.client.zzb.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzEA);
    }

    private boolean zzf(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzpK.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

