/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjh;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzb
extends zzil
implements zzc.zza {
    private final zza.zza zzGd;
    private final AdRequestInfoParcel.zza zzGe;
    private final Object zzFf = new Object();
    private final Context mContext;
    private final zzan zzxV;
    private AdRequestInfoParcel zzBu;
    private Runnable zzFe;
    zzir zzGf;
    AdResponseParcel zzFd;
    zzen zzBf;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzan zzan2, zza.zza zza3) {
        this.zzGd = zza3;
        this.mContext = context;
        this.zzGe = zza2;
        this.zzxV = zzan2;
    }

    zzir zza(VersionInfoParcel versionInfoParcel, zzjg<AdRequestInfoParcel> zzjg2) {
        return zzc.zza(this.mContext, versionInfoParcel, zzjg2, this);
    }

    @Override
    public void zzbp() {
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("AdLoaderBackgroundTask started.");
        this.zzFe = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzFf;
                synchronized (object) {
                    if (zzb.this.zzGf == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zze(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzip.zzKO.postDelayed(this.zzFe, zzbz.zzwB.get().longValue());
        final zzjh<AdRequestInfoParcel> zzjh2 = new zzjh<AdRequestInfoParcel>();
        long l = zzp.zzbB().elapsedRealtime();
        zzio.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzFf;
                synchronized (object) {
                    zzb.this.zzGf = zzb.this.zza(((zzb)zzb.this).zzGe.zzqR, zzjh2);
                    if (zzb.this.zzGf == null) {
                        zzb.this.zze(0, "Could not start the ad request service.");
                        zzip.zzKO.removeCallbacks(zzb.this.zzFe);
                    }
                }
            }
        });
        zzaj zzaj2 = this.zzxV.zzac();
        String string2 = zzaj2.zzb(this.mContext);
        this.zzBu = new AdRequestInfoParcel(this.zzGe, string2, l);
        zzjh2.zzg(this.zzBu);
    }

    private void zze(int n, String string2) {
        if (n == 3 || n == -1) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaG(string2);
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH(string2);
        }
        this.zzFd = this.zzFd == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzFd.zzAU);
        AdRequestInfoParcel adRequestInfoParcel = this.zzBu != null ? this.zzBu : new AdRequestInfoParcel(this.zzGe, null, -1L);
        zzie.zza zza2 = new zzie.zza(adRequestInfoParcel, this.zzFd, this.zzBf, null, n, -1L, this.zzFd.zzGR, null);
        this.zzGd.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("Received ad response.");
        this.zzFd = adResponseParcel;
        long l = zzp.zzbB().elapsedRealtime();
        Object object = this.zzFf;
        synchronized (object) {
            this.zzGf = null;
        }
        object = null;
        try {
            if (this.zzFd.errorCode != -2 && this.zzFd.errorCode != -3) {
                throw new zza("There was a problem getting an ad response. ErrorCode: " + this.zzFd.errorCode, this.zzFd.errorCode);
            }
            this.zzgd();
            if (this.zzBu.zzqV.zztX != null) {
                object = this.zzb(this.zzBu);
            }
        }
        catch (zza zza2) {
            this.zze(zza2.getErrorCode(), zza2.getMessage());
            zzip.zzKO.removeCallbacks(this.zzFe);
            return;
        }
        zzp.zzbA().zzB(this.zzFd.zzGX);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzFd.zzGV)) {
            try {
                jSONObject = new JSONObject(this.zzFd.zzGV);
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb("Error parsing the JSON for Active View.", exception);
            }
        }
        zzie.zza zza3 = new zzie.zza(this.zzBu, this.zzFd, this.zzBf, (AdSizeParcel)object, -2, l, this.zzFd.zzGR, jSONObject);
        this.zzGd.zza(zza3);
        zzip.zzKO.removeCallbacks(this.zzFe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzFf;
        synchronized (object) {
            if (this.zzGf != null) {
                this.zzGf.cancel();
            }
        }
    }

    protected void zzgd() throws zza {
        if (this.zzFd.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzFd.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzp.zzbA().zza(this.mContext, this.zzFd.zzGy);
        if (this.zzFd.zzGN) {
            try {
                this.zzBf = new zzen(this.zzFd.body);
            }
            catch (JSONException jSONException) {
                throw new zza("Could not parse mediation config: " + this.zzFd.body, 0);
            }
        }
    }

    protected AdSizeParcel zzb(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzFd.zzGQ == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzFd.zzGQ.split("x");
        if (stringArray.length != 2) {
            throw new zza("Invalid ad size format from the ad response: " + this.zzFd.zzGQ, 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zza("Invalid ad size number from the ad response: " + this.zzFd.zzGQ, 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzqV.zztX) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzqV.zztX);
        }
        throw new zza("The ad size from the ad response was not one of the requested sizes: " + this.zzFd.zzGQ, 0);
    }

    @zzha
    static final class zza
    extends Exception {
        private final int zzFt;

        public zza(String string2, int n) {
            super(string2);
            this.zzFt = n;
        }

        public int getErrorCode() {
            return this.zzFt;
        }
    }
}

