/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzdm;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzei;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzm
extends zzil {
    static final long zzHl = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzqf = new Object();
    private static boolean zzHm = false;
    private static zzei zzHn = null;
    private static zzdm zzHo = null;
    private static zzdq zzHp = null;
    private static zzdl zzHq = null;
    private final zza.zza zzGd;
    private final AdRequestInfoParcel.zza zzGe;
    private final Object zzFf = new Object();
    private final Context mContext;
    private zzei.zzd zzHr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzm(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzGd = zza3;
        this.mContext = context;
        this.zzGe = zza2;
        Object object = zzqf;
        synchronized (object) {
            if (!zzHm) {
                zzHp = new zzdq();
                zzHo = new zzdm(context.getApplicationContext(), zza2.zzqR);
                zzHq = new zzc();
                zzHn = new zzei(this.mContext.getApplicationContext(), this.zzGe.zzqR, zzbz.zzvg.get(), new zzb(), new zza());
                zzHm = true;
            }
        }
    }

    protected static void zzc(zzbb zzbb2) {
        zzbb2.zza("/loadAd", zzHp);
        zzbb2.zza("/fetchHttpRequest", zzHo);
        zzbb2.zza("/invalidRequest", zzHq);
    }

    protected static void zzd(zzbb zzbb2) {
        zzbb2.zzb("/loadAd", zzHp);
        zzbb2.zzb("/fetchHttpRequest", zzHo);
        zzbb2.zzb("/invalidRequest", zzHq);
    }

    @Override
    public void zzbp() {
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzGe, null, -1L);
        AdResponseParcel adResponseParcel = this.zze(adRequestInfoParcel);
        long l = zzp.zzbB().elapsedRealtime();
        final zzie.zza zza2 = new zzie.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzGR, null);
        com.google.android.gms.ads.internal.util.client.zza.zzLE.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzGd.zza(zza2);
                if (zzm.this.zzHr != null) {
                    zzm.this.zzHr.release();
                    zzm.this.zzHr = null;
                }
            }
        });
    }

    private AdResponseParcel zze(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string2 = UUID.randomUUID().toString();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string2);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzp.zzbB().elapsedRealtime();
        Future<JSONObject> future = zzHp.zzW(string2);
        com.google.android.gms.ads.internal.util.client.zza.zzLE.post(new Runnable(){

            @Override
            public void run() {
                zzm.this.zzHr = zzHn.zzei();
                zzm.this.zzHr.zza(new zzjg.zzc<zzbe>(){

                    public void zzb(zzbe zzbe2) {
                        try {
                            zzbe2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error requesting an ad url", exception);
                            zzHp.zzX(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzc(Object object) {
                        this.zzb((zzbe)object);
                    }
                }, new zzjg.zza(){

                    @Override
                    public void run() {
                        zzHp.zzX(string2);
                    }
                });
            }
        });
        long l2 = zzHl - (zzp.zzbB().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzhd.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string2) {
        Bundle bundle = adRequestInfoParcel.zzGq.extras.getBundle("sdk_less_server_data");
        String string3 = adRequestInfoParcel.zzGq.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzhd.zza(this.mContext, adRequestInfoParcel, zzp.zzbD().zzE(this.mContext), null, null, new zzbs(zzbz.zzvg.get()), null, null, new ArrayList<String>(), null);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Cannot get advertising id info", throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("network_id", string3);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzp.zzbx().zzz(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzFf;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzLE.post(new Runnable(){

                @Override
                public void run() {
                    if (zzm.this.zzHr != null) {
                        zzm.this.zzHr.release();
                        zzm.this.zzHr = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzei.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzm.zzd(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzb
    implements zzei.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzm.zzc(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzc
    implements zzdl {
        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Invalid request: " + string3);
            zzHp.zzX(string2);
        }
    }
}

