/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzv;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbl;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzcl;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzii;
import com.google.android.gms.internal.zzij;
import java.util.HashSet;

@zzha
public abstract class zza
extends zzs.zza
implements com.google.android.gms.ads.internal.client.zza,
zzn,
zza.zza,
zzdh,
zzgq.zza,
zzii {
    protected zzch zzoU;
    protected zzcf zzoV;
    protected zzcf zzoW;
    protected boolean zzoX = false;
    protected final zzo zzoY;
    protected final zzq zzoZ;
    protected transient AdRequestParcel zzpa;
    protected final zzay zzpb;
    protected final zzd zzpc;

    zza(zzq zzq2, zzo zzo2, zzd zzd2) {
        this.zzoZ = zzq2;
        this.zzoY = zzo2 != null ? zzo2 : new zzo(this);
        this.zzpc = zzd2;
        zzp.zzbx().zzK(this.zzoZ.context);
        zzp.zzbA().zzb(this.zzoZ.context, this.zzoZ.zzqR);
        this.zzpb = zzp.zzbA().zzgR();
    }

    void zzaN() {
        this.zzoU = new zzch(zzbz.zzvL.get(), "load_ad", this.zzoZ.zzqV.zztV);
        this.zzoV = new zzcf(-1L, null, null);
        this.zzoW = new zzcf(-1L, null, null);
    }

    @Override
    public void destroy() {
        zzx.zzcx((String)"destroy must be called on the main UI thread.");
        this.zzoY.cancel();
        this.zzpb.zzf(this.zzoZ.zzqW);
        this.zzoZ.destroy();
    }

    @Override
    public com.google.android.gms.dynamic.zzd zzaO() {
        zzx.zzcx((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzB((Object)((Object)this.zzoZ.zzqS));
    }

    @Override
    public AdSizeParcel zzaP() {
        zzx.zzcx((String)"getAdSize must be called on the main UI thread.");
        return this.zzoZ.zzqV == null ? null : new ThinAdSizeParcel(this.zzoZ.zzqV);
    }

    @Override
    public boolean isReady() {
        zzx.zzcx((String)"isLoaded must be called on the main UI thread.");
        return this.zzoZ.zzqT == null && this.zzoZ.zzqU == null && this.zzoZ.zzqW != null;
    }

    @Override
    public void setManualImpressionsEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (GooglePlayServicesUtil.zzao((Context)this.zzoZ.context) && adRequestParcel.zzty != null) {
            return new zzf(adRequestParcel).zza(null).zzcI();
        }
        return adRequestParcel;
    }

    @Override
    public boolean zzb(AdRequestParcel adRequestParcel) {
        zzx.zzcx((String)"loadAd must be called on the main UI thread.");
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzoZ.zzqT != null || this.zzoZ.zzqU != null) {
            if (this.zzpa != null) {
                zzb.zzaH("Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzb.zzaH("Loading already in progress, saving this object for future refreshes.");
            }
            this.zzpa = adRequestParcel;
            return false;
        }
        zzb.zzaG("Starting ad request.");
        this.zzaN();
        this.zzoV = this.zzoU.zzdu();
        if (!adRequestParcel.zztt) {
            zzb.zzaG("Use AdRequest.Builder.addTestDevice(\"" + zzl.zzcN().zzS(this.zzoZ.context) + "\") to get test ads on this device.");
        }
        this.zzoX = this.zza(adRequestParcel, this.zzoU);
        return this.zzoX;
    }

    protected abstract boolean zza(AdRequestParcel var1, zzch var2);

    @Override
    public void zza(zzie.zza zza2) {
        long l;
        if (zza2.zzJL.zzGR != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzJL.zzHb) && (l = this.zzo(zza2.zzJL.zzHb)) != -1L) {
            zzcf zzcf2 = this.zzoU.zzb(zza2.zzJL.zzGR + l);
            this.zzoU.zza(zzcf2, "stc");
        }
        this.zzoU.zzR(zza2.zzJL.zzHb);
        this.zzoU.zza(this.zzoV, "arf");
        this.zzoW = this.zzoU.zzdu();
        this.zzoU.zzd("gqi", zza2.zzJL.zzHc);
        this.zzoZ.zzqT = null;
        this.zzoZ.zzqX = zza2;
        this.zza(zza2, this.zzoU);
    }

    protected abstract void zza(zzie.zza var1, zzch var2);

    boolean zza(zzie zzie2) {
        return false;
    }

    @Override
    public void zzb(zzie zzie2) {
        this.zzoU.zza(this.zzoW, "awr");
        this.zzoZ.zzqU = null;
        if (zzie2.errorCode != -2 && zzie2.errorCode != 3) {
            zzp.zzbA().zzb(this.zzoZ.zzbM());
        }
        if (zzie2.errorCode == -1) {
            this.zzoX = false;
            return;
        }
        if (this.zza(zzie2)) {
            zzb.zzaF("Ad refresh scheduled.");
        }
        if (zzie2.errorCode != -2) {
            this.zzf(zzie2.errorCode);
            return;
        }
        if (this.zzoZ.zzrn == null) {
            this.zzoZ.zzrn = new zzij(this.zzoZ.zzqP);
        }
        this.zzpb.zze(this.zzoZ.zzqW);
        if (this.zza(this.zzoZ.zzqW, zzie2)) {
            this.zzoZ.zzqW = zzie2;
            this.zzoZ.zzbV();
            this.zzoU.zzd("is_mraid", this.zzoZ.zzqW.zzcb() ? "1" : "0");
            this.zzoU.zzd("is_mediation", this.zzoZ.zzqW.zzGN ? "1" : "0");
            if (this.zzoZ.zzqW.zzDC != null && this.zzoZ.zzqW.zzDC.zzhC() != null) {
                this.zzoU.zzd("is_video", this.zzoZ.zzqW.zzDC.zzhC().zzhP() ? "1" : "0");
            }
            this.zzoU.zza(this.zzoV, "ttc");
            if (zzp.zzbA().zzgM() != null) {
                zzp.zzbA().zzgM().zza(this.zzoU);
            }
            if (this.zzoZ.zzbQ()) {
                this.zzaV();
            }
        }
    }

    protected abstract boolean zza(zzie var1, zzie var2);

    @Override
    public void onAdClicked() {
        if (this.zzoZ.zzqW == null) {
            zzb.zzaH("Ad state was null when trying to ping click URLs.");
            return;
        }
        zzb.zzaF("Pinging click URLs.");
        this.zzoZ.zzqY.zzgE();
        if (this.zzoZ.zzqW.zzAQ != null) {
            zzp.zzbx().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, this.zzoZ.zzqW.zzAQ);
        }
        if (this.zzoZ.zzqZ != null) {
            try {
                this.zzoZ.zzqZ.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not notify onAdClicked event.", remoteException);
            }
        }
    }

    @Override
    public void zzaQ() {
        this.zzaT();
    }

    @Override
    public void onAppEvent(String name, String info) {
        if (this.zzoZ.zzrb != null) {
            try {
                this.zzoZ.zzrb.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    @Override
    public void zzaR() {
        zzx.zzcx((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzoZ.zzqW == null) {
            zzb.zzaH("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzb.zzaF("Pinging manual tracking URLs.");
        if (this.zzoZ.zzqW.zzGP != null) {
            zzp.zzbx().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, this.zzoZ.zzqW.zzGP);
        }
    }

    @Override
    public void pause() {
        zzx.zzcx((String)"pause must be called on the main UI thread.");
    }

    @Override
    public void resume() {
        zzx.zzcx((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        ViewParent viewParent = this.zzoZ.zzqS.getParent();
        return viewParent instanceof View && ((View)viewParent).isShown() && zzp.zzbx().zzgY();
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzb.zzaG("Ad is not visible. Not refreshing ad.");
            this.zzoY.zzg(adRequestParcel);
        }
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzo zzo2) {
        zzx.zzcx((String)"setAdListener must be called on the main UI thread.");
        this.zzoZ.zzra = zzo2;
    }

    @Override
    public void zza(com.google.android.gms.ads.internal.client.zzn zzn2) {
        zzx.zzcx((String)"setAdListener must be called on the main UI thread.");
        this.zzoZ.zzqZ = zzn2;
    }

    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        zzx.zzcx((String)"setAdSize must be called on the main UI thread.");
        this.zzoZ.zzqV = adSizeParcel;
        if (this.zzoZ.zzqW != null && this.zzoZ.zzqW.zzDC != null && this.zzoZ.zzrp == 0) {
            this.zzoZ.zzqW.zzDC.zza(adSizeParcel);
        }
        if (this.zzoZ.zzqS == null) {
            return;
        }
        if (this.zzoZ.zzqS.getChildCount() > 1) {
            this.zzoZ.zzqS.removeView(this.zzoZ.zzqS.getNextView());
        }
        this.zzoZ.zzqS.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzoZ.zzqS.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzoZ.zzqS.requestLayout();
    }

    @Override
    public void zza(zzu zzu2) {
        zzx.zzcx((String)"setAppEventListener must be called on the main UI thread.");
        this.zzoZ.zzrb = zzu2;
    }

    @Override
    public void zza(zzgc zzgc2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    @Override
    public void zza(zzcl zzcl2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    @Override
    public void zza(zzgg zzgg2, String string2) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    @Override
    public void zza(zzv zzv2) {
        zzx.zzcx((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzoZ.zzrc = zzv2;
    }

    @Override
    public void stopLoading() {
        zzx.zzcx((String)"stopLoading must be called on the main UI thread.");
        this.zzoX = false;
        this.zzoZ.zzf(true);
    }

    @Override
    public boolean isLoading() {
        return this.zzoX;
    }

    Bundle zza(zzbl zzbl2) {
        if (zzbl2 == null) {
            return null;
        }
        if (zzbl2.zzcF()) {
            zzbl2.wakeup();
        }
        zzbi zzbi2 = zzbl2.zzcD();
        String string2 = null;
        if (zzbi2 != null) {
            string2 = zzbi2.zzcu();
            zzb.zzaF("In AdManger: loadAd, " + zzbi2.toString());
        }
        if (string2 != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string2);
            bundle.putInt("v", 1);
            return bundle;
        }
        return null;
    }

    long zzo(String string2) {
        int n = string2.indexOf("ufe");
        int n2 = string2.indexOf(44, n);
        if (n2 == -1) {
            n2 = string2.length();
        }
        try {
            return Long.parseLong(string2.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzb.zzaH("Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzb.zzaH("Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        this.zzoZ.zzqS.addView(view, zzp.zzbz().zzhg());
    }

    protected boolean zzaS() {
        zzb.v("Ad closing.");
        if (this.zzoZ.zzra == null) {
            return false;
        }
        try {
            this.zzoZ.zzra.onAdClosed();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdClosed().", remoteException);
            return false;
        }
    }

    private boolean zzaT() {
        zzb.zzaG("Ad leaving application.");
        if (this.zzoZ.zzra == null) {
            return false;
        }
        try {
            this.zzoZ.zzra.onAdLeftApplication();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLeftApplication().", remoteException);
            return false;
        }
    }

    protected boolean zzaU() {
        zzb.zzaG("Ad opening.");
        if (this.zzoZ.zzra == null) {
            return false;
        }
        try {
            this.zzoZ.zzra.onAdOpened();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdOpened().", remoteException);
            return false;
        }
    }

    protected boolean zzaV() {
        zzb.zzaG("Ad finished loading.");
        this.zzoX = false;
        if (this.zzoZ.zzra == null) {
            return false;
        }
        try {
            this.zzoZ.zzra.onAdLoaded();
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdLoaded().", remoteException);
            return false;
        }
    }

    protected boolean zzf(int n) {
        zzb.zzaH("Failed to load ad: " + n);
        this.zzoX = false;
        if (this.zzoZ.zzra == null) {
            return false;
        }
        try {
            this.zzoZ.zzra.onAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call AdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    protected void recordImpression() {
        this.zzc(this.zzoZ.zzqW);
    }

    protected void zzc(zzie zzie2) {
        if (zzie2 == null) {
            zzb.zzaH("Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzb.zzaF("Pinging Impression URLs.");
        this.zzoZ.zzqY.zzgD();
        if (zzie2.zzAR != null) {
            zzp.zzbx().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, zzie2.zzAR);
        }
    }

    @Override
    public void zza(HashSet<zzif> hashSet) {
        this.zzoZ.zza(hashSet);
    }
}

