/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzdn;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzgc;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzip;
import java.util.ArrayList;
import java.util.UUID;

@zzha
public abstract class zzb
extends zza
implements zzg,
zzj,
zzdn,
zzeo {
    protected final zzew zzpd;
    private final Messenger mMessenger;
    protected transient boolean zzpe;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string2, zzew zzew2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzq(context, adSizeParcel, string2, versionInfoParcel), zzew2, null, zzd2);
    }

    zzb(zzq zzq2, zzew zzew2, zzo zzo2, zzd zzd2) {
        super(zzq2, zzo2, zzd2);
        this.zzpd = zzew2;
        this.mMessenger = new Messenger((Handler)new zzfz(this.zzoZ.context));
        this.zzpe = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzch zzch2) {
        if (!this.zzaW()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzp.zzbA().zzG(this.zzoZ.context));
        this.zzoY.cancel();
        this.zzoZ.zzrp = 0;
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle);
        zzch2.zzd("seq_num", zza2.zzGt);
        zzch2.zzd("request_id", zza2.zzGF);
        zzch2.zzd("session_id", zza2.zzGu);
        if (zza2.zzGr != null) {
            zzch2.zzd("app_version", String.valueOf(zza2.zzGr.versionCode));
        }
        this.zzoZ.zzqT = zzp.zzbt().zza(this.zzoZ.context, zza2, this.zzoZ.zzqQ, this);
        return true;
    }

    @Override
    public void zzb(zzie zzie2) {
        super.zzb(zzie2);
        if (zzie2.errorCode == 3 && zzie2.zzJF != null && zzie2.zzJF.zzAS != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Pinging no fill URLs.");
            zzp.zzbK().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, zzie2, this.zzoZ.zzqP, false, zzie2.zzJF.zzAS);
        }
    }

    @Override
    protected boolean zza(zzie zzie2, zzie zzie3) {
        if (zzie2 != null && zzie2.zzBs != null) {
            zzie2.zzBs.zza((zzeo)null);
        }
        if (zzie3.zzBs != null) {
            zzie3.zzBs.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzie3.zzJF != null) {
            n = zzie3.zzJF.zzAZ;
            n2 = zzie3.zzJF.zzBa;
        }
        this.zzoZ.zzrn.zzg(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzoZ.zzqW == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzoZ.zzqW.zzJF != null && this.zzoZ.zzqW.zzJF.zzAQ != null) {
            zzp.zzbK().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, this.zzoZ.zzqW, this.zzoZ.zzqP, false, this.zzoZ.zzqW.zzJF.zzAQ);
        }
        if (this.zzoZ.zzqW.zzBp != null && this.zzoZ.zzqW.zzBp.zzAJ != null) {
            zzp.zzbK().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, this.zzoZ.zzqW, this.zzoZ.zzqP, false, this.zzoZ.zzqW.zzBp.zzAJ);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzie zzie2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzpa != null) {
            adRequestParcel = this.zzpa;
            this.zzpa = null;
        } else {
            adRequestParcel = zzie2.zzGq;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzie2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzie zzie2, boolean bl) {
        if (!bl && this.zzoZ.zzbQ()) {
            if (zzie2.zzAU > 0L) {
                this.zzoY.zza(adRequestParcel, zzie2.zzAU);
            } else if (zzie2.zzJF != null && zzie2.zzJF.zzAU > 0L) {
                this.zzoY.zza(adRequestParcel, zzie2.zzJF.zzAU);
            } else if (!zzie2.zzGN && zzie2.errorCode == 2) {
                this.zzoY.zzg(adRequestParcel);
            }
        }
        return this.zzoY.zzbr();
    }

    @Override
    public void pause() {
        zzx.zzcx((String)"pause must be called on the main UI thread.");
        if (this.zzoZ.zzqW != null && this.zzoZ.zzqW.zzDC != null && this.zzoZ.zzbQ()) {
            zzp.zzbz().zzf(this.zzoZ.zzqW.zzDC);
        }
        if (this.zzoZ.zzqW != null && this.zzoZ.zzqW.zzBq != null) {
            try {
                this.zzoZ.zzqW.zzBq.pause();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not pause mediation adapter.");
            }
        }
        this.zzpb.zzg(this.zzoZ.zzqW);
        this.zzoY.pause();
    }

    @Override
    public void resume() {
        zzx.zzcx((String)"resume must be called on the main UI thread.");
        if (this.zzoZ.zzqW != null && this.zzoZ.zzqW.zzDC != null && this.zzoZ.zzbQ()) {
            zzp.zzbz().zzg(this.zzoZ.zzqW.zzDC);
        }
        if (this.zzoZ.zzqW != null && this.zzoZ.zzqW.zzBq != null) {
            try {
                this.zzoZ.zzqW.zzBq.resume();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not resume mediation adapter.");
            }
        }
        this.zzoY.resume();
        this.zzpb.zzh(this.zzoZ.zzqW);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzpe;
    }

    protected boolean zzaW() {
        boolean bl = true;
        if (!zzp.zzbx().zza(this.zzoZ.context.getPackageManager(), this.zzoZ.context.getPackageName(), "android.permission.INTERNET") || !zzp.zzbx().zzJ(this.zzoZ.context)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzaX() {
        this.zzpb.zze(this.zzoZ.zzqW);
        this.zzpe = false;
        this.zzaS();
        this.zzoZ.zzqY.zzgF();
    }

    @Override
    public void zzaY() {
        this.zzpe = true;
        this.zzaU();
    }

    @Override
    public void zzaZ() {
        this.onAdClicked();
    }

    @Override
    public void zzba() {
        this.zzaX();
    }

    @Override
    public void zzbb() {
        this.zzaQ();
    }

    @Override
    public void zzbc() {
        this.zzaY();
    }

    @Override
    public void zzbd() {
        if (this.zzoZ.zzqW != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Mediation adapter " + this.zzoZ.zzqW.zzBr + " refreshed, but mediation adapters should never refresh.");
        }
        this.zza(this.zzoZ.zzqW, true);
        this.zzaV();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle) {
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzoZ.context.getApplicationInfo();
        try {
            packageManager = this.zzoZ.context.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzoZ.context.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzoZ.zzqS != null && this.zzoZ.zzqS.getParent() != null) {
            object = new int[2];
            this.zzoZ.zzqS.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzoZ.zzqS.getWidth();
            int n3 = this.zzoZ.zzqS.getHeight();
            int n4 = 0;
            if (this.zzoZ.zzqS.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzp.zzbA().zzgK();
        this.zzoZ.zzqY = new zzif((String)object, this.zzoZ.zzqP);
        this.zzoZ.zzqY.zzj(adRequestParcel);
        String string2 = zzp.zzbx().zza(this.zzoZ.context, (View)this.zzoZ.zzqS, this.zzoZ.zzqV);
        long l = 0L;
        if (this.zzoZ.zzrc != null) {
            try {
                l = this.zzoZ.zzrc.getValue();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzp.zzbA().zza(this.zzoZ.context, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzoZ.zzri.size(); n += 1) {
            arrayList.add((String)this.zzoZ.zzri.keyAt(n));
        }
        n = this.zzoZ.zzrd != null ? 1 : 0;
        boolean bl = this.zzoZ.zzre != null && zzp.zzbA().zzgT();
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzoZ.zzqV, this.zzoZ.zzqP, applicationInfo, packageInfo, (String)object, zzp.zzbA().getSessionId(), this.zzoZ.zzqR, bundle3, this.zzoZ.zzrl, arrayList, bundle, zzp.zzbA().zzgO(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string2, l, string3, zzbz.zzdl(), this.zzoZ.zzqO, this.zzoZ.zzrj, new CapabilityParcel(n != 0, bl), this.zzoZ.zzbU());
    }

    @Override
    public void zza(zzgc zzgc2) {
        zzx.zzcx((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzoZ.zzrd = zzgc2;
    }

    @Override
    public void zza(zzgg zzgg2, String string2) {
        zzx.zzcx((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzoZ.zzrm = new zzk(string2);
        this.zzoZ.zzre = zzgg2;
        if (!zzp.zzbA().zzgN() && zzgg2 != null) {
            new zzc(this.zzoZ.context, this.zzoZ.zzre, this.zzoZ.zzrm).zzgX();
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string2, arrayList, this.zzoZ.context, this.zzoZ.zzqR.afmaVersion);
        if (this.zzoZ.zzrd == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzl.zzcN().zzT(this.zzoZ.context)) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzoZ.zzre == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzoZ.zzrm == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzoZ.zzrq) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzoZ.zzrq = true;
            try {
                if (!this.zzoZ.zzre.isValidPurchase(string2)) {
                    this.zzoZ.zzrq = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not start In-App purchase.");
                this.zzoZ.zzrq = false;
                return;
            }
            zzp.zzbH().zza(this.zzoZ.context, this.zzoZ.zzqR.zzLH, new GInAppPurchaseManagerInfoParcel(this.zzoZ.context, this.zzoZ.zzrm, zzd2, this));
        } else {
            try {
                this.zzoZ.zzrd.zza(zzd2);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzoZ.zzre != null) {
                this.zzoZ.zzre.zza(new com.google.android.gms.ads.internal.purchase.zzg(this.zzoZ.context, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Fail to invoke PlayStorePurchaseListener.");
        }
        zzip.zzKO.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzp.zzbH().zzd(intent);
                zzp.zzbH();
                if (n == 0 && zzb.this.zzoZ.zzqW != null && zzb.this.zzoZ.zzqW.zzDC != null && zzb.this.zzoZ.zzqW.zzDC.zzhA() != null) {
                    zzb.this.zzoZ.zzqW.zzDC.zzhA().close();
                }
                zzb.this.zzoZ.zzrq = false;
            }
        }, 500L);
    }

    protected void zza(zzie zzie2, boolean bl) {
        if (zzie2 == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzie2);
        if (zzie2.zzJF != null && zzie2.zzJF.zzAR != null) {
            zzp.zzbK().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, zzie2, this.zzoZ.zzqP, bl, zzie2.zzJF.zzAR);
        }
        if (zzie2.zzBp != null && zzie2.zzBp.zzAK != null) {
            zzp.zzbK().zza(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, zzie2, this.zzoZ.zzqP, bl, zzie2.zzBp.zzAK);
        }
    }

    @Override
    public String getMediationAdapterClassName() {
        if (this.zzoZ.zzqW == null) {
            return null;
        }
        return this.zzoZ.zzqW.zzBr;
    }

    @Override
    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }
}

