/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.Window;
import com.google.android.gms.ads.internal.InterstitialAdParameterParcel;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzdp;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzjn;

@zzha
public class zzk
extends zzc
implements zzdp {
    protected transient boolean zzpR = false;
    private boolean zzpS;
    private float zzpT;
    private String zzpU = "background" + this.hashCode() + "." + "png";

    public zzk(Context context, AdSizeParcel adSizeParcel, String string2, zzew zzew2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        super(context, adSizeParcel, string2, zzew2, versionInfoParcel, zzd2);
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzch zzch2) {
        if (this.zzoZ.zzqW != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("An interstitial is already loading. Aborting.");
            return false;
        }
        return super.zza(adRequestParcel, zzch2);
    }

    @Override
    protected zzjn zza(zzie.zza zza2, zze zze2) {
        zzjn zzjn2 = zzp.zzby().zza(this.zzoZ.context, this.zzoZ.zzqV, false, false, this.zzoZ.zzqQ, this.zzoZ.zzqR, this.zzoU, this.zzpc);
        zzjn2.zzhC().zzb(this, null, this, this, zzbz.zzwa.get(), this, this, zze2, null);
        zzjn2.zzaJ(zza2.zzJK.zzGF);
        return zzjn2;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzie zzie2, boolean bl) {
        if (this.zzoZ.zzbQ() && zzie2.zzDC != null) {
            zzp.zzbz().zzf(zzie2.zzDC);
        }
        return this.zzoY.zzbr();
    }

    @Override
    public boolean zza(zzie zzie2, zzie zzie3) {
        if (!super.zza(zzie2, zzie3)) {
            return false;
        }
        if (!this.zzoZ.zzbQ() && this.zzoZ.zzro != null && zzie3.zzJE != null) {
            this.zzpb.zza(this.zzoZ.zzqV, zzie3, this.zzoZ.zzro);
        }
        return true;
    }

    @Override
    public void zzaY() {
        this.recordImpression();
        super.zzaY();
    }

    @Override
    protected boolean zzaS() {
        this.zzbo();
        return super.zzaS();
    }

    @Override
    public void zzd(boolean bl) {
        this.zzoZ.zzqa = bl;
    }

    @Override
    public void zza(boolean bl, float f) {
        this.zzpS = bl;
        this.zzpT = f;
    }

    @Override
    public void showInterstitial() {
        Object object;
        String string2;
        zzx.zzcx((String)"showInterstitial must be called on the main UI thread.");
        if (this.zzoZ.zzqW == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("The interstitial has not loaded.");
            return;
        }
        if (zzbz.zzws.get().booleanValue()) {
            String string3 = string2 = this.zzoZ.context.getApplicationContext() != null ? this.zzoZ.context.getApplicationContext().getPackageName() : this.zzoZ.context.getPackageName();
            if (!this.zzpR) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("It is not recommended to show an interstitial before onAdLoaded completes.");
                object = new Bundle();
                object.putString("appid", string2);
                object.putString("action", "show_interstitial_before_load_finish");
                this.zzb((Bundle)object);
            }
            if (!zzp.zzbx().zzP(this.zzoZ.context)) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("It is not recommended to show an interstitial when app is not in foreground.");
                object = new Bundle();
                object.putString("appid", string2);
                object.putString("action", "show_interstitial_app_not_in_foreground");
                this.zzb((Bundle)object);
            }
        }
        if (this.zzoZ.zzbR()) {
            return;
        }
        if (this.zzoZ.zzqW.zzGN) {
            try {
                this.zzoZ.zzqW.zzBq.showInterstitial();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not show interstitial.", remoteException);
                this.zzbo();
            }
        } else {
            if (this.zzoZ.zzqW.zzDC == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("The interstitial failed to load.");
                return;
            }
            if (this.zzoZ.zzqW.zzDC.zzhG()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaH("The interstitial is already showing.");
                return;
            }
            this.zzoZ.zzqW.zzDC.zzD(true);
            if (this.zzoZ.zzqW.zzJE != null) {
                this.zzpb.zza(this.zzoZ.zzqV, this.zzoZ.zzqW);
            }
            Object object2 = string2 = this.zzoZ.zzqa ? zzp.zzbx().zzQ(this.zzoZ.context) : null;
            if (zzbz.zzwI.get().booleanValue() && string2 != null) {
                new zzb((Bitmap)string2, this.zzpU).zzgX();
            } else {
                object = new InterstitialAdParameterParcel(this.zzoZ.zzqa, this.zzbn(), null, false, 0.0f);
                int n = this.zzoZ.zzqW.zzDC.getRequestedOrientation();
                if (n == -1) {
                    n = this.zzoZ.zzqW.orientation;
                }
                AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(this, this, this, this.zzoZ.zzqW.zzDC, n, this.zzoZ.zzqR, this.zzoZ.zzqW.zzGS, (InterstitialAdParameterParcel)object);
                zzp.zzbv().zza(this.zzoZ.context, adOverlayInfoParcel);
            }
        }
    }

    private void zzb(Bundle bundle) {
        zzp.zzbx().zzb(this.zzoZ.context, this.zzoZ.zzqR.afmaVersion, "gmob-apps", bundle, false);
    }

    protected boolean zzbn() {
        if (!(this.zzoZ.context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)this.zzoZ.context).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    @Override
    protected boolean zzaV() {
        if (super.zzaV()) {
            this.zzpR = true;
            return true;
        }
        return false;
    }

    public void zzbo() {
        new zza(this.zzpU).zzgX();
        if (this.zzoZ.zzbQ()) {
            this.zzoZ.zzbN();
            this.zzoZ.zzqW = null;
            this.zzoZ.zzqa = false;
            this.zzpR = false;
        }
    }

    @zzha
    private class zza
    extends zzil {
        private final String zzpV;

        public zza(String string2) {
            this.zzpV = string2;
        }

        @Override
        public void zzbp() {
            zzp.zzbx().zzf(zzk.this.zzoZ.context, this.zzpV);
        }

        @Override
        public void onStop() {
        }
    }

    @zzha
    private class zzb
    extends zzil {
        private final Bitmap zzpX;
        private final String zzpV;

        public zzb(Bitmap bitmap, String string2) {
            this.zzpX = bitmap;
            this.zzpV = string2;
        }

        @Override
        public void zzbp() {
            boolean bl = zzk.this.zzoZ.zzqa ? zzp.zzbx().zza(zzk.this.zzoZ.context, this.zzpX, this.zzpV) : false;
            InterstitialAdParameterParcel interstitialAdParameterParcel = new InterstitialAdParameterParcel(zzk.this.zzoZ.zzqa, zzk.this.zzbn(), bl ? this.zzpV : null, zzk.this.zzpS, zzk.this.zzpT);
            int n = zzk.this.zzoZ.zzqW.zzDC.getRequestedOrientation();
            if (n == -1) {
                n = zzk.this.zzoZ.zzqW.orientation;
            }
            final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(zzk.this, zzk.this, zzk.this, zzk.this.zzoZ.zzqW.zzDC, n, zzk.this.zzoZ.zzqR, zzk.this.zzoZ.zzqW.zzGS, interstitialAdParameterParcel);
            zzip.zzKO.post(new Runnable(){

                @Override
                public void run() {
                    zzp.zzbv().zza(zzk.this.zzoZ.context, adOverlayInfoParcel);
                }
            });
        }

        @Override
        public void onStop() {
        }
    }
}

