/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzei;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjn;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzaz
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzpK = new Object();
    private final WeakReference<zzie> zzrK;
    private WeakReference<ViewTreeObserver> zzrL;
    private final zzbh zzrM;
    private final zzax zzrN;
    private final Context zzrI;
    private final zzei zzrO;
    private final zzei.zzd zzrP;
    private boolean zzrQ;
    private final WindowManager zzrR;
    private final PowerManager zzrS;
    private final KeyguardManager zzrT;
    private zzba zzrU;
    private boolean zzrV;
    private boolean zzqq = false;
    private boolean zzrW = false;
    private boolean zzrX;
    private boolean zzrY;
    BroadcastReceiver zzrZ;
    private final HashSet<zzaw> zzsa = new HashSet();
    private zzix zzru;
    private final zzdl zzsb = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            zzaz.this.zza(zzjn2.getView(), map);
        }
    };
    private final zzdl zzsc = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Received request to untrack: " + zzaz.this.zzrN.zzca());
            zzaz.this.destroy();
        }
    };
    private final zzdl zzsd = new zzdl(){

        @Override
        public void zza(zzjn zzjn2, Map<String, String> map) {
            if (!zzaz.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzaz.this.zzg(bl);
        }
    };

    public zzaz(Context context, AdSizeParcel adSizeParcel, zzie zzie2, VersionInfoParcel versionInfoParcel, zzbh zzbh2, zzei zzei2) {
        zzbh zzbh3 = zzbh2.zzcp();
        this.zzrO = zzei2;
        this.zzrK = new WeakReference<zzie>(zzie2);
        this.zzrM = zzbh2;
        this.zzrL = new WeakReference<Object>(null);
        this.zzrX = true;
        this.zzru = new zzix(200L);
        this.zzrN = new zzax(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zztV, zzie2.zzJE, zzie2.zzcb(), adSizeParcel.zztY);
        this.zzrP = this.zzrO.zzei();
        this.zzrR = (WindowManager)context.getSystemService("window");
        this.zzrS = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzrT = (KeyguardManager)context.getSystemService("keyguard");
        this.zzrI = context;
        try {
            final JSONObject jSONObject = this.zzd(zzbh3.zzcn());
            this.zzrP.zza(new zzjg.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzaz.this.zza(jSONObject);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzjg.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (JSONException jSONException) {
        }
        catch (RuntimeException runtimeException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Failure while processing active view data.", runtimeException);
        }
        this.zzrP.zza(new zzjg.zzc<zzbe>(){

            public void zzb(zzbe zzbe2) {
                zzaz.this.zzrQ = true;
                zzaz.this.zza(zzbe2);
                zzaz.this.zzcd();
                zzaz.this.zzh(false);
            }

            @Override
            public /* synthetic */ void zzc(Object object) {
                this.zzb((zzbe)object);
            }
        }, new zzjg.zza(){

            @Override
            public void run() {
                zzaz.this.destroy();
            }
        });
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("Tracking ad unit: " + this.zzrN.zzca());
    }

    public void zza(zzaw zzaw2) {
        this.zzsa.add(zzaw2);
    }

    protected void zzg(boolean bl) {
        for (zzaw zzaw2 : this.zzsa) {
            zzaw2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzcd() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzrZ != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzrZ = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzaz.this.zzh(false);
                }
            };
            this.zzrI.registerReceiver(this.zzrZ, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzce() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzrZ != null) {
                try {
                    this.zzrI.unregisterReceiver(this.zzrZ);
                }
                catch (IllegalStateException illegalStateException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Failed trying to unregister the receiver", illegalStateException);
                }
                catch (Exception exception) {
                    zzp.zzbA().zzb(exception, true);
                }
                this.zzrZ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzcj();
            this.zzce();
            this.zzrX = false;
            this.zzcg();
            this.zzrP.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcf() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzrX) {
                this.zzrY = true;
                try {
                    JSONObject jSONObject = this.zzcm();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("JSON failure while processing active view data.", jSONException);
                }
                catch (RuntimeException runtimeException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Failure while processing active view data.", runtimeException);
                }
                com.google.android.gms.ads.internal.util.client.zzb.zzaF("Untracking ad unit: " + this.zzrN.zzca());
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(boolean bl) {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.zzrQ || !this.zzrX) {
                return;
            }
            if (bl && !this.zzru.tryAcquire()) {
                return;
            }
            boolean bl2 = this.zzrM.zzco();
            if (bl2) {
                this.zzcf();
                return;
            }
            try {
                View view = this.zzrM.zzcn();
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                com.google.android.gms.ads.internal.util.client.zzb.zza("Active view update failed.", throwable);
            }
            this.zzci();
            this.zzcg();
        }
    }

    protected void zzcg() {
        if (this.zzrU != null) {
            this.zzrU.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzch() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzrX;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzci() {
        zzbh zzbh2 = this.zzrM.zzcp();
        View view = zzbh2.zzcn();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzrL.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzcj();
        if (!this.zzrV || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzrV = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzrL = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzrN.zzca());
    }

    protected void zza(zzbe zzbe2) {
        zzbe2.zza("/updateActiveView", this.zzsb);
        zzbe2.zza("/untrackActiveViewUnit", this.zzsc);
        zzbe2.zza("/visibilityChanged", this.zzsd);
    }

    protected void zzcj() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzrL.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzck() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzrN.zzbY()).put("activeViewJSON", (Object)this.zzrN.zzbZ()).put("timestamp", zzp.zzbB().elapsedRealtime()).put("adFormat", (Object)this.zzrN.zzbX()).put("hashCode", (Object)this.zzrN.zzca()).put("isMraid", this.zzrN.zzcb()).put("isStopped", this.zzrW).put("isPaused", this.zzqq).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzrN.zzcc());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            final JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzrP.zza(new zzjg.zzc<zzbe>(){

                public void zzb(zzbe zzbe2) {
                    zzbe2.zza("AFMA_updateActiveView", jSONObject2);
                }

                @Override
                public /* synthetic */ void zzc(Object object) {
                    this.zzb((zzbe)object);
                }
            }, new zzjg.zzb());
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Skipping active view message.", throwable);
        }
    }

    protected JSONObject zzcl() throws JSONException {
        return this.zzck().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(View view) throws JSONException {
        if (view == null) {
            return this.zzcl();
        }
        boolean bl = zzp.zzbz().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.client.zzb.zzb("Failure getting view location.", exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzrR.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzrR.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzck();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", this.zze(view));
        return jSONObject;
    }

    protected boolean zze(View view) {
        return view.getVisibility() == 0 && view.isShown() && this.isScreenOn() && (!this.zzrT.inKeyguardRestrictedInputMode() || zzp.zzbx().zzgY());
    }

    boolean isScreenOn() {
        return this.zzrS.isScreenOn();
    }

    protected JSONObject zzcm() throws JSONException {
        JSONObject jSONObject = this.zzck();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzh(true);
    }

    public void onGlobalLayout() {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzba zzba2) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzrU = zzba2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzrW = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzqq = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzqq = false;
            this.zzh(false);
        }
    }

    public static class zzb
    implements zzbh {
        private zzh zzsi;

        public zzb(zzh zzh2) {
            this.zzsi = zzh2;
        }

        @Override
        public View zzcn() {
            return this.zzsi.zzdL();
        }

        @Override
        public boolean zzco() {
            return this.zzsi == null;
        }

        @Override
        public zzbh zzcp() {
            return this;
        }
    }

    public static class zza
    implements zzbh {
        private WeakReference<zzh> zzsh;

        public zza(zzh zzh2) {
            this.zzsh = new WeakReference<zzh>(zzh2);
        }

        @Override
        public View zzcn() {
            zzh zzh2 = (zzh)this.zzsh.get();
            return zzh2 != null ? zzh2.zzdL() : null;
        }

        @Override
        public boolean zzco() {
            return this.zzsh.get() == null;
        }

        @Override
        public zzbh zzcp() {
            return new zzb((zzh)this.zzsh.get());
        }
    }

    public static class zzc
    implements zzbh {
        private final View mView;
        private final zzie zzsj;

        public zzc(View view, zzie zzie2) {
            this.mView = view;
            this.zzsj = zzie2;
        }

        @Override
        public View zzcn() {
            return this.mView;
        }

        @Override
        public boolean zzco() {
            return this.zzsj == null || this.mView == null;
        }

        @Override
        public zzbh zzcp() {
            return this;
        }
    }

    public static class zzd
    implements zzbh {
        private final WeakReference<View> zzsk;
        private final WeakReference<zzie> zzsl;

        public zzd(View view, zzie zzie2) {
            this.zzsk = new WeakReference<View>(view);
            this.zzsl = new WeakReference<zzie>(zzie2);
        }

        @Override
        public View zzcn() {
            return (View)this.zzsk.get();
        }

        @Override
        public boolean zzco() {
            return this.zzsk.get() == null || this.zzsl.get() == null;
        }

        @Override
        public zzbh zzcp() {
            return new zzc((View)this.zzsk.get(), (zzie)this.zzsl.get());
        }
    }
}

