/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbj;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zznx;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzha
public class zzbl
extends Thread {
    private boolean mStarted = false;
    private boolean zzsO = false;
    private boolean zzam = false;
    private final Object zzpK;
    private final zzbk zzsP;
    private final zzbj zzsQ;
    private final zzgz zzsR;
    private final int zzsS;
    private final int zzsC;
    private final int zzsT;
    private final int zzsE;
    private final int zzsU;

    public zzbl(zzbk zzbk2, zzbj zzbj2, zzgz zzgz2) {
        this.zzsP = zzbk2;
        this.zzsQ = zzbj2;
        this.zzsR = zzgz2;
        this.zzpK = new Object();
        this.zzsC = zzbz.zzvP.get();
        this.zzsT = zzbz.zzvQ.get();
        this.zzsE = zzbz.zzvR.get();
        this.zzsU = zzbz.zzvS.get();
        this.zzsS = zzbz.zzvT.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcB() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.mStarted) {
                zzb.zzaF("Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.zzam) {
            Object object;
            try {
                if (this.zzcC()) {
                    object = this.zzsP.getActivity();
                    if (object == null) {
                        zzb.zzaF("ContentFetchThread: no activity");
                        continue;
                    }
                    this.zza((Activity)object);
                } else {
                    zzb.zzaF("ContentFetchTask: sleeping");
                    this.zzcE();
                }
                Thread.sleep(this.zzsS * 1000);
            }
            catch (Throwable throwable) {
                zzb.zzb("Error in ContentFetchTask", throwable);
                this.zzsR.zza(throwable, true);
            }
            object = this.zzpK;
            synchronized (object) {
                while (this.zzsO) {
                    try {
                        zzb.zzaF("ContentFetchTask: waiting");
                        this.zzpK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzf(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzbl.this.zzg(view);
            }
        });
        return true;
    }

    void zzg(View view) {
        try {
            zzbi zzbi2 = new zzbi(this.zzsC, this.zzsT, this.zzsE, this.zzsU);
            zza zza2 = this.zza(view, zzbi2);
            zzbi2.zzcy();
            if (zza2.zztb == 0 && zza2.zztc == 0) {
                return;
            }
            if (zza2.zztc == 0 && zzbi2.zzcz() == 0) {
                return;
            }
            if (zza2.zztc == 0 && this.zzsQ.zza(zzbi2)) {
                return;
            }
            this.zzsQ.zzc(zzbi2);
        }
        catch (Exception exception) {
            zzb.zzb("Exception in fetchContentOnUIThread", exception);
            this.zzsR.zza(exception, true);
        }
    }

    boolean zzs(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzcC() {
        try {
            Context context = this.zzsP.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzs(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zzf(view);
    }

    zza zza(View view, zzbi zzbi2) {
        if (view == null) {
            return new zza(0, 0);
        }
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzbi2.zzw(string2);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzjn)) {
            zzbi2.zzcx();
            if (this.zza((WebView)view, zzbi2)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzbi2);
                n += zza2.zztb;
                n2 += zza2.zztc;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    boolean zza(final WebView webView, final zzbi zzbi2) {
        if (!zznx.zzrU()) {
            return false;
        }
        zzbi2.zzcx();
        webView.post(new Runnable(){
            ValueCallback<String> zzsX = new ValueCallback<String>(){

                public void zzy(String string2) {
                    zzbl.this.zza(zzbi2, webView, string2);
                }

                public /* synthetic */ void onReceiveValue(Object x0) {
                    this.zzy((String)x0);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzsX);
                    }
                    catch (Throwable throwable) {
                        this.zzsX.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzbi zzbi2, WebView webView, String string2) {
        zzbi2.zzcw();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    zzbi2.zzv(webView.getTitle() + "\n" + string3);
                } else {
                    zzbi2.zzv(string3);
                }
            }
            if (zzbi2.zzct()) {
                this.zzsQ.zzb(zzbi2);
            }
        }
        catch (JSONException jSONException) {
            zzb.zzaF("Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzb.zza("Failed to get webview content.", throwable);
            this.zzsR.zza(throwable, true);
        }
    }

    public zzbi zzcD() {
        return this.zzsQ.zzcA();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzsO = false;
            this.zzpK.notifyAll();
            zzb.zzaF("ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcE() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzsO = true;
            zzb.zzaF("ContentFetchThread: paused, mPause = " + this.zzsO);
        }
    }

    public boolean zzcF() {
        return this.zzsO;
    }

    @zzha
    class zza {
        final int zztb;
        final int zztc;

        zza(int n, int n2) {
            this.zztb = n;
            this.zztc = n2;
        }
    }
}

