/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjn;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzha
public final class zzdt
implements zzdl {
    private final Map<zzjn, Integer> zzzi = new WeakHashMap<zzjn, Integer>();

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzl.zzcN().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaH("Could not parse " + string2 + " in a video GMSG: " + string3);
            }
        }
        return n2;
    }

    @Override
    public void zza(zzjn zzjn2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzb.zzaH("Action missing from video GMSG.");
            return;
        }
        if (zzb.zzQ(3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            zzb.zzaF("Video GMSG: " + string2 + " " + object.toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzb.zzaH("Color parameter missing from color video GMSG.");
                return;
            }
            try {
                zzk zzk2;
                int n = Color.parseColor((String)object);
                zzjm zzjm2 = zzjn2.zzhJ();
                if (zzjm2 != null && (zzk2 = zzjm2.zzhv()) != null) {
                    zzk2.setBackgroundColor(n);
                    return;
                }
                this.zzzi.put(zzjn2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzb.zzaH("Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzjn2.zzhJ();
        if (object == null) {
            zzb.zzaH("Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzjn2.getContext();
            int n2 = zzdt.zza(context, map, "x", 0);
            int n3 = zzdt.zza(context, map, "y", 0);
            int n4 = zzdt.zza(context, map, "w", -1);
            int n5 = zzdt.zza(context, map, "h", -1);
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (bl && ((zzjm)object).zzhv() == null) {
                ((zzjm)object).zza(n2, n3, n4, n5, n);
                if (this.zzzi.containsKey(zzjn2)) {
                    int n6 = this.zzzi.get(zzjn2);
                    zzk zzk3 = ((zzjm)object).zzhv();
                    zzk3.setBackgroundColor(n6);
                    zzk3.zzft();
                }
            } else {
                ((zzjm)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzk zzk4 = ((zzjm)object).zzhv();
            if (zzk4 == null) {
                zzk.zzd(zzjn2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzjn2.getContext();
                int n = zzdt.zza(context, map, "x", 0);
                int n7 = zzdt.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n7, (int)0);
                zzk4.zzd(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string3 = map.get("time");
                if (string3 == null) {
                    zzb.zzaH("Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string3);
                    int n = (int)(f * 1000.0f);
                    zzk4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzaH("Could not parse time parameter from currentTime video GMSG: " + string3);
                }
            } else if ("hide".equals(string2)) {
                zzk4.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk4.zzfs();
            } else if ("mimetype".equals(string2)) {
                zzk4.setMimeType(map.get("mimetype"));
            } else if ("muted".equals(string2)) {
                boolean bl3 = Boolean.parseBoolean(map.get("muted"));
                if (bl3) {
                    zzk4.zzeU();
                } else {
                    zzk4.zzeV();
                }
            } else if ("pause".equals(string2)) {
                zzk4.pause();
            } else if ("play".equals(string2)) {
                zzk4.play();
            } else if ("show".equals(string2)) {
                zzk4.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk4.zzao(map.get("src"));
            } else if ("volume".equals(string2)) {
                String string4 = map.get("volume");
                if (string4 == null) {
                    zzb.zzaH("Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzk4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    zzb.zzaH("Could not parse volume parameter from volume video GMSG: " + string4);
                }
            } else if ("watermark".equals(string2)) {
                zzk4.zzft();
            } else {
                zzb.zzaH("Unknown video action: " + string2);
            }
        }
    }
}

