/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.MutableContextWrapper;
import android.content.SharedPreferences;
import android.util.Base64;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzha;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

@zzha
public class zzed {
    private final Map<zzee, zzef> zzzS = new HashMap<zzee, zzef>();
    private final LinkedList<zzee> zzzT = new LinkedList();
    private zzea zzzU;

    void zza(zzea zzea2) {
        if (this.zzzU == null) {
            this.zzzU = zzea2;
            this.restore();
        }
    }

    zzef.zza zza(AdRequestParcel adRequestParcel, String string2) {
        Object object;
        zzee zzee2 = new zzee(adRequestParcel, string2);
        zzef zzef2 = this.zzzS.get(zzee2);
        if (zzef2 == null) {
            zzed.zza("Interstitial pool created at %s.", zzee2);
            zzef2 = new zzef(adRequestParcel, string2);
            this.zzzS.put(zzee2, zzef2);
        }
        this.zzzT.remove(zzee2);
        this.zzzT.add(zzee2);
        zzee2.zzdZ();
        while (this.zzzT.size() > zzbz.zzwl.get()) {
            object = this.zzzT.remove();
            zzef zzef3 = this.zzzS.get(object);
            zzed.zza("Evicting interstitial queue for %s.", (zzee)object);
            while (zzef3.size() > 0) {
                zzef.zza zza2 = zzef3.zzec();
                zza2.zzzX.zzbo();
            }
            this.zzzS.remove(object);
        }
        while (zzef2.size() > 0) {
            long l;
            object = zzef2.zzec();
            if (((zzef.zza)object).zzAa && (l = zzp.zzbB().currentTimeMillis() - ((zzef.zza)object).zzzZ) > 1000L * (long)zzbz.zzwn.get().intValue()) {
                zzed.zza("Expired interstitial at %s.", zzee2);
                continue;
            }
            zzed.zza("Pooled interstitial returned at %s.", zzee2);
            return object;
        }
        return null;
    }

    void zzdX() {
        if (this.zzzU == null) {
            return;
        }
        for (Map.Entry<zzee, zzef> entry : this.zzzS.entrySet()) {
            zzee zzee2 = entry.getKey();
            zzef zzef2 = entry.getValue();
            while (zzef2.size() < zzbz.zzwm.get()) {
                zzed.zza("Pooling one interstitial for %s.", zzee2);
                zzef2.zzb(this.zzzU);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzzU == null) {
            return;
        }
        MutableContextWrapper mutableContextWrapper = this.zzzU.zzdW();
        SharedPreferences sharedPreferences = mutableContextWrapper.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzee, zzef> entry : this.zzzS.entrySet()) {
            zzee zzee2 = entry.getKey();
            if (!zzee2.zzea()) continue;
            zzef zzef2 = entry.getValue();
            zzeh zzeh2 = new zzeh(zzef2.zzeb(), zzef2.getAdUnitId());
            String string2 = zzeh2.zzef();
            String string3 = zzee2.toString();
            editor.putString(string3, string2);
            zzed.zza("Saved interstitial queue for %s.", zzee2);
        }
        editor.putString("PoolKeys", this.zzdY());
        editor.commit();
    }

    void restore() {
        zzee zzee2;
        if (this.zzzU == null) {
            return;
        }
        MutableContextWrapper mutableContextWrapper = this.zzzU.zzdW();
        SharedPreferences sharedPreferences = mutableContextWrapper.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        HashMap<String, zzee> hashMap = new HashMap<String, zzee>();
        String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2 = stringArray.next();
            try {
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzeh object = new zzeh(string3);
                zzee2 = new zzee(object.zzqo, object.zzpH);
                if (this.zzzS.containsKey(zzee2)) continue;
                zzef zzef2 = new zzef(object.zzqo, object.zzpH);
                this.zzzS.put(zzee2, zzef2);
                hashMap.put(zzee2.toString(), zzee2);
                zzed.zza("Restored interstitial queue for %s.", zzee2);
            }
            catch (IOException | ClassCastException exception) {
                zzb.zzd("Malformed preferences value for InterstitialAdPool.", exception);
            }
        }
        for (String string2 : stringArray = this.zzad(sharedPreferences.getString("PoolKeys", ""))) {
            zzee2 = (zzee)hashMap.get(string2);
            if (!this.zzzS.containsKey(zzee2)) continue;
            this.zzzT.add(zzee2);
        }
    }

    void flush() {
        while (this.zzzT.size() > 0) {
            zzee zzee2 = this.zzzT.remove();
            zzef zzef2 = this.zzzS.get(zzee2);
            zzed.zza("Flushing interstitial queue for %s.", zzee2);
            while (zzef2.size() > 0) {
                zzef.zza zza2 = zzef2.zzec();
                zza2.zzzX.zzbo();
            }
            this.zzzS.remove(zzee2);
        }
    }

    private String zzdY() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzzT.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzee)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzad(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static void zza(String string2, zzee zzee2) {
        if (zzb.zzQ(2)) {
            zzb.v(String.format(string2, zzee2));
        }
    }
}

