/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zznm;
import java.util.Map;
import java.util.Set;

@zzha
public class zzfm
extends zzfr {
    static final Set<String> zzCa = zznm.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzCb = "top-right";
    private boolean zzCc = true;
    private int zzCd = 0;
    private int zzCe = 0;
    private int zzow = -1;
    private int zzCf = 0;
    private int zzCg = 0;
    private int zzov = -1;
    private final Object zzpK = new Object();
    private final zzjn zzps;
    private final Activity zzCh;
    private AdSizeParcel zzBh;
    private ImageView zzCi;
    private LinearLayout zzCj;
    private zzfs zzCk;
    private PopupWindow zzCl;
    private RelativeLayout zzCm;
    private ViewGroup zzCn;

    public zzfm(zzjn zzjn2, zzfs zzfs2) {
        super(zzjn2, "resize");
        this.zzps = zzjn2;
        this.zzCh = zzjn2.zzhx();
        this.zzCk = zzfs2;
    }

    private void zzf(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzov = zzp.zzbx().zzaA(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzow = zzp.zzbx().zzaA(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzCf = zzp.zzbx().zzaA(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzCg = zzp.zzbx().zzaA(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzCc = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzCb = string2;
        }
    }

    boolean zzeA() {
        return this.zzov > -1 && this.zzow > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(Map<String, String> map) {
        Object object = this.zzpK;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzCh == null) {
                this.zzal("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzps.zzaP() == null) {
                this.zzal("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzps.zzaP().zztW) {
                this.zzal("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzps.zzhG()) {
                this.zzal("Cannot resize an expanded banner.");
                return;
            }
            this.zzf(map);
            if (!this.zzeA()) {
                this.zzal("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzCh.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzal("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzeB();
            if (nArray == null) {
                this.zzal("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzl.zzcN().zzb((Context)this.zzCh, this.zzov);
            int n2 = zzl.zzcN().zzb((Context)this.zzCh, this.zzow);
            ViewParent viewParent = this.zzps.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzps.getView());
                if (this.zzCl == null) {
                    this.zzCn = (ViewGroup)viewParent;
                    bitmap = zzp.zzbx().zzl(this.zzps.getView());
                    this.zzCi = new ImageView((Context)this.zzCh);
                    this.zzCi.setImageBitmap(bitmap);
                    this.zzBh = this.zzps.zzaP();
                    this.zzCn.addView((View)this.zzCi);
                } else {
                    this.zzCl.dismiss();
                }
            } else {
                this.zzal("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzCm = new RelativeLayout((Context)this.zzCh);
            this.zzCm.setBackgroundColor(0);
            this.zzCm.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzCl = zzp.zzbx().zza((View)this.zzCm, n, n2, false);
            this.zzCl.setOutsideTouchable(true);
            this.zzCl.setTouchable(true);
            this.zzCl.setClippingEnabled(!this.zzCc);
            this.zzCm.addView(this.zzps.getView(), -1, -1);
            this.zzCj = new LinearLayout((Context)this.zzCh);
            bitmap = new RelativeLayout.LayoutParams(zzl.zzcN().zzb((Context)this.zzCh, 50), zzl.zzcN().zzb((Context)this.zzCh, 50));
            switch (this.zzCb) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzCj.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzfm.this.zzp(true);
                }
            });
            this.zzCj.setContentDescription((CharSequence)"Close button");
            this.zzCm.addView((View)this.zzCj, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzCl.showAtLocation(window.getDecorView(), 0, zzl.zzcN().zzb((Context)this.zzCh, nArray[0]), zzl.zzcN().zzb((Context)this.zzCh, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                this.zzal("Cannot show popup window: " + runtimeException.getMessage());
                this.zzCm.removeView(this.zzps.getView());
                if (this.zzCn != null) {
                    this.zzCn.removeView((View)this.zzCi);
                    this.zzCn.addView(this.zzps.getView());
                    this.zzps.zza(this.zzBh);
                }
                return;
            }
            this.zzc(nArray[0], nArray[1]);
            this.zzps.zza(new AdSizeParcel((Context)this.zzCh, new AdSize(this.zzov, this.zzow)));
            this.zzd(nArray[0], nArray[1]);
            this.zzan("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzp(boolean bl) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzCl != null) {
                this.zzCl.dismiss();
                this.zzCm.removeView(this.zzps.getView());
                if (this.zzCn != null) {
                    this.zzCn.removeView((View)this.zzCi);
                    this.zzCn.addView(this.zzps.getView());
                    this.zzps.zza(this.zzBh);
                }
                if (bl) {
                    this.zzan("default");
                    if (this.zzCk != null) {
                        this.zzCk.zzbe();
                    }
                }
                this.zzCl = null;
                this.zzCm = null;
                this.zzCn = null;
                this.zzCj = null;
            }
        }
    }

    private int[] zzeB() {
        if (!this.zzeD()) {
            return null;
        }
        if (this.zzCc) {
            return new int[]{this.zzCd + this.zzCf, this.zzCe + this.zzCg};
        }
        int[] nArray = zzp.zzbx().zzh(this.zzCh);
        int[] nArray2 = zzp.zzbx().zzj(this.zzCh);
        int n = nArray[0];
        int n2 = this.zzCd + this.zzCf;
        int n3 = this.zzCe + this.zzCg;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzov > n) {
            n2 = n - this.zzov;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzow > nArray2[1]) {
            n3 = nArray2[1] - this.zzow;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzCd = n;
            this.zzCe = n2;
            if (this.zzCl != null && bl) {
                int[] nArray = this.zzeB();
                if (nArray != null) {
                    this.zzCl.update(zzl.zzcN().zzb((Context)this.zzCh, nArray[0]), zzl.zzcN().zzb((Context)this.zzCh, nArray[1]), this.zzCl.getWidth(), this.zzCl.getHeight());
                    this.zzd(nArray[0], nArray[1]);
                } else {
                    this.zzp(true);
                }
            }
        }
    }

    void zzc(int n, int n2) {
        if (this.zzCk != null) {
            this.zzCk.zza(n, n2, this.zzov, this.zzow);
        }
    }

    void zzd(int n, int n2) {
        int n3 = zzp.zzbx().zzj(this.zzCh)[0];
        this.zzb(n, n2 - n3, this.zzov, this.zzow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzeC() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzCl != null;
        }
    }

    public void zze(int n, int n2) {
        this.zzCd = n;
        this.zzCe = n2;
    }

    boolean zzeD() {
        int[] nArray = zzp.zzbx().zzh(this.zzCh);
        int[] nArray2 = zzp.zzbx().zzj(this.zzCh);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzov < 50 || this.zzov > n) {
            zzb.zzaH("Width is too small or too large.");
            return false;
        }
        if (this.zzow < 50 || this.zzow > n2) {
            zzb.zzaH("Height is too small or too large.");
            return false;
        }
        if (this.zzow == n2 && this.zzov == n) {
            zzb.zzaH("Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzCc) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzCb) {
                case "top-left": {
                    n3 = this.zzCd + this.zzCf;
                    n4 = this.zzCe + this.zzCg;
                    break;
                }
                case "top-center": {
                    n3 = this.zzCd + this.zzCf + this.zzov / 2 - 25;
                    n4 = this.zzCe + this.zzCg;
                    break;
                }
                case "center": {
                    n3 = this.zzCd + this.zzCf + this.zzov / 2 - 25;
                    n4 = this.zzCe + this.zzCg + this.zzow / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzCd + this.zzCf;
                    n4 = this.zzCe + this.zzCg + this.zzow - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzCd + this.zzCf + this.zzov / 2 - 25;
                    n4 = this.zzCe + this.zzCg + this.zzow - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzCd + this.zzCf + this.zzov - 50;
                    n4 = this.zzCe + this.zzCg + this.zzow - 50;
                    break;
                }
                default: {
                    n3 = this.zzCd + this.zzCf + this.zzov - 50;
                    n4 = this.zzCe + this.zzCg;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

