/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.zzha;
import java.util.Locale;

@zzha
public final class zzhi {
    public final int zzIA;
    public final boolean zzIB;
    public final boolean zzIC;
    public final String zzID;
    public final String zzIE;
    public final boolean zzIF;
    public final boolean zzIG;
    public final boolean zzIH;
    public final boolean zzII;
    public final String zzIJ;
    public final String zzIK;
    public final int zzIL;
    public final int zzIM;
    public final int zzIN;
    public final int zzIO;
    public final int zzIP;
    public final int zzIQ;
    public final float zzGC;
    public final int zzGA;
    public final int zzGB;
    public final double zzIR;
    public final boolean zzIS;
    public final boolean zzIT;
    public final int zzIU;
    public final String zzIV;

    zzhi(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6) {
        this.zzIA = n;
        this.zzIB = bl;
        this.zzIC = bl2;
        this.zzID = string2;
        this.zzIE = string3;
        this.zzIF = bl3;
        this.zzIG = bl4;
        this.zzIH = bl5;
        this.zzII = bl6;
        this.zzIJ = string4;
        this.zzIK = string5;
        this.zzIL = n2;
        this.zzIM = n3;
        this.zzIN = n4;
        this.zzIO = n5;
        this.zzIP = n6;
        this.zzIQ = n7;
        this.zzGC = f;
        this.zzGA = n8;
        this.zzGB = n9;
        this.zzIR = d;
        this.zzIS = bl7;
        this.zzIT = bl8;
        this.zzIU = n10;
        this.zzIV = string6;
    }

    public static final class zza {
        private int zzIA;
        private boolean zzIH;
        private boolean zzII;
        private int zzIL;
        private int zzIP;
        private int zzIQ;
        private String zzID;
        private int zzIM;
        private int zzIN;
        private int zzIO;
        private boolean zzIT;
        private int zzIU;
        private double zzIR;
        private boolean zzIS;
        private String zzIV;
        private boolean zzIB;
        private boolean zzIC;
        private String zzIE;
        private boolean zzIF;
        private boolean zzIG;
        private String zzIJ;
        private String zzIK;
        private float zzGC;
        private int zzGA;
        private int zzGB;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzB(context);
            this.zza(context, packageManager);
            this.zzC(context);
            Locale locale = Locale.getDefault();
            this.zzIB = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzIC = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzIE = locale.getCountry();
            this.zzIF = zzl.zzcN().zzhq();
            this.zzIG = GooglePlayServicesUtil.zzao((Context)context);
            this.zzIJ = locale.getLanguage();
            this.zzIK = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzGC = displayMetrics.density;
            this.zzGA = displayMetrics.widthPixels;
            this.zzGB = displayMetrics.heightPixels;
        }

        public zza(Context context, zzhi zzhi2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzB(context);
            this.zza(context, packageManager);
            this.zzC(context);
            this.zzD(context);
            this.zzIB = zzhi2.zzIB;
            this.zzIC = zzhi2.zzIC;
            this.zzIE = zzhi2.zzIE;
            this.zzIF = zzhi2.zzIF;
            this.zzIG = zzhi2.zzIG;
            this.zzIJ = zzhi2.zzIJ;
            this.zzIK = zzhi2.zzIK;
            this.zzGC = zzhi2.zzGC;
            this.zzGA = zzhi2.zzGA;
            this.zzGB = zzhi2.zzGB;
        }

        private void zzB(Context context) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            this.zzIA = audioManager.getMode();
            this.zzIH = audioManager.isMusicActive();
            this.zzII = audioManager.isSpeakerphoneOn();
            this.zzIL = audioManager.getStreamVolume(3);
            this.zzIP = audioManager.getRingerMode();
            this.zzIQ = audioManager.getStreamVolume(2);
        }

        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzID = telephonyManager.getNetworkOperator();
            this.zzIN = telephonyManager.getNetworkType();
            this.zzIO = telephonyManager.getPhoneType();
            this.zzIM = -2;
            this.zzIT = false;
            this.zzIU = -1;
            if (zzp.zzbx().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzIM = networkInfo.getType();
                    this.zzIU = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzIM = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzIT = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzC(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzIR = (float)n2 / (float)n3;
                this.zzIS = n == 2 || n == 5;
            } else {
                this.zzIR = -1.0;
                this.zzIS = false;
            }
        }

        private void zzD(Context context) {
            this.zzIV = Build.FINGERPRINT;
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzhi zzgv() {
            return new zzhi(this.zzIA, this.zzIB, this.zzIC, this.zzID, this.zzIE, this.zzIF, this.zzIG, this.zzIH, this.zzII, this.zzIJ, this.zzIK, this.zzIL, this.zzIM, this.zzIN, this.zzIO, this.zzIP, this.zzIQ, this.zzGC, this.zzGA, this.zzGB, this.zzIR, this.zzIS, this.zzIT, this.zzIU, this.zzIV);
        }
    }
}

