/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjj;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzb
extends zzim
implements zzc.zza {
    private final zza.zza zzHg;
    private final AdRequestInfoParcel.zza zzHh;
    private final Object zzGg = new Object();
    private final Context mContext;
    private final zzan zzyt;
    private AdRequestInfoParcel zzCu;
    private Runnable zzGf;
    zzit zzHi;
    AdResponseParcel zzGe;
    zzeo zzCf;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzan zzan2, zza.zza zza3) {
        this.zzHg = zza3;
        this.mContext = context;
        this.zzHh = zza2;
        this.zzyt = zzan2;
    }

    zzit zza(VersionInfoParcel versionInfoParcel, zzji<AdRequestInfoParcel> zzji2) {
        return zzc.zza(this.mContext, versionInfoParcel, zzji2, this);
    }

    @Override
    public void zzbr() {
        zzin.zzaI("AdLoaderBackgroundTask started.");
        this.zzGf = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzGg;
                synchronized (object) {
                    if (zzb.this.zzHi == null) {
                        return;
                    }
                    zzb.this.onStop();
                    zzb.this.zzc(2, "Timed out waiting for ad response.");
                }
            }
        };
        zzir.zzMc.postDelayed(this.zzGf, zzbt.zzwX.get().longValue());
        final zzjj<AdRequestInfoParcel> zzjj2 = new zzjj<AdRequestInfoParcel>();
        long l = zzr.zzbG().elapsedRealtime();
        zziq.zza(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = zzb.this.zzGg;
                synchronized (object) {
                    zzb.this.zzHi = zzb.this.zza(((zzb)zzb.this).zzHh.zzrl, zzjj2);
                    if (zzb.this.zzHi == null) {
                        zzb.this.zzc(0, "Could not start the ad request service.");
                        zzir.zzMc.removeCallbacks(zzb.this.zzGf);
                    }
                }
            }
        });
        zzaj zzaj2 = this.zzyt.zzab();
        String string2 = zzaj2.zzb(this.mContext);
        this.zzCu = new AdRequestInfoParcel(this.zzHh, string2, l);
        zzjj2.zzh(this.zzCu);
    }

    private void zzc(int n, String string2) {
        if (n == 3 || n == -1) {
            zzin.zzaJ(string2);
        } else {
            zzin.zzaK(string2);
        }
        this.zzGe = this.zzGe == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzGe.zzBU);
        AdRequestInfoParcel adRequestInfoParcel = this.zzCu != null ? this.zzCu : new AdRequestInfoParcel(this.zzHh, null, -1L);
        zzif.zza zza2 = new zzif.zza(adRequestInfoParcel, this.zzGe, this.zzCf, null, n, -1L, this.zzGe.zzHX, null);
        this.zzHg.zza(zza2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(@NonNull AdResponseParcel adResponseParcel) {
        zzin.zzaI("Received ad response.");
        this.zzGe = adResponseParcel;
        long l = zzr.zzbG().elapsedRealtime();
        Object object = this.zzGg;
        synchronized (object) {
            this.zzHi = null;
        }
        object = null;
        try {
            if (this.zzGe.errorCode != -2 && this.zzGe.errorCode != -3) {
                throw new zza("There was a problem getting an ad response. ErrorCode: " + this.zzGe.errorCode, this.zzGe.errorCode);
            }
            this.zzgq();
            if (this.zzCu.zzrp.zzuj != null) {
                object = this.zzb(this.zzCu);
            }
        }
        catch (zza zza2) {
            this.zzc(zza2.getErrorCode(), zza2.getMessage());
            zzir.zzMc.removeCallbacks(this.zzGf);
            return;
        }
        zzr.zzbF().zzB(this.zzGe.zzId);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzGe.zzIb)) {
            try {
                jSONObject = new JSONObject(this.zzGe.zzIb);
            }
            catch (Exception exception) {
                zzin.zzb("Error parsing the JSON for Active View.", exception);
            }
        }
        zzif.zza zza3 = new zzif.zza(this.zzCu, this.zzGe, this.zzCf, (AdSizeParcel)object, -2, l, this.zzGe.zzHX, jSONObject);
        this.zzHg.zza(zza3);
        zzir.zzMc.removeCallbacks(this.zzGf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzGg;
        synchronized (object) {
            if (this.zzHi != null) {
                this.zzHi.cancel();
            }
        }
    }

    protected void zzgq() throws zza {
        if (this.zzGe.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzGe.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzr.zzbF().zza(this.mContext, this.zzGe.zzHB);
        if (this.zzGe.zzHT) {
            try {
                this.zzCf = new zzeo(this.zzGe.body);
            }
            catch (JSONException jSONException) {
                throw new zza("Could not parse mediation config: " + this.zzGe.body, 0);
            }
        }
    }

    protected AdSizeParcel zzb(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzGe.zzHW == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzGe.zzHW.split("x");
        if (stringArray.length != 2) {
            throw new zza("Invalid ad size format from the ad response: " + this.zzGe.zzHW, 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zza("Invalid ad size number from the ad response: " + this.zzGe.zzHW, 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzrp.zzuj) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzrp.zzuj);
        }
        throw new zza("The ad size from the ad response was not one of the requested sizes: " + this.zzGe.zzHW, 0);
    }

    @zzhb
    static final class zza
    extends Exception {
        private final int zzGu;

        public zza(String string2, int n) {
            super(string2);
            this.zzGu = n;
        }

        public int getErrorCode() {
            return this.zzGu;
        }
    }
}

