/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zze;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzes;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzfc;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjq;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public class zzm {
    public static View zzf(zzif zzif2) {
        if (zzif2 == null) {
            zzin.e("AdState is null");
            return null;
        }
        if (zzm.zzg(zzif2)) {
            return zzif2.zzED.getView();
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2 = zzif2.zzCq.getView();
            if (zzd2 == null) {
                zzin.zzaK("View in mediation adapter is null.");
                return null;
            }
            return (View)com.google.android.gms.dynamic.zze.zzp((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzin.zzd("Could not get View from mediation adapter.", remoteException);
            return null;
        }
    }

    public static void zza(zzif zzif2, zzf.zza zza2) {
        if (zzm.zzg(zzif2)) {
            zzjp zzjp2 = zzif2.zzED;
            View view = zzjp2.getView();
            if (view == null) {
                zzin.zzaK("AdWebView is null");
                return;
            }
            try {
                List<String> list = zzif2.zzCp.zzBM;
                if (list == null || list.isEmpty()) {
                    zzin.zzaK("No template ids present in mediation response");
                    return;
                }
                zzfb zzfb2 = zzif2.zzCq.zzeF();
                zzfc zzfc2 = zzif2.zzCq.zzeG();
                if (list.contains("2") && zzfb2 != null) {
                    zzfb2.zzd(com.google.android.gms.dynamic.zze.zzC((Object)view));
                    if (!zzfb2.getOverrideImpressionRecording()) {
                        zzfb2.recordImpression();
                    }
                    zzjp2.zzhU().zza("/nativeExpressViewClicked", zzm.zza(zzfb2, null, zza2));
                } else if (list.contains("1") && zzfc2 != null) {
                    zzfc2.zzd(com.google.android.gms.dynamic.zze.zzC((Object)view));
                    if (!zzfc2.getOverrideImpressionRecording()) {
                        zzfc2.recordImpression();
                    }
                    zzjp2.zzhU().zza("/nativeExpressViewClicked", zzm.zza(null, zzfc2, zza2));
                } else {
                    zzin.zzaK("No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Error occurred while recording impression and registering for clicks", remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzjp zzjp2, zzes zzes2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzm.zzb(zzjp2, zzes2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzin.zzd("Unable to invoke load assets", remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzjp zzjp2, zzes zzes2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzjp2.getView();
        if (view == null) {
            zzin.zzaK("AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzes2.zzCp.zzBM;
        if (list == null || list.isEmpty()) {
            zzin.zzaK("No template ids present in mediation response");
            return false;
        }
        zzm.zza(zzjp2, countDownLatch);
        zzfb zzfb2 = zzes2.zzCq.zzeF();
        zzfc zzfc2 = zzes2.zzCq.zzeG();
        if (list.contains("2") && zzfb2 != null) {
            object = zzm.zza(zzfb2);
            zzm.zza(zzjp2, (zzd)object, zzes2.zzCp.zzBL);
        } else if (list.contains("1") && zzfc2 != null) {
            object = zzm.zza(zzfc2);
            zzm.zza(zzjp2, (zze)object, zzes2.zzCp.zzBL);
        } else {
            zzin.zzaK("No matching template id and mapper");
            return false;
        }
        object = zzes2.zzCp.zzBJ;
        String string2 = zzes2.zzCp.zzBK;
        if (string2 != null) {
            zzjp2.loadDataWithBaseURL(string2, (String)object, "text/html", "UTF-8", null);
        } else {
            zzjp2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzg(zzif zzif2) {
        return zzif2 != null && zzif2.zzHT && zzif2.zzCp != null && zzif2.zzCp.zzBJ != null;
    }

    private static zzd zza(zzfb zzfb2) throws RemoteException {
        return new zzd(zzfb2.getHeadline(), zzfb2.getImages(), zzfb2.getBody(), zzfb2.zzdK(), zzfb2.getCallToAction(), zzfb2.getStarRating(), zzfb2.getStore(), zzfb2.getPrice(), null, zzfb2.getExtras());
    }

    private static zze zza(zzfc zzfc2) throws RemoteException {
        return new zze(zzfc2.getHeadline(), zzfc2.getImages(), zzfc2.getBody(), zzfc2.zzdO(), zzfc2.getCallToAction(), zzfc2.getAdvertiser(), null, zzfc2.getExtras());
    }

    private static void zza(final zzjp zzjp2, final zzd zzd2, final String string2) {
        zzjp2.zzhU().zza(new zzjq.zza(){

            @Override
            public void zza(zzjp zzjp22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzd2.getHeadline());
                    jSONObject.put("body", (Object)zzd2.getBody());
                    jSONObject.put("call_to_action", (Object)zzd2.getCallToAction());
                    jSONObject.put("price", (Object)zzd2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzd2.getStarRating()));
                    jSONObject.put("store", (Object)zzd2.getStore());
                    jSONObject.put("icon", (Object)zzm.zza(zzd2.zzdK()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzd2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzch zzch2 = zzm.zzc(e);
                            jSONArray.put((Object)zzm.zza(zzch2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzm.zza(zzd2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzjp2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzin.zzd("Exception occurred when loading assets", jSONException);
                }
            }
        });
    }

    private static void zza(final zzjp zzjp2, final zze zze2, final String string2) {
        zzjp2.zzhU().zza(new zzjq.zza(){

            @Override
            public void zza(zzjp zzjp22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zze2.getHeadline());
                    jSONObject.put("body", (Object)zze2.getBody());
                    jSONObject.put("call_to_action", (Object)zze2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zze2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzm.zza(zze2.zzdO()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zze2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzch zzch2 = zzm.zzc(e);
                            jSONArray.put((Object)zzm.zza(zzch2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzm.zza(zze2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzjp2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzin.zzd("Exception occurred when loading assets", jSONException);
                }
            }
        });
    }

    private static void zza(zzjp zzjp2, CountDownLatch countDownLatch) {
        zzjp2.zzhU().zza("/nativeExpressAssetsLoaded", zzm.zza(countDownLatch));
        zzjp2.zzhU().zza("/nativeExpressAssetsLoadingFailed", zzm.zzb(countDownLatch));
    }

    static zzdf zza(final CountDownLatch countDownLatch) {
        return new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                countDownLatch.countDown();
                View view = zzjp2.getView();
                if (view == null) {
                    return;
                }
                view.setVisibility(0);
            }
        };
    }

    static zzdf zzb(final CountDownLatch countDownLatch) {
        return new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                zzin.zzaK("Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzjp2.destroy();
            }
        };
    }

    static zzdf zza(final zzfb zzfb2, final zzfc zzfc2, final zzf.zza zza2) {
        return new zzdf(){

            @Override
            public void zza(zzjp zzjp2, Map<String, String> map) {
                View view = zzjp2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzfb2 != null) {
                        if (!zzfb2.getOverrideClickHandling()) {
                            zzfb2.zzc(com.google.android.gms.dynamic.zze.zzC((Object)view));
                            zza2.onClick();
                        } else {
                            zzm.zza(zzjp2);
                        }
                    } else if (zzfc2 != null) {
                        if (!zzfc2.getOverrideClickHandling()) {
                            zzfc2.zzc(com.google.android.gms.dynamic.zze.zzC((Object)view));
                            zza2.onClick();
                        } else {
                            zzm.zza(zzjp2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzin.zzd("Unable to call handleClick on mapper", remoteException);
                }
            }
        };
    }

    private static void zza(zzjp zzjp2) {
        View.OnClickListener onClickListener = zzjp2.zzif();
        if (onClickListener != null) {
            onClickListener.onClick(zzjp2.getView());
        }
    }

    private static JSONObject zza(Bundle bundle, String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string2)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string2);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string3 = (String)iterator.next();
            if (!bundle.containsKey(string3)) continue;
            String string4 = jSONObject2.getString(string3);
            if ("image".equals(string4)) {
                object = bundle.get(string3);
                if (object instanceof Bitmap) {
                    String string5 = zzm.zza((Bitmap)object);
                    jSONObject.put(string3, (Object)string5);
                    continue;
                }
                zzin.zzaK("Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string3);
            if (object instanceof Bitmap) {
                zzin.zzaK("Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string3, (Object)String.valueOf(bundle.get(string3)));
        }
        return jSONObject;
    }

    static String zza(zzch zzch2) {
        if (zzch2 == null) {
            zzin.zzaK("Image is null. Returning empty string");
            return "";
        }
        Uri uri = null;
        try {
            uri = zzch2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzin.zzaK("Unable to get image uri. Trying data uri next");
        }
        return zzm.zzb(zzch2);
    }

    private static String zzb(zzch zzch2) {
        com.google.android.gms.dynamic.zzd zzd2;
        Drawable drawable = null;
        try {
            zzd2 = zzch2.zzdJ();
            if (zzd2 == null) {
                zzin.zzaK("Drawable is null. Returning empty string");
                return "";
            }
            drawable = (Drawable)com.google.android.gms.dynamic.zze.zzp((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzin.zzaK("Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable instanceof BitmapDrawable)) {
            zzin.zzaK("Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        zzd2 = (BitmapDrawable)drawable;
        Bitmap bitmap = zzd2.getBitmap();
        return zzm.zza(bitmap);
    }

    private static String zza(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzin.zzaK("Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = Base64.encodeToString((byte[])byArray, (int)0);
        return "data:image/png;base64," + string2;
    }

    private static zzch zzc(Object object) {
        if (object instanceof IBinder) {
            return zzch.zza.zzt((IBinder)object);
        }
        return null;
    }
}

