/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbd;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzne;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
@TargetApi(value=14)
public class zzbf
extends Thread {
    private boolean mStarted = false;
    private boolean zzsY = false;
    private boolean zzam = false;
    private final Object zzpV;
    private final zzbe zzsZ;
    private final zzbd zzta;
    private final zzha zztb;
    private final int zztc;
    private final int zzsK;
    private final int zztd;
    private final int zzsM;
    private final int zzte;

    public zzbf(zzbe zzbe2, zzbd zzbd2, zzha zzha2) {
        this.zzsZ = zzbe2;
        this.zzta = zzbd2;
        this.zztb = zzha2;
        this.zzpV = new Object();
        this.zzsK = zzbt.zzwk.get();
        this.zztd = zzbt.zzwl.get();
        this.zzsM = zzbt.zzwm.get();
        this.zzte = zzbt.zzwn.get();
        this.zztc = zzbt.zzwo.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcG() {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.mStarted) {
                zzin.zzaI("Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.zzam) {
            Object object;
            try {
                if (this.zzcH()) {
                    object = this.zzsZ.getActivity();
                    if (object == null) {
                        zzin.zzaI("ContentFetchThread: no activity");
                        continue;
                    }
                    this.zza((Activity)object);
                } else {
                    zzin.zzaI("ContentFetchTask: sleeping");
                    this.zzcJ();
                }
                Thread.sleep(this.zztc * 1000);
            }
            catch (Throwable throwable) {
                zzin.zzb("Error in ContentFetchTask", throwable);
                this.zztb.zza(throwable, true);
            }
            object = this.zzpV;
            synchronized (object) {
                while (this.zzsY) {
                    try {
                        zzin.zzaI("ContentFetchTask: waiting");
                        this.zzpV.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zze(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzbf.this.zzf(view);
            }
        });
        return true;
    }

    void zzf(View view) {
        try {
            zzbc zzbc2 = new zzbc(this.zzsK, this.zztd, this.zzsM, this.zzte);
            zza zza2 = this.zza(view, zzbc2);
            zzbc2.zzcD();
            if (zza2.zztm == 0 && zza2.zztn == 0) {
                return;
            }
            if (zza2.zztn == 0 && zzbc2.zzcE() == 0) {
                return;
            }
            if (zza2.zztn == 0 && this.zzta.zza(zzbc2)) {
                return;
            }
            this.zzta.zzc(zzbc2);
        }
        catch (Exception exception) {
            zzin.zzb("Exception in fetchContentOnUIThread", exception);
            this.zztb.zza(exception, true);
        }
    }

    boolean zzs(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzcH() {
        try {
            Context context = this.zzsZ.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzs(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zze(view);
    }

    zza zza(View view, zzbc zzbc2) {
        if (view == null) {
            return new zza(0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzbc2.zzd(string2, bl);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzjp)) {
            zzbc2.zzcC();
            if (this.zza((WebView)view, zzbc2, bl)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzbc2);
                n += zza2.zztm;
                n2 += zza2.zztn;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    @TargetApi(value=19)
    boolean zza(final WebView webView, final zzbc zzbc2, final boolean bl) {
        if (!zzne.zzsk()) {
            return false;
        }
        zzbc2.zzcC();
        webView.post(new Runnable(){
            ValueCallback<String> zzth = new ValueCallback<String>(){

                public void zzt(String string2) {
                    zzbf.this.zza(zzbc2, webView, string2, bl);
                }

                public /* synthetic */ void onReceiveValue(Object object) {
                    this.zzt((String)object);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzth);
                    }
                    catch (Throwable throwable) {
                        this.zzth.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzbc zzbc2, WebView webView, String string2, boolean bl) {
        zzbc2.zzcB();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    zzbc2.zzc(webView.getTitle() + "\n" + string3, bl);
                } else {
                    zzbc2.zzc(string3, bl);
                }
            }
            if (zzbc2.zzcx()) {
                this.zzta.zzb(zzbc2);
            }
        }
        catch (JSONException jSONException) {
            zzin.zzaI("Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzin.zza("Failed to get webview content.", throwable);
            this.zztb.zza(throwable, true);
        }
    }

    public zzbc zzcI() {
        return this.zzta.zzcF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzsY = false;
            this.zzpV.notifyAll();
            zzin.zzaI("ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcJ() {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzsY = true;
            zzin.zzaI("ContentFetchThread: paused, mPause = " + this.zzsY);
        }
    }

    public boolean zzcK() {
        return this.zzsY;
    }

    @zzhb
    class zza {
        final int zztm;
        final int zztn;

        zza(int n, int n2) {
            this.zztm = n;
            this.zztn = n2;
        }
    }
}

