/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzmq;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzhb
public class zzdu
extends zzdr {
    private static final Set<String> zzzX = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzzY = new DecimalFormat("#,###");
    private File zzzZ;
    private boolean zzAa;

    public zzdu(zzjp zzjp2) {
        super(zzjp2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzin.zzaK("Context.getCacheDir() returned null");
            return;
        }
        this.zzzZ = new File(file, "admobVideoStreams");
        if (!this.zzzZ.isDirectory() && !this.zzzZ.mkdirs()) {
            zzin.zzaK("Could not create preload cache directory at " + this.zzzZ.getAbsolutePath());
            this.zzzZ = null;
            return;
        }
        if (!this.zzzZ.setReadable(true, false) || !this.zzzZ.setExecutable(true, false)) {
            zzin.zzaK("Could not set cache file permissions at " + this.zzzZ.getAbsolutePath());
            this.zzzZ = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzU(String string2) {
        if (this.zzzZ == null) {
            this.zza(string2, null, "noCacheDir", null);
            return false;
        }
        while (this.zzea() > zzbt.zzvO.get()) {
            if (this.zzeb()) continue;
            zzin.zzaK("Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        String string3 = this.zzV(string2);
        File file = new File(this.zzzZ, string3);
        File file2 = this.zza(file);
        if (file.isFile() && file2.isFile()) {
            int n = (int)file.length();
            zzin.zzaI("Stream cache hit at " + string2);
            this.zza(string2, file.getAbsolutePath(), n);
            return true;
        }
        String string4 = this.zzzZ.getAbsolutePath() + string2;
        Object object = zzzX;
        synchronized (object) {
            if (zzzX.contains(string4)) {
                zzin.zzaK("Stream cache already in progress at " + string2);
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzzX.add(string4);
        }
        object = null;
        String string5 = "error";
        String string6 = null;
        try {
            int n;
            int n2;
            URLConnection uRLConnection = new URL(string2).openConnection();
            int n3 = zzbt.zzvT.get();
            uRLConnection.setConnectTimeout(n3);
            uRLConnection.setReadTimeout(n3);
            if (uRLConnection instanceof HttpURLConnection && (n2 = ((HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
                string5 = "badUrl";
                string6 = "HTTP request failed. Code: " + Integer.toString(n2);
                throw new IOException("HTTP status code " + n2 + " at " + string2);
            }
            n2 = uRLConnection.getContentLength();
            if (n2 < 0) {
                zzin.zzaK("Stream cache aborted, missing content-length header at " + string2);
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzzX.remove(string4);
                return false;
            }
            String string7 = zzzY.format(n2);
            int n4 = zzbt.zzvP.get();
            if (n2 > n4) {
                zzin.zzaK("Content length " + string7 + " exceeds limit at " + string2);
                String string8 = "File too big for full file cache. Size: " + string7;
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string8);
                zzzX.remove(string4);
                return false;
            }
            zzin.zzaI("Caching " + string7 + " bytes from " + string2);
            InputStream inputStream = uRLConnection.getInputStream();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            object = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zzmq zzmq2 = zzr.zzbG();
            int n5 = 0;
            long l = zzmq2.currentTimeMillis();
            long l2 = zzbt.zzvS.get();
            zziz zziz2 = new zziz(l2);
            long l3 = zzbt.zzvR.get();
            while ((n = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n5 += n) > n4) {
                    string5 = "sizeExceeded";
                    string6 = "File too big for full file cache. Size: " + Integer.toString(n5);
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                long l4 = zzmq2.currentTimeMillis();
                if (l4 - l > l3 * 1000L) {
                    string5 = "downloadTimeout";
                    string6 = "Timeout exceeded. Limit: " + Long.toString(l3) + " sec";
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzAa) {
                    string5 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zziz2.tryAcquire()) continue;
                this.zza(string2, file.getAbsolutePath(), n5, n2, false);
            }
            ((FileOutputStream)object).close();
            if (zzin.zzQ(3)) {
                String string9 = zzzY.format(n5);
                zzin.zzaI("Preloaded " + string9 + " bytes from " + string2);
            }
            file.setReadable(true, false);
            zzdu.zzb(file2);
            this.zza(string2, file.getAbsolutePath(), n5);
            zzzX.remove(string4);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            if (exception instanceof RuntimeException) {
                zzr.zzbF().zzb(exception, true);
            }
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException | NullPointerException exception2) {
                // empty catch block
            }
            if (this.zzAa) {
                zzin.zzaJ("Preload aborted for URL \"" + string2 + "\"");
            } else {
                zzin.zzd("Preload failed for URL \"" + string2 + "\"", exception);
            }
            if (file.exists() && !file.delete()) {
                zzin.zzaK("Could not delete partial cache file at " + file.getAbsolutePath());
            }
            this.zza(string2, file.getAbsolutePath(), string5, string6);
            zzzX.remove(string4);
            return false;
        }
    }

    @Override
    public void abort() {
        this.zzAa = true;
    }

    public int zzea() {
        if (this.zzzZ == null) {
            return 0;
        }
        int n = 0;
        for (File file : this.zzzZ.listFiles()) {
            if (file.getName().endsWith(".done")) continue;
            ++n;
        }
        return n;
    }

    public boolean zzeb() {
        if (this.zzzZ == null) {
            return false;
        }
        File file = null;
        long l = Long.MAX_VALUE;
        for (File file2 : this.zzzZ.listFiles()) {
            long l2;
            if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
            file = file2;
            l = l2;
        }
        boolean bl = false;
        if (file != null) {
            bl = file.delete();
            File file3 = this.zza(file);
            if (file3.isFile()) {
                bl &= file3.delete();
            }
        }
        return bl;
    }

    private File zza(File file) {
        return new File(this.zzzZ, file.getName() + ".done");
    }

    private static void zzb(File file) {
        if (file.isFile()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

