/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzen;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzes;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzez;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzir;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzhb
public final class zzer
implements zzes.zza {
    private final String zzCd;
    private final zzex zzpn;
    private final long zzCe;
    private final zzeo zzCf;
    private final zzen zzCg;
    private final AdRequestParcel zzqH;
    private final AdSizeParcel zzCh;
    private final Context mContext;
    private final Object zzpV = new Object();
    private final VersionInfoParcel zzpT;
    private final boolean zzsA;
    private final NativeAdOptionsParcel zzpP;
    private final List<String> zzpQ;
    private final boolean zzuS;
    private zzey zzCi;
    private int zzCj = -2;
    private zzfa zzCk;

    public zzer(Context context, String string2, zzex zzex2, zzeo zzeo2, zzen zzen2, AdRequestParcel adRequestParcel, AdSizeParcel adSizeParcel, VersionInfoParcel versionInfoParcel, boolean bl, boolean bl2, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) {
        this.mContext = context;
        this.zzpn = zzex2;
        this.zzCg = zzen2;
        this.zzCd = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zzey() : string2;
        this.zzCf = zzeo2;
        this.zzCe = zzeo2.zzBP != -1L ? zzeo2.zzBP : 10000L;
        this.zzqH = adRequestParcel;
        this.zzCh = adSizeParcel;
        this.zzpT = versionInfoParcel;
        this.zzsA = bl;
        this.zzuS = bl2;
        this.zzpP = nativeAdOptionsParcel;
        this.zzpQ = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzpV;
        synchronized (object) {
            try {
                if (this.zzCi != null) {
                    this.zzCi.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzin.zzd("Could not destroy mediation adapter.", remoteException);
            }
            this.zzCj = -1;
            this.zzpV.notify();
        }
    }

    private String zzey() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzCg.zzBD)) {
                return this.zzpn.zzag(this.zzCg.zzBD) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzin.zzaK("Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzr(int n) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzCj = n;
            this.zzpV.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzfa zzfa2) {
        Object object = this.zzpV;
        synchronized (object) {
            this.zzCj = n;
            this.zzCk = zzfa2;
            this.zzpV.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzes zza(long l, long l2) {
        Object object = this.zzpV;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzeq zzeq2 = new zzeq();
            zzir.zzMc.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzer.this.zzpV;
                    synchronized (object) {
                        if (zzer.this.zzCj != -2) {
                            return;
                        }
                        zzer.this.zzCi = zzer.this.zzeA();
                        if (zzer.this.zzCi == null) {
                            zzer.this.zzr(4);
                            return;
                        }
                        if (zzer.this.zzeB() && !zzer.this.zzs(1)) {
                            zzin.zzaK("Ignoring adapter " + zzer.this.zzCd + " as delayed" + " impression is not supported");
                            zzer.this.zzr(2);
                            return;
                        }
                        zzeq2.zza(zzer.this);
                        zzer.this.zza(zzeq2);
                    }
                }
            });
            this.zza(l3, this.zzCe, l, l2);
            return new zzes(this.zzCg, this.zzCi, this.zzCd, zzeq2, this.zzCj, this.zzez());
        }
    }

    private zzfa zzez() {
        if (this.zzCj != 0 || !this.zzeB()) {
            return null;
        }
        try {
            if (this.zzs(4) && this.zzCk != null && this.zzCk.zzeD() != 0) {
                return this.zzCk;
            }
        }
        catch (RemoteException remoteException) {
            zzin.zzaK("Could not get cpm value from MediationResponseMetadata");
        }
        return zzer.zzt(this.zzeC());
    }

    private zzey zzeA() {
        zzin.zzaJ("Instantiating mediation adapter: " + this.zzCd);
        if (zzbt.zzwV.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzCd)) {
            return new zzfe(new AdMobAdapter());
        }
        if (zzbt.zzwW.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzCd)) {
            return new zzfe(new AdUrlAdapter());
        }
        try {
            return this.zzpn.zzaf(this.zzCd);
        }
        catch (RemoteException remoteException) {
            zzin.zza("Could not instantiate mediation adapter: " + this.zzCd, remoteException);
            return null;
        }
    }

    private void zza(zzeq zzeq2) {
        String string2;
        if ("com.google.ads.mediation.AdUrlAdapter".equals(this.zzCd)) {
            string2 = this.zzqH.zztM.getBundle(this.zzCd);
            if (string2 == null) {
                string2 = new Bundle();
            }
            string2.putString("sdk_less_network_id", this.zzCg.zzBA);
            this.zzqH.zztM.putBundle(this.zzCd, (Bundle)string2);
        }
        string2 = this.zzac(this.zzCg.zzBG);
        try {
            if (this.zzpT.zzNa < 4100000) {
                if (this.zzCh.zzui) {
                    this.zzCi.zza(zze.zzC((Object)this.mContext), this.zzqH, string2, zzeq2);
                } else {
                    this.zzCi.zza(zze.zzC((Object)this.mContext), this.zzCh, this.zzqH, string2, (zzez)zzeq2);
                }
            } else if (this.zzsA) {
                this.zzCi.zza(zze.zzC((Object)this.mContext), this.zzqH, string2, this.zzCg.zzBz, zzeq2, this.zzpP, this.zzpQ);
            } else if (this.zzCh.zzui) {
                this.zzCi.zza(zze.zzC((Object)this.mContext), this.zzqH, string2, this.zzCg.zzBz, (zzez)zzeq2);
            } else if (this.zzuS) {
                if (this.zzCg.zzBJ != null) {
                    this.zzCi.zza(zze.zzC((Object)this.mContext), this.zzqH, string2, this.zzCg.zzBz, zzeq2, new NativeAdOptionsParcel(zzer.zzad(this.zzCg.zzBN)), this.zzCg.zzBM);
                } else {
                    this.zzCi.zza(zze.zzC((Object)this.mContext), this.zzCh, this.zzqH, string2, this.zzCg.zzBz, zzeq2);
                }
            } else {
                this.zzCi.zza(zze.zzC((Object)this.mContext), this.zzCh, this.zzqH, string2, this.zzCg.zzBz, zzeq2);
            }
        }
        catch (RemoteException remoteException) {
            zzin.zzd("Could not request ad from mediation adapter.", remoteException);
            this.zzr(5);
        }
    }

    private void zza(long l, long l2, long l3, long l4) {
        while (this.zzCj == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzin.zzaJ("Timed out waiting for adapter.");
            this.zzCj = 3;
            return;
        }
        try {
            this.zzpV.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzCj = -1;
        }
    }

    private boolean zzs(int n) {
        Bundle bundle = null;
        try {
            bundle = this.zzsA ? this.zzCi.zzeI() : (this.zzCh.zzui ? this.zzCi.getInterstitialAdapterInfo() : this.zzCi.zzeH());
        }
        catch (RemoteException remoteException) {
            zzin.zzaK("Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzeB() {
        return this.zzCf.zzBX != -1;
    }

    private String zzac(String string2) {
        if (string2 == null || !this.zzeB() || this.zzs(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzin.zzaK("Could not remove field. Returning the original value");
            return string2;
        }
    }

    private int zzeC() {
        JSONObject jSONObject;
        if (this.zzCg.zzBG == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzCg.zzBG);
        }
        catch (JSONException jSONException) {
            zzin.zzaK("Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzCd)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzs(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzfa zzt(final int n) {
        return new zzfa.zza(){

            @Override
            public int zzeD() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzad(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzer.zzae(string3));
        }
        catch (JSONException jSONException) {
            zzin.zzd("Exception occurred when creating native ad options", jSONException);
        }
        return builder.build();
    }

    private static int zzae(String string2) {
        if ("landscape".equals(string2)) {
            return 2;
        }
        if ("portrait".equals(string2)) {
            return 1;
        }
        return 0;
    }
}

