/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.internal.zzbl;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzjp;
import java.util.Map;

@zzhb
public class zzfp
extends zzfs {
    private final Map<String, String> zzxA;
    private final Context mContext;

    public zzfp(zzjp zzjp2, Map<String, String> map) {
        super(zzjp2, "storePicture");
        this.zzxA = map;
        this.mContext = zzjp2.zzhP();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzam("Activity context is not available");
            return;
        }
        zzbl zzbl2 = zzr.zzbC().zzM(this.mContext);
        if (!zzbl2.zzdl()) {
            this.zzam("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzxA.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzam("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            this.zzam("Invalid image url: " + string2);
            return;
        }
        final String string3 = this.zzal(string2);
        if (!zzr.zzbC().zzaE(string3)) {
            this.zzam("Image type not recognized: " + string3);
            return;
        }
        AlertDialog.Builder builder = zzr.zzbC().zzL(this.mContext);
        builder.setTitle((CharSequence)zzr.zzbF().zzd(R.string.store_picture_title, "Save image"));
        builder.setMessage((CharSequence)zzr.zzbF().zzd(R.string.store_picture_message, "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)zzr.zzbF().zzd(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadManager downloadManager = (DownloadManager)zzfp.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzfp.this.zzf(string2, string3);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzfp.this.zzam("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)zzr.zzbF().zzd(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzfp.this.zzam("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzf(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzr.zzbE().zza(request);
        return request;
    }

    String zzal(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

