/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.TextureView;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzkf;
import java.util.concurrent.TimeUnit;

@zzig
public class zzx {
    private final Context mContext;
    private final String zzII;
    private final VersionInfoParcel zzrx;
    @Nullable
    private final zzda zzIJ;
    @Nullable
    private final zzdc zzIK;
    private final zzkf zzIL = new zzkf.zzb().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzjj();
    private final long[] zzIM;
    private final String[] zzIN;
    @Nullable
    private zzda zzIO;
    @Nullable
    private zzda zzIP;
    @Nullable
    private zzda zzIQ;
    @Nullable
    private zzda zzIR;
    private boolean zzIS;
    private zzi zzIT;
    private boolean zzIU;
    private boolean zzIV;
    private long zzIW = -1L;

    public zzx(Context context, VersionInfoParcel versionInfoParcel, String string, @Nullable zzdc zzdc2, @Nullable zzda zzda2) {
        this.mContext = context;
        this.zzrx = versionInfoParcel;
        this.zzII = string;
        this.zzIK = zzdc2;
        this.zzIJ = zzda2;
        String string2 = zzcu.zzxu.get();
        if (string2 == null) {
            this.zzIN = new String[0];
            this.zzIM = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string2, (String)",");
        this.zzIN = new String[stringArray.length];
        this.zzIM = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzIM[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzjw.zzd((String)"Unable to parse frame hash target time number.", (Throwable)numberFormatException);
                this.zzIM[i] = -1L;
            }
        }
    }

    public void zza(zzi zzi2) {
        zzcy.zza(this.zzIK, this.zzIJ, "vpc");
        this.zzIO = zzcy.zzb(this.zzIK);
        if (this.zzIK != null) {
            this.zzIK.zzf("vpn", zzi2.zzgc());
        }
        this.zzIT = zzi2;
    }

    public void zzgD() {
        if (this.zzIO == null || this.zzIP != null) {
            return;
        }
        zzcy.zza(this.zzIK, this.zzIO, "vfr");
        this.zzIP = zzcy.zzb(this.zzIK);
    }

    public void onStop() {
        if (zzcu.zzxt.get().booleanValue() && !this.zzIU) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzII);
            bundle.putString("player", this.zzIT.zzgc());
            for (zzkf.zza object : this.zzIL.getBuckets()) {
                String string = String.valueOf("fps_c_");
                String string2 = String.valueOf(object.name);
                bundle.putString(string2.length() != 0 ? string.concat(string2) : new String(string), Integer.toString(object.count));
                String string3 = String.valueOf("fps_p_");
                String string4 = String.valueOf(object.name);
                bundle.putString(string4.length() != 0 ? string3.concat(string4) : new String(string3), Double.toString(object.zzQQ));
            }
            for (int i = 0; i < this.zzIM.length; ++i) {
                String string = this.zzIN[i];
                if (string == null) continue;
                String string5 = String.valueOf("fh_");
                String string6 = String.valueOf((Object)this.zzIM[i]);
                bundle.putString(new StringBuilder(0 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(string6).toString(), string);
            }
            zzu.zzck().zza(this.mContext, this.zzrx.afmaVersion, "gmob-apps", bundle, true);
            this.zzIU = true;
        }
    }

    public void zzb(zzi zzi2) {
        this.zzhc();
        this.zzc(zzi2);
    }

    private void zzhc() {
        if (this.zzIQ != null && this.zzIR == null) {
            zzcy.zza(this.zzIK, this.zzIQ, "vff");
            zzcy.zza(this.zzIK, this.zzIJ, "vtt");
            this.zzIR = zzcy.zzb(this.zzIK);
        }
        long l = zzu.zzco().nanoTime();
        if (this.zzIS && this.zzIV && this.zzIW != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - this.zzIW);
            this.zzIL.zza(d);
        }
        this.zzIV = this.zzIS;
        this.zzIW = l;
    }

    private void zzc(zzi zzi2) {
        long l = zzcu.zzxv.get();
        long l2 = zzi2.getCurrentPosition();
        for (int i = 0; i < this.zzIN.length; ++i) {
            long l3;
            if (this.zzIN[i] != null || l <= Math.abs(l2 - (l3 = this.zzIM[i]))) continue;
            this.zzIN[i] = this.zza((TextureView)zzi2);
            break;
        }
    }

    String zza(TextureView textureView) {
        Bitmap bitmap = textureView.getBitmap(8, 8);
        long l = 0L;
        long l2 = 63L;
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                int n2 = bitmap.getPixel(n, i);
                int n3 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2);
                long l3 = n3 > 128 ? 1L : 0L;
                l |= l3 << (int)l2;
                ++n;
                --l2;
            }
        }
        return String.format("%016X", l);
    }

    public void zzhd() {
        this.zzIS = true;
        if (this.zzIP != null && this.zzIQ == null) {
            zzcy.zza(this.zzIK, this.zzIP, "vfp");
            this.zzIQ = zzcy.zzb(this.zzIK);
        }
    }

    public void zzhe() {
        this.zzIS = false;
    }
}

