/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbo;
import com.google.android.gms.internal.zzbp;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzjz;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzig
public class zzt
extends zzu.zza {
    private final VersionInfoParcel zzqP;
    private final AdSizeParcel zzrJ;
    private final Future<zzbo> zzrK;
    private final Context mContext;
    private final zzb zzrL;
    private WebView zzrM;
    private zzq zzqG;
    private zzbo zzrN;
    private AsyncTask<Void, Void, Void> zzrO;

    public zzt(Context context, AdSizeParcel adSizeParcel, String string, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzqP = versionInfoParcel;
        this.zzrJ = adSizeParcel;
        this.zzrM = new WebView(this.mContext);
        this.zzrK = this.zzca();
        this.zzrL = new zzb(string);
        this.zzbX();
    }

    public com.google.android.gms.dynamic.zzd zzbh() throws RemoteException {
        zzaa.zzdc((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzD((Object)this.zzrM);
    }

    public void destroy() throws RemoteException {
        zzaa.zzdc((String)"destroy must be called on the main UI thread.");
        this.zzrO.cancel(true);
        this.zzrK.cancel(true);
        this.zzrM.destroy();
        this.zzrM = null;
    }

    public boolean isReady() throws RemoteException {
        return false;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) throws RemoteException {
        zzaa.zzb((Object)this.zzrM, (Object)"This Search Ad has already been torn down");
        this.zzrL.zzh(adRequestParcel);
        this.zzrO = new zza().execute(new Void[0]);
        return true;
    }

    public void pause() throws RemoteException {
        zzaa.zzdc((String)"pause must be called on the main UI thread.");
    }

    public void resume() throws RemoteException {
        zzaa.zzdc((String)"resume must be called on the main UI thread.");
    }

    public void zza(zzq zzq2) throws RemoteException {
        this.zzqG = zzq2;
    }

    public void zza(zzw zzw2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void showInterstitial() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void stopLoading() throws RemoteException {
    }

    public void zzbk() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public AdSizeParcel zzbi() throws RemoteException {
        return this.zzrJ;
    }

    public void zza(AdSizeParcel adSizeParcel) throws RemoteException {
        throw new IllegalStateException("AdSize must be set before initialization");
    }

    public void zza(zzhh zzhh2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzhl zzhl2, String string) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public String getMediationAdapterClassName() throws RemoteException {
        return null;
    }

    public void zza(zzdg zzdg2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzp zzp2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzy zzy2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setManualImpressionsEnabled(boolean bl) throws RemoteException {
    }

    public boolean isLoading() throws RemoteException {
        return false;
    }

    public void zza(zzd zzd2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setUserId(String string) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public zzab zzbl() {
        return null;
    }

    public void zza(VideoOptionsParcel videoOptionsParcel) {
        throw new IllegalStateException("Unused method");
    }

    private void zzbX() {
        this.zzh(0);
        this.zzrM.setVerticalScrollBarEnabled(false);
        this.zzrM.getSettings().setJavaScriptEnabled(true);
        this.zzrM.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView webView, String string) {
                if (string.startsWith(zzt.this.zzbZ())) {
                    return false;
                }
                if (string.startsWith(zzcu.zzzv.get())) {
                    if (zzt.this.zzqG != null) {
                        try {
                            zzt.this.zzqG.onAdFailedToLoad(3);
                        }
                        catch (RemoteException remoteException) {
                            zzjw.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzh(0);
                    return true;
                }
                if (string.startsWith(zzcu.zzzw.get())) {
                    if (zzt.this.zzqG != null) {
                        try {
                            zzt.this.zzqG.onAdFailedToLoad(0);
                        }
                        catch (RemoteException remoteException) {
                            zzjw.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzh(0);
                    return true;
                }
                if (string.startsWith(zzcu.zzzx.get())) {
                    if (zzt.this.zzqG != null) {
                        try {
                            zzt.this.zzqG.onAdLoaded();
                        }
                        catch (RemoteException remoteException) {
                            zzjw.zzd((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
                        }
                    }
                    int n = zzt.this.zzw(string);
                    zzt.this.zzh(n);
                    return true;
                }
                if (string.startsWith("gmsg://")) {
                    return true;
                }
                if (zzt.this.zzqG != null) {
                    try {
                        zzt.this.zzqG.onAdLeftApplication();
                    }
                    catch (RemoteException remoteException) {
                        zzjw.zzd((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
                    }
                }
                String string2 = zzt.this.zzx(string);
                zzt.this.zzy(string2);
                return true;
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                if (zzt.this.zzqG != null) {
                    try {
                        zzt.this.zzqG.onAdFailedToLoad(0);
                    }
                    catch (RemoteException remoteException) {
                        zzjw.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                    }
                }
            }
        });
        this.zzrM.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (zzt.this.zzrN != null) {
                    try {
                        zzt.this.zzrN.zza(motionEvent);
                    }
                    catch (RemoteException remoteException) {
                        zzjw.zzd((String)"Unable to process ad data", (Throwable)remoteException);
                    }
                }
                return false;
            }
        });
    }

    int zzw(String string) {
        String string2 = Uri.parse((String)string).getQueryParameter("height");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return 0;
        }
        try {
            return zzm.zzdQ().zza(this.mContext, Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void zzh(int n) {
        if (this.zzrM == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, n);
        this.zzrM.setLayoutParams(layoutParams);
    }

    String zzbY() {
        String string2;
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https://").appendEncodedPath(zzcu.zzzy.get());
        builder.appendQueryParameter("query", this.zzrL.getQuery());
        builder.appendQueryParameter("pubId", this.zzrL.zzcd());
        Map<String, String> map = this.zzrL.zzce();
        for (String string2 : map.keySet()) {
            builder.appendQueryParameter(string2, map.get(string2));
        }
        Uri uri = builder.build();
        if (this.zzrN != null) {
            try {
                uri = this.zzrN.zzc(uri, this.mContext);
            }
            catch (RemoteException | zzbp throwable) {
                zzjw.zzd((String)"Unable to process ad data", (Throwable)throwable);
            }
        }
        string2 = String.valueOf(this.zzbZ());
        String string3 = String.valueOf(uri.getEncodedQuery());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("#").append(string3).toString();
    }

    String zzbZ() {
        String string = this.zzrL.zzcc();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "www.google.com";
        }
        String string2 = String.valueOf("https://");
        String string3 = string;
        String string4 = zzcu.zzzy.get();
        return new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(string3).append(string4).toString();
    }

    private String zzx(String string) {
        if (this.zzrN == null) {
            return string;
        }
        Uri uri = Uri.parse((String)string);
        try {
            uri = this.zzrN.zzd(uri, this.mContext);
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)"Unable to process ad data", (Throwable)remoteException);
        }
        catch (zzbp zzbp2) {
            zzjw.zzd((String)"Unable to parse ad click url", (Throwable)zzbp2);
        }
        return uri.toString();
    }

    private void zzy(String string) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string));
        this.mContext.startActivity(intent);
    }

    private Future<zzbo> zzca() {
        return zzjz.zza(new Callable<zzbo>(){

            public zzbo zzcb() throws Exception {
                return new zzbo(((zzt)zzt.this).zzqP.afmaVersion, zzt.this.mContext, false);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzcb();
            }
        });
    }

    private static class zzb {
        private final String zzrQ;
        private final Map<String, String> zzrR;
        private String zzrS;
        private String zzrT;

        public zzb(String string) {
            this.zzrQ = string;
            this.zzrR = new TreeMap<String, String>();
        }

        public String zzcc() {
            return this.zzrT;
        }

        public String getQuery() {
            return this.zzrS;
        }

        public String zzcd() {
            return this.zzrQ;
        }

        public Map<String, String> zzce() {
            return this.zzrR;
        }

        public void zzh(AdRequestParcel adRequestParcel) {
            this.zzrS = adRequestParcel.zzuU.zzwM;
            Bundle bundle = null;
            if (adRequestParcel.zzuX != null) {
                bundle = adRequestParcel.zzuX.getBundle(AdMobAdapter.class.getName());
            }
            if (bundle == null) {
                return;
            }
            String string = zzcu.zzzz.get();
            for (String string2 : bundle.keySet()) {
                if (string.equals(string2)) {
                    this.zzrT = bundle.getString(string2);
                    continue;
                }
                if (!string2.startsWith("csa_")) continue;
                this.zzrR.put(string2.substring("csa_".length()), bundle.getString(string2));
            }
        }
    }

    private class zza
    extends AsyncTask<Void, Void, Void> {
        private zza() {
        }

        protected Void zza(Void ... voidArray) {
            try {
                zzt.this.zzrN = (zzbo)zzt.this.zzrK.get(zzcu.zzzA.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                zzjw.zzd((String)"Failed to load ad data", (Throwable)exception);
            }
            catch (TimeoutException timeoutException) {
                zzjw.zzaW((String)"Timed out waiting for ad data");
            }
            return null;
        }

        protected void zza(Void void_) {
            String string = zzt.this.zzbY();
            if (zzt.this.zzrM != null) {
                zzt.this.zzrM.loadUrl(string);
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.zza((Void)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.zza((Void[])objectArray);
        }
    }
}

