/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import java.util.Map;

@zzig
public class zzkd {
    private final Context mContext;
    private String zzQD;
    private final float zzGx;
    private float zzQE;
    private float zzQF;
    private float zzQG;
    private int mState = 0;

    public zzkd(Context context) {
        this.mContext = context;
        this.zzGx = context.getResources().getDisplayMetrics().density;
    }

    public zzkd(Context context, String string2) {
        this(context);
        this.zzQD = string2;
    }

    public void zze(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzQE = f;
            this.zzQF = f2;
            this.zzQG = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzQF) {
                    this.zzQF = f2;
                } else if (f2 < this.zzQG) {
                    this.zzQG = f2;
                }
                if (this.zzQF - this.zzQG > 30.0f * this.zzGx) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzQE >= 50.0f * this.zzGx) {
                        this.zzQE = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzQE <= -50.0f * this.zzGx) {
                    this.zzQE = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzQE) {
                        this.zzQE = f;
                    }
                } else if (this.mState == 2 && f < this.zzQE) {
                    this.zzQE = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void zzaR(String string2) {
        this.zzQD = string2;
    }

    private void showDialog() {
        if (!(this.mContext instanceof Activity)) {
            zzjw.zzaV((String)"Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzkd.zzaS(this.zzQD);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzu.zzck().zzb(zzkd.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    static String zzaS(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzu.zzck().zzf(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

