/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzei;
import com.google.android.gms.internal.zzem;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzla;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzn
extends zzjv {
    static final long zzMw = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzrs = new Object();
    static boolean zzMx = false;
    private static zzfj zzKn = null;
    private static zzei zzMy = null;
    private static zzem zzMz = null;
    private static zzeh zzMA = null;
    private final zza.zza zzKV;
    private final AdRequestInfoParcel.zza zzKW;
    private final Object zzJM = new Object();
    private final Context mContext;
    private zzfj.zzc zzMB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzn(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzKV = zza3;
        this.mContext = context;
        this.zzKW = zza2;
        Object object = zzrs;
        synchronized (object) {
            if (!zzMx) {
                zzMz = new zzem();
                zzMy = new zzei(context.getApplicationContext(), zza2.zzsx);
                zzMA = new zzc();
                zzKn = new zzfj(this.mContext.getApplicationContext(), this.zzKW.zzsx, zzcu.zzwZ.get(), new zzb(), new zza());
                zzMx = true;
            }
        }
    }

    protected static void zzb(zzfg zzfg2) {
        zzfg2.zza("/loadAd", zzMz);
        zzfg2.zza("/fetchHttpRequest", zzMy);
        zzfg2.zza("/invalidRequest", zzMA);
    }

    protected static void zzc(zzfg zzfg2) {
        zzfg2.zzb("/loadAd", zzMz);
        zzfg2.zzb("/fetchHttpRequest", zzMy);
        zzfg2.zzb("/invalidRequest", zzMA);
    }

    @Override
    public void zzbQ() {
        zzjw.zzaU((String)"SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzKW, null, -1L);
        AdResponseParcel adResponseParcel = this.zze(adRequestInfoParcel);
        long l = zzu.zzco().elapsedRealtime();
        final zzjn.zza zza2 = new zzjn.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzLT, null);
        com.google.android.gms.ads.internal.util.client.zza.zzRt.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzKV.zza(zza2);
                if (zzn.this.zzMB != null) {
                    zzn.this.zzMB.release();
                    zzn.this.zzMB = null;
                }
            }
        });
    }

    private AdResponseParcel zze(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string = zzu.zzck().zziZ();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzu.zzco().elapsedRealtime();
        Future<JSONObject> future = zzMz.zzW(string);
        com.google.android.gms.ads.internal.util.client.zza.zzRt.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzMB = zzKn.zzfu();
                zzn.this.zzMB.zza(new zzkt.zzc<zzfk>(){

                    public void zzb(zzfk zzfk2) {
                        try {
                            zzfk2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzjw.zzb((String)"Error requesting an ad url", (Throwable)exception);
                            zzMz.zzX(string);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzc(Object object) {
                        this.zzb((zzfk)object);
                    }
                }, new zzkt.zza(){

                    @Override
                    public void run() {
                        zzMz.zzX(string);
                    }
                });
            }
        });
        long l2 = zzMw - (zzu.zzco().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzij.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string) {
        Bundle bundle = adRequestInfoParcel.zzLi.extras.getBundle("sdk_less_server_data");
        String string2 = adRequestInfoParcel.zzLi.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzij.zza(this.mContext, adRequestInfoParcel, zzu.zzcq().zzx(this.mContext), null, null, new zzcn(zzcu.zzwZ.get()), null, null, new ArrayList<String>(), null, null);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzjw.zzd((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string);
        hashMap.put("network_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzu.zzck().zzM(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzJM;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzRt.post(new Runnable(){

                @Override
                public void run() {
                    if (zzn.this.zzMB != null) {
                        zzn.this.zzMB.release();
                        zzn.this.zzMB = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzke<zzfg> {
        public void zza(zzfg zzfg2) {
            zzn.zzc(zzfg2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzfg)object);
        }
    }

    public static class zzb
    implements zzke<zzfg> {
        public void zza(zzfg zzfg2) {
            zzn.zzb(zzfg2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzfg)object);
        }
    }

    public static class zzc
    implements zzeh {
        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            String string = map.get("request_id");
            String string2 = map.get("errors");
            String string3 = String.valueOf(string2);
            zzjw.zzaW((String)(string3.length() != 0 ? "Invalid request: ".concat(string3) : new String("Invalid request: ")));
            zzMz.zzX(string);
        }
    }
}

