/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zze;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzn {
    @Nullable
    public static View zzf(@Nullable zzjn zzjn2) {
        if (zzjn2 == null) {
            zzjw.e((String)"AdState is null");
            return null;
        }
        if (zzn.zzg(zzjn2) && zzjn2.zzHF != null) {
            return zzjn2.zzHF.getView();
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2;
            com.google.android.gms.dynamic.zzd zzd3 = zzd2 = zzjn2.zzFh != null ? zzjn2.zzFh.getView() : null;
            if (zzd2 == null) {
                zzjw.zzaW((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)com.google.android.gms.dynamic.zze.zzx((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    public static void zza(@Nullable zzjn zzjn2, zzf.zza zza2) {
        if (zzjn2 != null && zzn.zzg(zzjn2)) {
            View view;
            zzla zzla2 = zzjn2.zzHF;
            View view2 = view = zzla2 != null ? zzla2.getView() : null;
            if (view == null) {
                zzjw.zzaW((String)"AdWebView is null");
                return;
            }
            try {
                zzgf zzgf2;
                List<String> list;
                List<String> list2 = list = zzjn2.zzFg != null ? zzjn2.zzFg.zzEB : null;
                if (list == null || list.isEmpty()) {
                    zzjw.zzaW((String)"No template ids present in mediation response");
                    return;
                }
                zzge zzge2 = zzjn2.zzFh != null ? zzjn2.zzFh.zzfI() : null;
                zzgf zzgf3 = zzgf2 = zzjn2.zzFh != null ? zzjn2.zzFh.zzfJ() : null;
                if (list.contains("2") && zzge2 != null) {
                    zzge2.zzl(com.google.android.gms.dynamic.zze.zzD((Object)view));
                    if (!zzge2.getOverrideImpressionRecording()) {
                        zzge2.recordImpression();
                    }
                    zzla2.zzjD().zza("/nativeExpressViewClicked", zzn.zza(zzge2, null, zza2));
                } else if (list.contains("1") && zzgf2 != null) {
                    zzgf2.zzl(com.google.android.gms.dynamic.zze.zzD((Object)view));
                    if (!zzgf2.getOverrideImpressionRecording()) {
                        zzgf2.recordImpression();
                    }
                    zzla2.zzjD().zza("/nativeExpressViewClicked", zzn.zza(null, zzgf2, zza2));
                } else {
                    zzjw.zzaW((String)"No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzla zzla2, zzfv zzfv2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzn.zzb(zzla2, zzfv2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)"Unable to invoke load assets", (Throwable)remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzla zzla2, zzfv zzfv2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzla2.getView();
        if (view == null) {
            zzjw.zzaW((String)"AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzfv2.zzFg.zzEB;
        if (list == null || list.isEmpty()) {
            zzjw.zzaW((String)"No template ids present in mediation response");
            return false;
        }
        zzn.zza(zzla2, countDownLatch);
        zzge zzge2 = zzfv2.zzFh.zzfI();
        zzgf zzgf2 = zzfv2.zzFh.zzfJ();
        if (list.contains("2") && zzge2 != null) {
            object = zzn.zza(zzge2);
            zzn.zza(zzla2, object, zzfv2.zzFg.zzEA);
        } else if (list.contains("1") && zzgf2 != null) {
            object = zzn.zza(zzgf2);
            zzn.zza(zzla2, (zze)object, zzfv2.zzFg.zzEA);
        } else {
            zzjw.zzaW((String)"No matching template id and mapper");
            return false;
        }
        object = zzfv2.zzFg.zzEy;
        String string = zzfv2.zzFg.zzEz;
        if (string != null) {
            zzla2.loadDataWithBaseURL(string, (String)object, "text/html", "UTF-8", null);
        } else {
            zzla2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzg(@Nullable zzjn zzjn2) {
        return zzjn2 != null && zzjn2.zzLP && zzjn2.zzFg != null && zzjn2.zzFg.zzEy != null;
    }

    private static zzd zza(zzge zzge2) throws RemoteException {
        return new zzd(zzge2.getHeadline(), zzge2.getImages(), zzge2.getBody(), zzge2.zzeN(), zzge2.getCallToAction(), zzge2.getStarRating(), zzge2.getStore(), zzge2.getPrice(), null, zzge2.getExtras());
    }

    private static zze zza(zzgf zzgf2) throws RemoteException {
        return new zze(zzgf2.getHeadline(), zzgf2.getImages(), zzgf2.getBody(), zzgf2.zzeR(), zzgf2.getCallToAction(), zzgf2.getAdvertiser(), null, zzgf2.getExtras());
    }

    private static void zza(final zzla zzla2, final zzd zzd2, final String string) {
        zzla2.zzjD().zza(new zzlb.zza(){

            @Override
            public void zza(zzla zzla22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzd2.getHeadline());
                    jSONObject.put("body", (Object)zzd2.getBody());
                    jSONObject.put("call_to_action", (Object)zzd2.getCallToAction());
                    jSONObject.put("price", (Object)zzd2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzd2.getStarRating()));
                    jSONObject.put("store", (Object)zzd2.getStore());
                    jSONObject.put("icon", (Object)zzn.zza(zzd2.zzeN()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzd2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdj zzdj2 = zzn.zzd(e);
                            jSONArray.put((Object)zzn.zza(zzdj2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zzd2.getExtras(), string));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzla2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzjw.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(final zzla zzla2, final zze zze2, final String string) {
        zzla2.zzjD().zza(new zzlb.zza(){

            @Override
            public void zza(zzla zzla22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zze2.getHeadline());
                    jSONObject.put("body", (Object)zze2.getBody());
                    jSONObject.put("call_to_action", (Object)zze2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zze2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzn.zza(zze2.zzeR()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zze2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdj zzdj2 = zzn.zzd(e);
                            jSONArray.put((Object)zzn.zza(zzdj2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zze2.getExtras(), string));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzla2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzjw.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(zzla zzla2, CountDownLatch countDownLatch) {
        zzla2.zzjD().zza("/nativeExpressAssetsLoaded", zzn.zza(countDownLatch));
        zzla2.zzjD().zza("/nativeExpressAssetsLoadingFailed", zzn.zzb(countDownLatch));
    }

    static zzeh zza(final CountDownLatch countDownLatch) {
        return new zzeh(){

            @Override
            public void zza(zzla zzla2, Map<String, String> map) {
                countDownLatch.countDown();
                View view = zzla2.getView();
                if (view == null) {
                    return;
                }
                view.setVisibility(0);
            }
        };
    }

    static zzeh zzb(final CountDownLatch countDownLatch) {
        return new zzeh(){

            @Override
            public void zza(zzla zzla2, Map<String, String> map) {
                zzjw.zzaW((String)"Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzla2.destroy();
            }
        };
    }

    static zzeh zza(final @Nullable zzge zzge2, final @Nullable zzgf zzgf2, final zzf.zza zza2) {
        return new zzeh(){

            @Override
            public void zza(zzla zzla2, Map<String, String> map) {
                View view = zzla2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzge2 != null) {
                        if (!zzge2.getOverrideClickHandling()) {
                            zzge2.zzk(com.google.android.gms.dynamic.zze.zzD((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzla2);
                        }
                    } else if (zzgf2 != null) {
                        if (!zzgf2.getOverrideClickHandling()) {
                            zzgf2.zzk(com.google.android.gms.dynamic.zze.zzD((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzla2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzjw.zzd((String)"Unable to call handleClick on mapper", (Throwable)remoteException);
                }
            }
        };
    }

    private static void zza(zzla zzla2) {
        View.OnClickListener onClickListener = zzla2.zzjQ();
        if (onClickListener != null) {
            onClickListener.onClick(zzla2.getView());
        }
    }

    private static JSONObject zza(Bundle bundle, String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            if (!bundle.containsKey(string2)) continue;
            String string3 = jSONObject2.getString(string2);
            if ("image".equals(string3)) {
                object = bundle.get(string2);
                if (object instanceof Bitmap) {
                    String string4 = zzn.zza((Bitmap)object);
                    jSONObject.put(string2, (Object)string4);
                    continue;
                }
                zzjw.zzaW((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string2);
            if (object instanceof Bitmap) {
                zzjw.zzaW((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string2, (Object)String.valueOf(bundle.get(string2)));
        }
        return jSONObject;
    }

    static String zza(zzdj zzdj2) {
        if (zzdj2 == null) {
            zzjw.zzaW((String)"Image is null. Returning empty string");
            return "";
        }
        Uri uri = null;
        try {
            uri = zzdj2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzjw.zzaW((String)"Unable to get image uri. Trying data uri next");
        }
        return zzn.zzb(zzdj2);
    }

    private static String zzb(zzdj zzdj2) {
        com.google.android.gms.dynamic.zzd zzd2;
        Drawable drawable2 = null;
        try {
            zzd2 = zzdj2.zzeM();
            if (zzd2 == null) {
                zzjw.zzaW((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)com.google.android.gms.dynamic.zze.zzx((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzjw.zzaW((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzjw.zzaW((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        zzd2 = (BitmapDrawable)drawable2;
        Bitmap bitmap = zzd2.getBitmap();
        return zzn.zza(bitmap);
    }

    private static String zza(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzjw.zzaW((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = Base64.encodeToString((byte[])byArray, (int)0);
        String string2 = String.valueOf("data:image/png;base64,");
        String string3 = String.valueOf(string);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    @Nullable
    private static zzdj zzd(Object object) {
        if (object instanceof IBinder) {
            return zzdj.zza.zzy((IBinder)((IBinder)object));
        }
        return null;
    }
}

