/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.ads.afma.nano.Google3NanoAfmaSignals;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.clearcut.zzb;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzak;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzbl;
import com.google.android.gms.internal.zzcu;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzav {
    private static final String TAG = zzav.class.getSimpleName();
    protected Context zzov;
    private ExecutorService zzow;
    private DexClassLoader zzox;
    private zzas zzoy;
    private byte[] zzoz;
    private volatile AdvertisingIdClient zzoA = null;
    private volatile boolean zzod = false;
    private Future zzoB = null;
    private zzak zzoC;
    private GoogleApiClient zzoD = null;
    protected boolean zzoE = false;
    protected static final Object zzoF = new Object();
    protected boolean zzoG = false;
    private static zzc zzoH = null;
    protected boolean zzoI = false;
    private Map<Pair<String, String>, zzbl> zzoJ;

    public static zzav zza(Context context, String string2, String string3, boolean bl) {
        zzav zzav2 = new zzav(context);
        try {
            if (zzav2.zzc(string2, string3, bl)) {
                return zzav2;
            }
        }
        catch (zzau zzau2) {
            // empty catch block
        }
        return null;
    }

    public Context getContext() {
        return this.zzov;
    }

    public ExecutorService zzaD() {
        return this.zzow;
    }

    public DexClassLoader zzaE() {
        return this.zzox;
    }

    public zzas zzaF() {
        return this.zzoy;
    }

    public byte[] zzaG() {
        return this.zzoz;
    }

    public GoogleApiClient zzaH() {
        return this.zzoD;
    }

    public boolean zzaI() {
        return this.zzoE;
    }

    public boolean zzaJ() {
        return this.zzoI;
    }

    public zzak zzaK() {
        return this.zzoC;
    }

    private zzav(Context context) {
        this.zzov = context;
        this.zzoJ = new HashMap<Pair<String, String>, zzbl>();
    }

    private boolean zzc(String string2, String string3, boolean bl) throws zzau {
        boolean bl2 = false;
        this.zzow = Executors.newCachedThreadPool();
        this.zzb(bl);
        this.zzaM();
        this.zzoy = new zzas(null);
        try {
            this.zzoz = this.zzoy.zzl(string2);
        }
        catch (zzas.zza zza2) {
            throw new zzau(zza2);
        }
        bl2 = this.zzm(string3);
        this.zzoC = new zzak(this);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzm(String string2) throws zzau {
        try {
            File file = this.zzov.getCacheDir();
            if (file == null && (file = this.zzov.getDir("dex", 0)) == null) {
                throw new zzau();
            }
            String string3 = zzat.zzX();
            File file2 = this.zza(string2, file, string3);
            this.zzb(file, string3);
            try {
                this.zzox = new DexClassLoader(file2.getAbsolutePath(), file.getAbsolutePath(), null, this.zzov.getClassLoader());
                boolean bl = true;
                this.zza(file2);
                this.zza(file, string3);
            }
            catch (Throwable throwable) {
                this.zza(file2);
                this.zza(file, string3);
                this.zzn(String.format("%s/%s.dex", file, string3));
                throw throwable;
            }
            this.zzn(String.format("%s/%s.dex", file, string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new zzau(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new zzau(iOException);
        }
        catch (zzas.zza zza2) {
            throw new zzau(zza2);
        }
        catch (NullPointerException nullPointerException) {
            throw new zzau(nullPointerException);
        }
        return true;
    }

    @NonNull
    private File zza(String string2, File file, String string3) throws zzas.zza, IOException {
        File file2 = new File(String.format("%s/%s.jar", file, string3));
        if (!file2.exists()) {
            byte[] byArray = this.zzoy.zzc(this.zzoz, string2);
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(File file, String string2) {
        File file2 = new File(String.format("%s/%s.tmp", file, string2));
        if (file2.exists()) {
            return;
        }
        File file3 = new File(String.format("%s/%s.dex", file, string2));
        if (!file3.exists()) {
            return;
        }
        FileInputStream fileInputStream = null;
        long l = file3.length();
        if (l <= 0L) {
            return;
        }
        byte[] byArray = new byte[(int)l];
        try {
            fileInputStream = new FileInputStream(file3);
            int n = fileInputStream.read(byArray);
            if (n <= 0) {
                return;
            }
            Google3NanoAfmaSignals.Cache cache = new Google3NanoAfmaSignals.Cache();
            cache.osVersion = Build.VERSION.SDK.getBytes();
            cache.timestamp = string2.getBytes();
            byte[] byArray2 = this.zzoy.zzd(this.zzoz, byArray).getBytes();
            cache.data = byArray2;
            cache.hash = zzai.zze(byArray2);
            byArray = null;
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray3 = zzamj.toByteArray((zzamj)cache);
            cache = null;
            fileOutputStream.write(byArray3, 0, byArray3.length);
            fileOutputStream.close();
        }
        catch (zzas.zza | IOException | NoSuchAlgorithmException exception) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            this.zza(file3);
        }
    }

    private void zzn(String string2) {
        File file = new File(string2);
        this.zza(file);
    }

    private void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    private boolean zzb(File file, String string2) {
        File file2 = new File(String.format("%s/%s.tmp", file, string2));
        if (!file2.exists()) {
            return false;
        }
        File file3 = new File(String.format("%s/%s.dex", file, string2));
        if (file3.exists()) {
            return false;
        }
        try {
            long l = file2.length();
            if (l <= 0L) {
                this.zza(file2);
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[(int)l];
            int n = fileInputStream.read(byArray);
            if (n <= 0) {
                Log.d((String)TAG, (String)"Cannot read the cache data.");
                this.zza(file2);
                return false;
            }
            Google3NanoAfmaSignals.Cache cache = Google3NanoAfmaSignals.Cache.parseFrom(byArray);
            byArray = null;
            if (!(string2.equals(new String(cache.timestamp)) && Arrays.equals(cache.hash, zzai.zze(cache.data)) && Arrays.equals(cache.osVersion, Build.VERSION.SDK.getBytes()))) {
                this.zza(file2);
                return false;
            }
            byte[] byArray2 = this.zzoy.zzc(this.zzoz, new String(cache.data));
            file3.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byArray2, 0, byArray2.length);
            fileOutputStream.close();
        }
        catch (zzas.zza | IOException | NoSuchAlgorithmException exception) {
            return false;
        }
        return true;
    }

    public boolean zza(String string2, String string3, List<Class> list) {
        if (!this.zzoJ.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzoJ.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzbl(this, string2, string3, list));
            return true;
        }
        return false;
    }

    public Method zzc(String string2, String string3) {
        zzbl zzbl2 = this.zzoJ.get(new Pair((Object)string2, (Object)string3));
        if (zzbl2 == null) {
            return null;
        }
        return zzbl2.zzaU();
    }

    private void zzb(boolean bl) {
        this.zzod = bl;
        if (!bl) {
            return;
        }
        this.zzoB = this.zzow.submit(new Runnable(){

            @Override
            public void run() {
                zzav.this.zzaL();
            }
        });
    }

    private void zzaL() {
        try {
            if (this.zzoA == null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzov);
                advertisingIdClient.start();
                this.zzoA = advertisingIdClient;
            }
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzoA = null;
        }
    }

    private void zzaM() {
        zzoH = zzc.zzqV();
        this.zzoE = zzoH.zzae(this.zzov) > 0;
        boolean bl = this.zzoG = zzoH.isGooglePlayServicesAvailable(this.zzov) == 0;
        if (this.zzov.getApplicationContext() != null) {
            this.zzoD = new GoogleApiClient.Builder(this.zzov).addApi(zzb.API).build();
        }
        zzcu.initialize(this.zzov);
    }

    public AdvertisingIdClient zzaN() {
        if (!this.zzod) {
            return null;
        }
        if (this.zzoA != null) {
            return this.zzoA;
        }
        if (this.zzoB != null) {
            try {
                this.zzoB.get(2000L, TimeUnit.MILLISECONDS);
                this.zzoB = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzoB.cancel(true);
            }
        }
        return this.zzoA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaO() {
        Object object = zzoF;
        synchronized (object) {
            if (this.zzoI) {
                return;
            }
            if (this.zzoG && this.zzoD != null) {
                this.zzoD.connect();
                this.zzoI = true;
            } else {
                this.zzoI = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaP() {
        Object object = zzoF;
        synchronized (object) {
            if (this.zzoI && this.zzoD != null) {
                this.zzoD.disconnect();
                this.zzoI = false;
            }
        }
    }

    public int zzT() {
        int n = Integer.MIN_VALUE;
        zzak zzak2 = this.zzaK();
        if (zzak2 != null) {
            n = zzak2.zzT();
        }
        return n;
    }
}

