/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzbw;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzcc;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzla;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public abstract class zzbv
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzpp = new Object();
    private final WeakReference<zzjn> zzti;
    private WeakReference<ViewTreeObserver> zztj;
    private final zzcc zztk;
    protected final zzbx zztl;
    private final Context zztm;
    private final WindowManager zztn;
    private final PowerManager zzto;
    private final KeyguardManager zztp;
    private zzbz zztq;
    private boolean zztr;
    private boolean zzrF = false;
    private boolean zzts = false;
    private boolean zztt;
    private boolean zztu;
    private boolean zztv;
    BroadcastReceiver zztw;
    private final HashSet<zzbw> zztx = new HashSet();
    private zzkk zztc;
    private final zzeh zzty = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            if (!zzbv.this.zzb(map)) {
                return;
            }
            zzbv.this.zza(zzla2.getView(), map);
        }
    };
    private final zzeh zztz = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            if (!zzbv.this.zzb(map)) {
                return;
            }
            String string2 = String.valueOf(zzbv.this.zztl.zzdh());
            zzjw.zzaU((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
            zzbv.this.destroy();
        }
    };
    private final zzeh zztA = new zzeh(){

        @Override
        public void zza(zzla zzla2, Map<String, String> map) {
            if (!zzbv.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzbv.this.zzi(bl);
        }
    };

    public zzbv(Context context, AdSizeParcel adSizeParcel, zzjn zzjn2, VersionInfoParcel versionInfoParcel, zzcc zzcc2) {
        this.zzti = new WeakReference<zzjn>(zzjn2);
        this.zztk = zzcc2;
        this.zztj = new WeakReference<Object>(null);
        this.zztt = true;
        this.zztv = false;
        this.zztc = new zzkk(200L);
        this.zztl = new zzbx(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzvs, zzjn2.zzOW, zzjn2.zzdi(), adSizeParcel.zzvv);
        this.zztn = (WindowManager)context.getSystemService("window");
        this.zzto = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zztp = (KeyguardManager)context.getSystemService("keyguard");
        this.zztm = context;
    }

    public void zza(zzbw zzbw2) {
        this.zztx.add(zzbw2);
    }

    protected void zzi(boolean bl) {
        for (zzbw zzbw2 : this.zztx) {
            zzbw2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzcQ() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zztw != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zztw = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzbv.this.zzi(3);
                }
            };
            this.zztm.registerReceiver(this.zztw, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzcR() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zztw != null) {
                try {
                    this.zztm.unregisterReceiver(this.zztw);
                }
                catch (IllegalStateException illegalStateException) {
                    zzjw.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    zzu.zzcn().zzb(exception, true);
                }
                this.zztw = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzcW();
            this.zzcR();
            this.zztt = false;
            this.zzcT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcS() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zztt) {
                this.zztu = true;
                try {
                    JSONObject jSONObject = this.zzda();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzjw.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzjw.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zztl.zzdh());
                zzjw.zzaU((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzi(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzi(int n) {
        Object object = this.zzpp;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            if (!this.zzcY() || !this.zztt) {
                return;
            }
            View view = this.zztk.zzdb();
            this.zztv = bl2 = view != null && zzu.zzck().zza(view, this.zzto, this.zztp) && view.getGlobalVisibleRect(new Rect(), null);
            boolean bl3 = this.zztk.zzdc();
            if (bl3) {
                this.zzcS();
                return;
            }
            boolean bl4 = bl = n == 1;
            if (bl && !this.zztc.tryAcquire() && bl2 == this.zztv) {
                return;
            }
            if (!bl2 && !this.zztv && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzjw.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            this.zzcV();
            this.zzcT();
        }
    }

    protected void zzcT() {
        if (this.zztq != null) {
            this.zztq.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzcU() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zztt;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzcV() {
        zzcc zzcc2 = this.zztk.zzdd();
        View view = zzcc2.zzdb();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zztj.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzcW();
        if (!this.zztr || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zztr = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zztj = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zztl.zzdh());
    }

    protected void zzc(zzfk zzfk2) {
        zzfk2.zza("/updateActiveView", this.zzty);
        zzfk2.zza("/untrackActiveViewUnit", this.zztz);
        zzfk2.zza("/visibilityChanged", this.zztA);
    }

    protected void zzd(zzfk zzfk2) {
        zzfk2.zzb("/visibilityChanged", this.zztA);
        zzfk2.zzb("/untrackActiveViewUnit", this.zztz);
        zzfk2.zzb("/updateActiveView", this.zzty);
    }

    protected void zzcW() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zztj.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzcX() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zztl.zzdf()).put("activeViewJSON", (Object)this.zztl.zzdg()).put("timestamp", zzu.zzco().elapsedRealtime()).put("adFormat", (Object)this.zztl.zzde()).put("hashCode", (Object)this.zztl.zzdh()).put("isMraid", this.zztl.zzdi()).put("isStopped", this.zzts).put("isPaused", this.zzrF).put("isScreenOn", this.isScreenOn()).put("isNative", this.zztl.zzdj());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzb(jSONObject2);
        }
        catch (Throwable throwable) {
            zzjw.zzb((String)"Skipping active view message.", (Throwable)throwable);
        }
    }

    protected abstract void zzb(JSONObject var1);

    protected abstract boolean zzcY();

    protected JSONObject zzcZ() throws JSONException {
        return this.zzcX().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(View view) throws JSONException {
        if (view == null) {
            return this.zzcZ();
        }
        boolean bl = zzu.zzcm().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzjw.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zztn.getDefaultDisplay().getWidth();
        rect2.bottom = this.zztn.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzcX();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzu.zzck().zza(view, this.zzto, this.zztp));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzto.isScreenOn();
    }

    protected JSONObject zzda() throws JSONException {
        JSONObject jSONObject = this.zzcX();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzi(1);
    }

    public void onGlobalLayout() {
        this.zzi(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzbz zzbz2) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zztq = zzbz2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzts = true;
            this.zzi(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzrF = true;
            this.zzi(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzrF = false;
            this.zzi(3);
        }
    }

    public static class zzb
    implements zzcc {
        private zzh zztD;

        public zzb(zzh zzh2) {
            this.zztD = zzh2;
        }

        @Override
        public View zzdb() {
            return this.zztD.zzeV();
        }

        @Override
        public boolean zzdc() {
            return this.zztD == null;
        }

        @Override
        public zzcc zzdd() {
            return this;
        }
    }

    public static class zza
    implements zzcc {
        private WeakReference<zzh> zztC;

        public zza(zzh zzh2) {
            this.zztC = new WeakReference<zzh>(zzh2);
        }

        @Override
        public View zzdb() {
            zzh zzh2 = (zzh)this.zztC.get();
            return zzh2 != null ? zzh2.zzeV() : null;
        }

        @Override
        public boolean zzdc() {
            return this.zztC.get() == null;
        }

        @Override
        public zzcc zzdd() {
            return new zzb((zzh)this.zztC.get());
        }
    }

    public static class zzc
    implements zzcc {
        private final View mView;
        private final zzjn zztE;

        public zzc(View view, zzjn zzjn2) {
            this.mView = view;
            this.zztE = zzjn2;
        }

        @Override
        public View zzdb() {
            return this.mView;
        }

        @Override
        public boolean zzdc() {
            return this.zztE == null || this.mView == null;
        }

        @Override
        public zzcc zzdd() {
            return this;
        }
    }

    public static class zzd
    implements zzcc {
        private final WeakReference<View> zztF;
        private final WeakReference<zzjn> zztG;

        public zzd(View view, zzjn zzjn2) {
            this.zztF = new WeakReference<View>(view);
            this.zztG = new WeakReference<zzjn>(zzjn2);
        }

        @Override
        public View zzdb() {
            return (View)this.zztF.get();
        }

        @Override
        public boolean zzdc() {
            return this.zztF.get() == null || this.zztG.get() == null;
        }

        @Override
        public zzcc zzdd() {
            return new zzc((View)this.zztF.get(), (zzjn)this.zztG.get());
        }
    }
}

