/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzla;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
@TargetApi(value=14)
public class zzcg
extends Thread {
    private boolean mStarted = false;
    private boolean zzuk = false;
    private boolean zzal = false;
    private final Object zzpp;
    private final zzcf zzul;
    private final zzce zzum;
    private final zzif zzun;
    private final int zzuo;
    private final int zztW;
    private final int zzup;
    private final int zztY;
    private final int zzuq;

    public zzcg(zzcf zzcf2, zzce zzce2, zzif zzif2) {
        this.zzul = zzcf2;
        this.zzum = zzce2;
        this.zzun = zzif2;
        this.zzpp = new Object();
        this.zztW = zzcu.zzxJ.get();
        this.zzup = zzcu.zzxK.get();
        this.zztY = zzcu.zzxL.get();
        this.zzuq = zzcu.zzxM.get();
        this.zzuo = zzcu.zzxN.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzdt() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.mStarted) {
                zzjw.zzaU((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (false) break;
            try {
                if (this.zzdu()) {
                    object = this.zzul.getActivity();
                    if (object == null) {
                        zzjw.zzaU((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzdw();
                    } else {
                        this.zza((Activity)object);
                    }
                } else {
                    zzjw.zzaU((String)"ContentFetchTask: sleeping");
                    this.zzdw();
                }
                Thread.sleep(this.zzuo * 1000);
            }
            catch (Throwable throwable) {
                zzjw.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzun.zza(throwable, true);
            }
            object = this.zzpp;
            synchronized (object) {
                while (this.zzuk) {
                    try {
                        zzjw.zzaU((String)"ContentFetchTask: waiting");
                        this.zzpp.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zze(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzcg.this.zzf(view);
            }
        });
        return true;
    }

    void zzf(View view) {
        try {
            zzcd zzcd2 = new zzcd(this.zztW, this.zzup, this.zztY, this.zzuq);
            zza zza2 = this.zza(view, zzcd2);
            zzcd2.zzdq();
            if (zza2.zzuy == 0 && zza2.zzuz == 0) {
                return;
            }
            if (zza2.zzuz == 0 && zzcd2.zzdr() == 0) {
                return;
            }
            if (zza2.zzuz == 0 && this.zzum.zza(zzcd2)) {
                return;
            }
            this.zzum.zzc(zzcd2);
        }
        catch (Exception exception) {
            zzjw.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzun.zza(exception, true);
        }
    }

    boolean zzj(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzdu() {
        try {
            Context context = this.zzul.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzj(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zze(view);
    }

    zza zza(View view, zzcd zzcd2) {
        if (view == null) {
            return new zza(0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzcd2.zze(string2, bl);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzla)) {
            zzcd2.zzdp();
            if (this.zza((WebView)view, zzcd2, bl)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzcd2);
                n += zza2.zzuy;
                n2 += zza2.zzuz;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    @TargetApi(value=19)
    boolean zza(final WebView webView, final zzcd zzcd2, final boolean bl) {
        if (!zzs.zzve()) {
            return false;
        }
        zzcd2.zzdp();
        webView.post(new Runnable(){
            ValueCallback<String> zzut = new ValueCallback<String>(){

                public void zzz(String string2) {
                    zzcg.this.zza(zzcd2, webView, string2, bl);
                }

                public /* synthetic */ void onReceiveValue(Object object) {
                    this.zzz((String)object);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzut);
                    }
                    catch (Throwable throwable) {
                        this.zzut.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzcd zzcd2, WebView webView, String string2, boolean bl) {
        zzcd2.zzdo();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzcd2.zzd(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl);
                } else {
                    zzcd2.zzd(string3, bl);
                }
            }
            if (zzcd2.zzdk()) {
                this.zzum.zzb(zzcd2);
            }
        }
        catch (JSONException jSONException) {
            zzjw.zzaU((String)"Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzjw.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzun.zza(throwable, true);
        }
    }

    public zzcd zzdv() {
        return this.zzum.zzds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzuk = false;
            this.zzpp.notifyAll();
            zzjw.zzaU((String)"ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzdw() {
        Object object = this.zzpp;
        synchronized (object) {
            boolean bl = this.zzuk = true;
            zzjw.zzaU((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
        }
    }

    public boolean zzdx() {
        return this.zzuk;
    }

    @zzig
    class zza {
        final int zzuy;
        final int zzuz;

        zza(int n, int n2) {
            this.zzuy = n;
            this.zzuz = n2;
        }
    }
}

