/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;

@zzig
class zzv
implements SensorEventListener {
    private final SensorManager zzIb;
    private final Object zzIc;
    private final Display zzId;
    private final float[] zzIe;
    private final float[] zzIf;
    private float[] zzIg;
    private Handler zzIh;
    private zza zzIi;

    zzv(Context context) {
        this.zzIb = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzId = windowManager.getDefaultDisplay();
        this.zzIe = new float[9];
        this.zzIf = new float[9];
        this.zzIc = new Object();
    }

    int getRotation() {
        return this.zzId.getRotation();
    }

    void start() {
        if (this.zzIh != null) {
            return;
        }
        Sensor sensor = this.zzIb.getDefaultSensor(11);
        if (sensor == null) {
            zzjw.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzIh = new Handler(handlerThread.getLooper());
        boolean bl = this.zzIb.registerListener((SensorEventListener)this, sensor, 0, this.zzIh);
        if (!bl) {
            zzjw.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    void stop() {
        if (this.zzIh == null) {
            return;
        }
        this.zzIb.unregisterListener((SensorEventListener)this);
        this.zzIh.post(new Runnable(){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.zzIh = null;
    }

    void zza(zza zza2) {
        this.zzIi = zza2;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.zza(sensorEvent.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            return;
        }
        Object object = this.zzIc;
        synchronized (object) {
            if (this.zzIg == null) {
                this.zzIg = new float[9];
            }
        }
        SensorManager.getRotationMatrixFromVector((float[])this.zzIe, (float[])fArray);
        int n = this.getRotation();
        switch (n) {
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.zzIe, (int)2, (int)129, (float[])this.zzIf);
                break;
            }
            case 2: {
                SensorManager.remapCoordinateSystem((float[])this.zzIe, (int)129, (int)130, (float[])this.zzIf);
                break;
            }
            case 3: {
                SensorManager.remapCoordinateSystem((float[])this.zzIe, (int)130, (int)1, (float[])this.zzIf);
                break;
            }
            default: {
                System.arraycopy(this.zzIe, 0, this.zzIf, 0, 9);
            }
        }
        this.zzf(1, 3);
        this.zzf(2, 6);
        this.zzf(5, 7);
        Object object2 = this.zzIc;
        synchronized (object2) {
            System.arraycopy(this.zzIf, 0, this.zzIg, 0, 9);
        }
        if (this.zzIi != null) {
            this.zzIi.zzgt();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzb(float[] fArray) {
        Object object = this.zzIc;
        synchronized (object) {
            if (this.zzIg == null) {
                return false;
            }
            System.arraycopy(this.zzIg, 0, fArray, 0, this.zzIg.length);
            return true;
        }
    }

    private void zzf(int n, int n2) {
        float f = this.zzIf[n];
        this.zzIf[n] = this.zzIf[n2];
        this.zzIf[n2] = f;
    }

    static interface zza {
        public void zzgt();
    }
}

