/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcq;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzig
@TargetApi(value=14)
public class zzw
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzv.zza {
    private static final float[] zzIk = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzv zzIl;
    private final float[] zzIg;
    private final float[] zzIm;
    private final float[] zzIn;
    private final float[] zzIo;
    private final float[] zzIp;
    private final float[] zzIq;
    private final float[] zzIr;
    private float zzIs;
    private float zzIt;
    private int zzpj;
    private int zzpi;
    private SurfaceTexture zzIu;
    private SurfaceTexture zzIv;
    private int zzIw;
    private int zzIx;
    private int zzIy;
    private FloatBuffer zzIz = ByteBuffer.allocateDirect(zzIk.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzIA;
    private final Object zzIB;
    private EGL10 zzIC;
    private EGLDisplay zzID;
    private EGLContext zzIE;
    private EGLSurface zzIF;
    private volatile boolean zzIG;
    private volatile boolean zzIH;

    zzw(Context context) {
        super("SphericalVideoProcessor");
        this.zzIz.put(zzIk).position(0);
        this.zzIg = new float[9];
        this.zzIm = new float[9];
        this.zzIn = new float[9];
        this.zzIo = new float[9];
        this.zzIp = new float[9];
        this.zzIq = new float[9];
        this.zzIr = new float[9];
        this.zzIs = Float.NaN;
        this.zzIl = new zzv(context);
        this.zzIl.zza(this);
        this.zzIA = new CountDownLatch(1);
        this.zzIB = new Object();
    }

    void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzpi = n;
        this.zzpj = n2;
        this.zzIv = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzg(int n, int n2) {
        Object object = this.zzIB;
        synchronized (object) {
            this.zzpi = n;
            this.zzpj = n2;
            this.zzIG = true;
            this.zzIB.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzgR() {
        Object object = this.zzIB;
        synchronized (object) {
            this.zzIH = true;
            this.zzIv = null;
            this.zzIB.notifyAll();
        }
    }

    public SurfaceTexture zzgS() {
        if (this.zzIv == null) {
            return null;
        }
        try {
            this.zzIA.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.zzIu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzIy;
        Object object = this.zzIB;
        synchronized (object) {
            this.zzIB.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzgt() {
        Object object = this.zzIB;
        synchronized (object) {
            this.zzIB.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        if (this.zzIv == null) {
            zzjw.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzIA.countDown();
            return;
        }
        boolean bl2 = this.zzgX();
        int n = this.zzgV();
        boolean bl3 = bl = this.zzIw != 0;
        if (!bl2 || !bl) {
            String string = GLUtils.getEGLErrorString((int)this.zzIC.eglGetError());
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "EGL initialization failed: ".concat(string2) : new String("EGL initialization failed: ");
            zzjw.e((String)string3);
            zzu.zzcn().zzb(new Throwable(string3), true);
            this.zzhb();
            this.zzIA.countDown();
            return;
        }
        this.zzIu = new SurfaceTexture(n);
        this.zzIu.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzIA.countDown();
        this.zzIl.start();
        try {
            this.zzIG = true;
            while (!this.zzIH) {
                this.zzgT();
                if (this.zzIG) {
                    this.zzgU();
                    this.zzIG = false;
                }
                try {
                    Object object = this.zzIB;
                    synchronized (object) {
                        if (!this.zzIH && !this.zzIG && this.zzIy == 0) {
                            this.zzIB.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            zzjw.zzaW((String)"SphericalVideoProcessor halted unexpectedly.");
        }
        catch (Throwable throwable) {
            zzjw.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzu.zzcn().zzb(throwable, true);
        }
        finally {
            this.zzIl.stop();
            this.zzIu.setOnFrameAvailableListener(null);
            this.zzIu = null;
            this.zzhb();
        }
    }

    void zzgT() {
        while (this.zzIy > 0) {
            this.zzIu.updateTexImage();
            --this.zzIy;
        }
        if (this.zzIl.zzb(this.zzIg)) {
            if (Float.isNaN(this.zzIs)) {
                this.zzIs = -this.zzc(this.zzIg);
            }
            this.zzb(this.zzIq, this.zzIs);
        } else {
            this.zza(this.zzIg, -1.5707964f);
            this.zzb(this.zzIq, 0.0f);
        }
        this.zza(this.zzIm, 1.5707964f);
        this.zza(this.zzIn, this.zzIq, this.zzIm);
        this.zza(this.zzIo, this.zzIg, this.zzIn);
        this.zza(this.zzIp, this.zzIt);
        this.zza(this.zzIr, this.zzIp, this.zzIo);
        GLES20.glUniformMatrix3fv((int)this.zzIx, (int)1, (boolean)false, (float[])this.zzIr, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.zzaw("drawArrays");
        GLES20.glFinish();
        this.zzIC.eglSwapBuffers(this.zzID, this.zzIF);
    }

    private float zzc(float[] fArray) {
        float[] fArray2 = this.zza(fArray, new float[]{0.0f, 1.0f, 0.0f});
        return (float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f;
    }

    void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzpi > this.zzpj) {
            f4 = 1.7453293f * f / (float)this.zzpi;
            f3 = 1.7453293f * f2 / (float)this.zzpi;
        } else {
            f4 = 1.7453293f * f / (float)this.zzpj;
            f3 = 1.7453293f * f2 / (float)this.zzpj;
        }
        this.zzIs -= f4;
        this.zzIt -= f3;
        if (this.zzIt < -1.5707964f) {
            this.zzIt = -1.5707964f;
        }
        if (this.zzIt > 1.5707964f) {
            this.zzIt = 1.5707964f;
        }
    }

    private void zzgU() {
        GLES20.glViewport((int)0, (int)0, (int)this.zzpi, (int)this.zzpj);
        this.zzaw("viewport");
        int n = GLES20.glGetUniformLocation((int)this.zzIw, (String)"uFOVx");
        int n2 = GLES20.glGetUniformLocation((int)this.zzIw, (String)"uFOVy");
        if (this.zzpi > this.zzpj) {
            GLES20.glUniform1f((int)n, (float)0.87266463f);
            GLES20.glUniform1f((int)n2, (float)(0.87266463f * (float)this.zzpj / (float)this.zzpi));
        } else {
            GLES20.glUniform1f((int)n, (float)(0.87266463f * (float)this.zzpi / (float)this.zzpj));
            GLES20.glUniform1f((int)n2, (float)0.87266463f);
        }
    }

    private float[] zza(float[] fArray, float[] fArray2) {
        return new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2], fArray[3] * fArray2[0] + fArray[4] * fArray2[1] + fArray[5] * fArray2[2], fArray[6] * fArray2[0] + fArray[7] * fArray2[1] + fArray[8] * fArray2[2]};
    }

    private void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    int zzgV() {
        this.zzIw = this.zzgW();
        GLES20.glUseProgram((int)this.zzIw);
        this.zzaw("useProgram");
        int n = GLES20.glGetAttribLocation((int)this.zzIw, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.zzIz);
        this.zzaw("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n);
        this.zzaw("enableVertexAttribArray");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.zzaw("genTextures");
        int n2 = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n2);
        this.zzaw("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        this.zzaw("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        this.zzaw("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        this.zzaw("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.zzaw("texParameteri");
        this.zzIx = GLES20.glGetUniformLocation((int)this.zzIw, (String)"uVMat");
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)this.zzIx, (int)1, (boolean)false, (float[])fArray, (int)0);
        return n2;
    }

    private int zzgW() {
        int n = this.zzc(35633, this.zzgZ());
        if (n == 0) {
            return 0;
        }
        int n2 = this.zzc(35632, this.zzha());
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        this.zzaw("createProgram");
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            this.zzaw("attachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            this.zzaw("attachShader");
            GLES20.glLinkProgram((int)n3);
            this.zzaw("linkProgram");
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            this.zzaw("getProgramiv");
            if (nArray[0] != 1) {
                Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                this.zzaw("deleteProgram");
                n3 = 0;
            } else {
                GLES20.glValidateProgram((int)n3);
                this.zzaw("validateProgram");
            }
        }
        return n3;
    }

    private int zzc(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        this.zzaw("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            this.zzaw("shaderSource");
            GLES20.glCompileShader((int)n2);
            this.zzaw("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            this.zzaw("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                this.zzaw("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    boolean zzgX() {
        this.zzIC = (EGL10)EGLContext.getEGL();
        this.zzID = this.zzIC.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.zzID == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        int[] nArray = new int[2];
        if (!this.zzIC.eglInitialize(this.zzID, nArray)) {
            return false;
        }
        EGLConfig eGLConfig = this.zzgY();
        if (eGLConfig == null) {
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        this.zzIE = this.zzIC.eglCreateContext(this.zzID, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray2);
        if (this.zzIE == null || this.zzIE == EGL10.EGL_NO_CONTEXT) {
            return false;
        }
        this.zzIF = this.zzIC.eglCreateWindowSurface(this.zzID, eGLConfig, (Object)this.zzIv, null);
        if (this.zzIF == null || this.zzIF == EGL10.EGL_NO_SURFACE) {
            return false;
        }
        return this.zzIC.eglMakeCurrent(this.zzID, this.zzIF, this.zzIF, this.zzIE);
    }

    @Nullable
    private EGLConfig zzgY() {
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
        if (!this.zzIC.eglChooseConfig(this.zzID, nArray2, eGLConfigArray, 1, nArray)) {
            return null;
        }
        if (nArray[0] > 0) {
            return eGLConfigArray[0];
        }
        return null;
    }

    private String zzgZ() {
        zzcq<String> zzcq2 = zzcu.zzyn;
        if (!zzcq2.get().equals(zzcq2.zzeq())) {
            return zzcq2.get();
        }
        return "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
    }

    private String zzha() {
        zzcq<String> zzcq2 = zzcu.zzyo;
        if (!zzcq2.get().equals(zzcq2.zzeq())) {
            return zzcq2.get();
        }
        return "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
    }

    boolean zzhb() {
        boolean bl = false;
        if (this.zzIF != null && this.zzIF != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzIC.eglMakeCurrent(this.zzID, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            bl |= this.zzIC.eglDestroySurface(this.zzID, this.zzIF);
            this.zzIF = null;
        }
        if (this.zzIE != null) {
            bl |= this.zzIC.eglDestroyContext(this.zzID, this.zzIE);
            this.zzIE = null;
        }
        if (this.zzID != null) {
            bl |= this.zzIC.eglTerminate(this.zzID);
            this.zzID = null;
        }
        return bl;
    }

    private void zzaw(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string).length()).append(string).append(": glError ").append(n).toString());
        }
    }
}

