/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzig
public class zzc
extends zzjv
implements ServiceConnection {
    private final Object zzpp = new Object();
    private boolean zzJj = false;
    private Context mContext;
    private zzhl zzDw;
    private zzb zzJk;
    private zzh zzJl;
    private List<zzf> zzJm = null;
    private zzk zzJn;

    public zzc(Context context, zzhl zzhl2, zzk zzk2) {
        this(context, zzhl2, zzk2, new zzb(context), zzh.zzr(context.getApplicationContext()));
    }

    zzc(Context context, zzhl zzhl2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzDw = zzhl2;
        this.zzJn = zzk2;
        this.zzJk = zzb2;
        this.zzJl = zzh2;
        this.zzJm = this.zzJl.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbQ() {
        Object object = this.zzpp;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzuH().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzuH().zza(this.mContext, (ServiceConnection)this);
            this.zzJk.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzpp;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzuH().zza(this.mContext, (ServiceConnection)this);
            this.zzJk.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        zzjw.zzaV((String)"In-app billing service disconnected.");
        this.zzJk.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Object object = this.zzpp;
        synchronized (object) {
            this.zzJk.zzS(iBinder);
            this.zzhl();
            this.zzJj = true;
            this.zzpp.notify();
        }
    }

    protected void zzhl() {
        int n;
        Bundle bundle;
        if (this.zzJm.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzJm) {
            hashMap.put(object2.zzJz, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzJk.zzl(this.mContext.getPackageName(), (String)object3)) != null && (n = zzu.zzcu().zze(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string = (String)arrayList.get(i);
                String string2 = (String)arrayList2.get(i);
                String string3 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string);
                String string4 = zzu.zzcu().zzax(string2);
                if (!zzf2.zzJy.equals(string4)) continue;
                this.zza(zzf2, string2, string3);
                hashMap.remove(string);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string : hashMap.keySet()) {
            this.zzJl.zza((zzf)hashMap.get(string));
        }
    }

    protected void zza(final zzf zzf2, String string, String string2) {
        final Intent intent = new Intent();
        zzu.zzcu();
        intent.putExtra("RESPONSE_CODE", 0);
        zzu.zzcu();
        intent.putExtra("INAPP_PURCHASE_DATA", string);
        zzu.zzcu();
        intent.putExtra("INAPP_DATA_SIGNATURE", string2);
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzJn.zza(zzf2.zzJy, -1, intent)) {
                        zzc.this.zzDw.zza((zzhk)new zzg(zzc.this.mContext, zzf2.zzJz, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzDw.zza((zzhk)new zzg(zzc.this.mContext, zzf2.zzJz, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzjw.zzaW((String)"Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l) {
        do {
            if (this.zzf(l)) continue;
            zzjw.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzJj);
    }

    private boolean zzf(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzpp.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            zzjw.zzaW((String)"waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

